/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;

public final class IncludeCacheValidity
implements CacheValidity {
    private List sources;
    private List timeStamps;
    private boolean isNew;
    private SourceResolver resolver;

    public IncludeCacheValidity(SourceResolver resolver) {
        this.resolver = resolver;
        this.sources = new ArrayList();
        this.timeStamps = new ArrayList();
        this.isNew = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew2False() {
        this.isNew = false;
        this.resolver = null;
    }

    public void add(String source, long timeStamp) {
        this.sources.add(source);
        this.timeStamps.add(new Long(timeStamp));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(CacheValidity validity) {
        if (!(validity instanceof IncludeCacheValidity)) {
            return false;
        }
        SourceResolver otherResolver = ((IncludeCacheValidity)validity).resolver;
        Iterator i = this.sources.iterator();
        Iterator j = this.timeStamps.iterator();
        while (true) {
            Object var12_8;
            Source otherSource;
            block8: {
                boolean bl;
                if (!i.hasNext()) {
                    return true;
                }
                String src = (String)i.next();
                long timeStamp = (Long)j.next();
                otherSource = null;
                try {
                    try {
                        otherSource = otherResolver.resolve(src);
                        if (otherSource.getLastModified() == timeStamp && timeStamp != 0L) break block8;
                        bl = false;
                        var12_8 = null;
                        if (otherSource == null) return bl;
                    }
                    catch (Exception e) {
                        boolean bl2 = false;
                        var12_8 = null;
                        if (otherSource == null) return bl2;
                        otherSource.recycle();
                        return bl2;
                    }
                }
                catch (Throwable throwable) {
                    var12_8 = null;
                    if (otherSource != null) {
                        otherSource.recycle();
                    }
                    throw throwable;
                }
                otherSource.recycle();
                return bl;
            }
            var12_8 = null;
            if (otherSource == null) continue;
            otherSource.recycle();
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Include Validity[");
        Iterator i = this.sources.iterator();
        Iterator j = this.timeStamps.iterator();
        while (i.hasNext()) {
            b.append('{');
            b.append(i.next());
            b.append(':');
            b.append(j.next());
            b.append('}');
            if (!i.hasNext()) continue;
            b.append(':');
        }
        b.append(']');
        return b.toString();
    }
}

