/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Row;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Workbook;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;

class Sheet
extends AbstractLoggable {
    private HSSFSheet _sheet;
    private String _name;
    private int _physical_index;
    private Workbook _workbook;
    private Map _rows;
    private Map regions;
    private static final int ROWS_CAPACITY = 200;
    private static final int REGION_CAPACITY = 20;
    private static final int DEBUG = 0;

    Sheet(Workbook workbook) {
        this._workbook = workbook;
        this._name = this._workbook.getNextName();
        this._sheet = this._workbook.createSheet(this._name);
        this._physical_index = this._workbook.getPhysicalIndex(this._name);
        this._rows = new HashMap(200);
        this.regions = new HashMap(20);
    }

    void renameSheet(String new_name) {
        if (!this._name.equals(new_name)) {
            this._workbook.renameSheet(this._physical_index, new_name);
            this._name = new_name;
        }
    }

    void setColumnWidth(int number, double points) throws IOException {
        if (number < 0 || number > Short.MAX_VALUE) {
            throw new IOException("column number " + number + " is too large");
        }
        if (!this.isValidColumnPoints(points)) {
            throw new IOException("points " + points + " is out of range");
        }
        this._sheet.setColumnWidth((short)number, (short)(points * 48.0 + 0.5));
    }

    short getColumnWidth(short number) {
        return this._sheet.getColumnWidth(number);
    }

    void setDefaultColumnWidth(double width) throws IOException {
        if (width < 0.0 || width >= 157284.0) {
            throw new IOException("Invalid width (" + width + ")");
        }
        this._sheet.setDefaultColumnWidth((short)(width / 4.8 + 0.5));
    }

    short getDefaultColumnWidth() {
        return this._sheet.getDefaultColumnWidth();
    }

    void setDefaultRowHeight(double height) throws IOException {
        if (!this.isValidPoints(height)) {
            throw new IOException("Invalid height (" + height + ")");
        }
        this._sheet.setDefaultRowHeight((short)(height * 20.0 + 0.5));
    }

    short getDefaultRowHeight() {
        return this._sheet.getDefaultRowHeight();
    }

    String getName() {
        return this._name;
    }

    int getIndex() {
        return this._physical_index;
    }

    Row getRow(short rowNo) throws IOException {
        if (rowNo < 0) {
            throw new IOException("Illegal row number: " + rowNo);
        }
        Short key = new Short(rowNo);
        Object o = this._rows.get(key);
        Row rval = null;
        if (o == null) {
            rval = this.createRow(rowNo);
            this._rows.put(key, rval);
        } else {
            rval = (Row)o;
        }
        return rval;
    }

    HSSFCellStyle addStyleRegion(Region region) {
        HSSFCellStyle style = this._workbook.createStyle();
        this.regions.put(region, style);
        return style;
    }

    HSSFCellStyle getCellStyleForRegion(short row, short col) {
        Iterator iregions = this.regions.keySet().iterator();
        while (iregions.hasNext()) {
            Region region = (Region)iregions.next();
            if (!region.contains((int)row, col)) continue;
            return (HSSFCellStyle)this.regions.get(region);
        }
        return null;
    }

    private Row createRow(short rowNo) {
        return new Row(this._sheet.createRow(rowNo), this);
    }

    private boolean isValidPoints(double points) {
        return points >= 0.0 && points <= 1638.375;
    }

    private boolean isValidColumnPoints(double points) {
        return points >= 0.0 && points <= 682.65625;
    }

    private boolean isValidCharacters(double characters) {
        return characters >= 0.0 && characters <= 127.998046875;
    }

    public void assignBlanksToRegions() {
        Iterator iregions = this.regions.keySet().iterator();
        while (iregions.hasNext()) {
            Region region = (Region)iregions.next();
            int rownum = region.getRowFrom();
            while (rownum < region.getRowTo() + 1) {
                HSSFRow row = this._sheet.getRow(rownum);
                short colnum = region.getColumnFrom();
                while (colnum < region.getColumnTo() + 1) {
                    HSSFCellStyle style = (HSSFCellStyle)this.regions.get(region);
                    if (!this.isBlank(style)) {
                        HSSFCell cell;
                        if (row == null) {
                            if (rownum > Short.MAX_VALUE) {
                                rownum = Short.MAX_VALUE;
                            }
                            row = this._sheet.createRow((short)rownum);
                        }
                        if ((cell = row.getCell(colnum)) == null) {
                            cell = row.createCell(colnum, 3);
                            cell.setCellStyle((HSSFCellStyle)this.regions.get(region));
                        }
                    }
                    colnum = (short)(colnum + 1);
                }
                ++rownum;
            }
        }
    }

    private boolean isBlank(HSSFCellStyle style) {
        HSSFFont font = null;
        if (style.getFontIndex() > 0) {
            font = this._workbook.getWorkbook().getFontAt(style.getFontIndex());
        }
        return style.getBorderBottom() == 0 && style.getBorderTop() == 0 && style.getBorderRight() == 0 && style.getBorderLeft() == 0 && style.getFillBackgroundColor() == 9 && style.getFillPattern() == 0 && (style.getFontIndex() == 0 || (font.getFontName().equals("Arial") || font.getFontName().equals("Helvetica")) && font.getFontHeightInPoints() > 8 && font.getFontHeightInPoints() < 12);
    }
}

