/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.CascadingRuntimeException;

public class EsqlConnection
implements Connection {
    public static final int LIMIT_METHOD_NOLIMIT = 0;
    public static final int LIMIT_METHOD_POSTGRESQL = 1;
    public static final int LIMIT_METHOD_MYSQL = 2;
    public static final int LIMIT_METHOD_JDBC = 3;
    public Connection connection = null;
    private String url = null;
    private Properties info = new Properties();
    private int limitMethod = 0;
    private boolean multipleResults = false;

    public boolean multipleResults() {
        return this.multipleResults;
    }

    public void setMultipleResults(String value) {
        if (value != null) {
            this.multipleResults = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
    }

    public Properties getInfo() {
        return this.info;
    }

    public String getUrl() {
        if (this.url == null) {
            try {
                this.url = this.connection.getMetaData().getURL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProperty(String name, Object value) {
        this.info.put(name, value);
    }

    public void setUser(String user) {
        this.setProperty("user", user);
    }

    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    public int getLimitMethod() {
        return this.limitMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLimitMethod(String method) {
        if ("".equals(method) || "auto".equals(method)) {
            String jdbcSource;
            try {
                jdbcSource = this.connection.getMetaData().getURL();
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error accessing connection metadata", (Throwable)e);
            }
            if (jdbcSource.startsWith("jdbc:postgresql:")) {
                this.limitMethod = 1;
                return;
            } else if (jdbcSource.startsWith("jdbc:mysql:")) {
                this.limitMethod = 2;
                return;
            } else {
                if (!jdbcSource.startsWith("jdbc:sybase:")) throw new RuntimeException("Cannot guess limit method from jdbc url: " + method);
                this.limitMethod = 3;
            }
            return;
        }
        if ("postgresql".equals(method)) {
            this.limitMethod = 1;
            return;
        } else if ("mysql".equals(method)) {
            this.limitMethod = 2;
            return;
        } else {
            if (!"jdbc".equals(method)) throw new RuntimeException("Unknown limit method: " + method);
            this.limitMethod = 3;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public Statement createStatement(int i1, int i2) throws SQLException {
        return this.connection.createStatement(i1, i2);
    }

    public PreparedStatement prepareStatement(String s) throws SQLException {
        return this.connection.prepareStatement(s);
    }

    public PreparedStatement prepareStatement(String s, int i1, int i2) throws SQLException {
        return this.connection.prepareStatement(s, i1, i2);
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.connection.setAutoCommit(autocommit);
    }

    public void setTransactionIsolation(int i) throws SQLException {
        this.connection.setTransactionIsolation(i);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public void setCatalog(String s) throws SQLException {
        this.connection.setCatalog(s);
    }

    public void setTypeMap(Map m) throws SQLException {
        this.connection.setTypeMap(m);
    }

    public void setReadOnly(boolean b) throws SQLException {
        this.connection.setReadOnly(b);
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String s) throws SQLException {
        return this.connection.nativeSQL(s);
    }

    public CallableStatement prepareCall(String s) throws SQLException {
        return this.connection.prepareCall(s);
    }

    public CallableStatement prepareCall(String s, int i1, int i2) throws SQLException {
        return this.connection.prepareCall(s, i1, i2);
    }
}

