/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.InputModule;

public class XMLMetaModule
extends AbstractMetaModule {
    protected String rootName = "root";
    protected String ignore = null;
    protected String use = null;
    protected String strip = null;
    static final Vector returnNames;

    public void configure(Configuration config2) throws ConfigurationException {
        this.inputConf = config2.getChild("input-module");
        this.rootName = this.inputConf.getAttribute("root", this.rootName);
        this.ignore = this.inputConf.getAttribute("ignore", this.ignore);
        this.use = this.inputConf.getAttribute("use", this.use);
        this.strip = this.inputConf.getAttribute("strip", this.strip);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        String rootName = this.rootName;
        String ignore = this.ignore;
        String use = this.use;
        String strip = this.strip;
        if (modeConf != null) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            rootName = modeConf.getAttribute("root", this.rootName);
            ignore = modeConf.getAttribute("ignore", this.ignore);
            use = modeConf.getAttribute("use", this.use);
            strip = modeConf.getAttribute("strip", this.strip);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
        }
        InputModule input = null;
        if (inputName != null) {
            input = this.obtainModule(inputName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(rootName).append('>');
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, input, inputName, inputConfig);
        while (names.hasNext()) {
            String attribute = (String)names.next();
            if (use != null && !attribute.startsWith(use) || ignore != null && attribute.startsWith(ignore)) continue;
            Object[] values = this.getValues(attribute, objectModel, this.input, this.defaultInput, this.inputConf, input, inputName, inputConfig);
            if (strip != null && attribute.startsWith(strip)) {
                attribute = attribute.substring(strip.length());
            }
            sb.append("<item name=\"").append(attribute).append("\">");
            if (values.length == 1) {
                sb.append(values[0]);
            } else {
                int i = 0;
                while (i < values.length) {
                    sb.append("<value>").append(values[i]).append("</value>");
                    ++i;
                }
            }
            sb.append("</item>");
        }
        if (input != null) {
            this.releaseModule(input);
        }
        sb.append('<').append('/').append(rootName).append('>');
        return sb.toString();
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        return returnNames.iterator();
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Object[] values = new Object[]{this.getAttribute(name, modeConf, objectModel)};
        return values;
    }

    static {
        Vector<String> tmp = new Vector<String>();
        tmp.add("XML");
        returnNames = tmp;
    }
}

