/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.parser;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.parser.Parser;
import org.apache.cocoon.components.resolver.Resolver;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JaxpParser
extends AbstractXMLProducer
implements Parser,
ErrorHandler,
Composable,
Parameterizable,
Disposable,
Poolable {
    protected SAXParserFactory factory;
    protected DocumentBuilderFactory docFactory;
    protected XMLReader reader;
    protected DocumentBuilder docBuilder;
    protected ComponentManager manager;
    protected Resolver resolver;
    protected boolean nsPrefixes;
    protected boolean reuseParsers;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (manager.hasComponent("org.apache.cocoon.components.resolver.Resolver")) {
            this.getLogger().debug("Looking up org.apache.cocoon.components.resolver.Resolver");
            this.resolver = (Resolver)manager.lookup("org.apache.cocoon.components.resolver.Resolver");
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.resolver);
        }
    }

    public void parameterize(Parameters params) throws ParameterException {
        Class factoryClass;
        boolean validate = params.getParameterAsBoolean("validate", false);
        this.nsPrefixes = params.getParameterAsBoolean("namespace-prefixes", false);
        this.reuseParsers = params.getParameterAsBoolean("reuse-parsers", true);
        String className = params.getParameter("sax-parser-factory", null);
        if (className == null) {
            this.factory = SAXParserFactory.newInstance();
        } else {
            try {
                factoryClass = ClassUtils.loadClass(className);
                this.factory = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load SAXParserFactory class " + className, (Throwable)e);
            }
        }
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(validate);
        className = params.getParameter("document-builder-factory", null);
        if (className == null) {
            this.docFactory = DocumentBuilderFactory.newInstance();
        } else {
            try {
                factoryClass = ClassUtils.loadClass(className);
                this.docFactory = (DocumentBuilderFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load DocumentBuilderFactory class " + className, (Throwable)e);
            }
        }
        this.docFactory.setNamespaceAware(true);
        this.docFactory.setValidating(validate);
    }

    public void parse(InputSource in) throws SAXException, IOException {
        this.setupXMLReader();
        try {
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        catch (SAXException e) {
            this.getLogger().warn("SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        this.reader.setErrorHandler(this);
        this.reader.setContentHandler(this.contentHandler);
        if (this.resolver != null) {
            this.reader.setEntityResolver(this.resolver);
        }
        XMLReader tmpReader = this.reader;
        this.reader = null;
        tmpReader.parse(in);
        if (this.reuseParsers) {
            this.reader = tmpReader;
        }
    }

    public Document newDocument() {
        this.setupDocumentBuilder();
        return this.docBuilder.newDocument();
    }

    public Document newDocument(String name) {
        return this.newDocument(name, null, null);
    }

    public Document newDocument(String name, String publicId, String systemId) {
        this.setupDocumentBuilder();
        DOMImplementation impl = this.docBuilder.newDocument().getImplementation();
        return impl.createDocument(null, name, impl.createDocumentType(name, publicId, systemId));
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        this.setupDocumentBuilder();
        DocumentBuilder tmpBuilder = this.docBuilder;
        this.docBuilder = null;
        Document result = tmpBuilder.parse(input);
        if (this.reuseParsers) {
            this.docBuilder = tmpBuilder;
        }
        return result;
    }

    protected void setupXMLReader() throws SAXException {
        if (this.reader == null) {
            try {
                this.reader = this.factory.newSAXParser().getXMLReader();
                this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.nsPrefixes);
            }
            catch (Exception e) {
                this.getLogger().error("Cannot produce a valid parser", (Throwable)e);
                throw new SAXException("Cannot produce a valid parser", e);
            }
        }
    }

    protected void setupDocumentBuilder() {
        if (this.docBuilder == null) {
            try {
                this.docBuilder = this.docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                this.getLogger().error("Could not create DocumentBuilder", (Throwable)pce);
                throw new CascadingRuntimeException("Could not create DocumentBuilder", (Throwable)pce);
            }
        }
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException("Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }
}

