/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.util.HashMap;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class XMLByteStreamCompiler
implements XMLSerializer,
Recyclable {
    private HashMap map = new HashMap();
    private int count;
    private byte[] buf;
    private int bufCount;
    private static final int START_DOCUMENT = 0;
    private static final int END_DOCUMENT = 1;
    private static final int START_PREFIX_MAPPING = 2;
    private static final int END_PREFIX_MAPPING = 3;
    private static final int START_ELEMENT = 4;
    private static final int END_ELEMENT = 5;
    private static final int CHARACTERS = 6;
    private static final int IGNORABLE_WHITESPACE = 7;
    private static final int PROCESSING_INSTRUCTION = 8;
    private static final int COMMENT = 9;
    private static final int LOCATOR = 10;
    private static final int START_DTD = 11;
    private static final int END_DTD = 12;
    private static final int START_CDATA = 13;
    private static final int END_CDATA = 14;
    private static final int SKIPPED_ENTITY = 15;
    private static final int START_ENTITY = 16;
    private static final int END_ENTITY = 17;

    public XMLByteStreamCompiler() {
        this.initOutput();
    }

    private void initOutput() {
        this.count = 0;
        this.map.clear();
        this.buf = new byte[2000];
        this.buf[0] = 67;
        this.buf[1] = 88;
        this.buf[2] = 77;
        this.buf[3] = 76;
        this.buf[4] = 1;
        this.buf[5] = 0;
        this.bufCount = 6;
    }

    public void recycle() {
        this.initOutput();
    }

    public Object getSAXFragment() {
        byte[] newbuf = new byte[this.bufCount];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
        return newbuf;
    }

    public void startDocument() throws SAXException {
        this.writeEvent(0);
    }

    public void endDocument() throws SAXException {
        this.writeEvent(1);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.writeEvent(2);
        this.writeString(prefix);
        this.writeString(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.writeEvent(3);
        this.writeString(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int length = atts.getLength();
        this.writeEvent(4);
        this.writeAttributes(length);
        int i = 0;
        while (i < length) {
            this.writeString(atts.getURI(i));
            this.writeString(atts.getLocalName(i));
            this.writeString(atts.getQName(i));
            this.writeString(atts.getType(i));
            this.writeString(atts.getValue(i));
            ++i;
        }
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.writeEvent(5);
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.writeEvent(6);
        this.writeChars(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeEvent(7);
        this.writeChars(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.writeEvent(8);
        this.writeString(target);
        this.writeString(data);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.writeEvent(10);
            String publicId = locator.getPublicId();
            String systemId = locator.getSystemId();
            this.writeString(publicId != null ? publicId : "");
            this.writeString(systemId != null ? systemId : "");
            this.write(locator.getLineNumber());
            this.write(locator.getColumnNumber());
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot write locator info", (Throwable)e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.writeEvent(15);
        this.writeString(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.writeEvent(11);
        this.writeString(name);
        this.writeString(publicId != null ? publicId : "");
        this.writeString(systemId != null ? systemId : "");
    }

    public void endDTD() throws SAXException {
        this.writeEvent(12);
    }

    public void startEntity(String name) throws SAXException {
        this.writeEvent(16);
        this.writeString(name);
    }

    public void endEntity(String name) throws SAXException {
        this.writeEvent(17);
        this.writeString(name);
    }

    public void startCDATA() throws SAXException {
        this.writeEvent(13);
    }

    public void endCDATA() throws SAXException {
        this.writeEvent(14);
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        try {
            this.writeEvent(9);
            this.writeChars(ary, start, length);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public final void writeEvent(int event) throws SAXException {
        this.write(event);
    }

    public final void writeAttributes(int attributes) throws SAXException {
        this.write(attributes >>> 8 & 0xFF);
        this.write(attributes >>> 0 & 0xFF);
    }

    public final void writeString(String str) throws SAXException {
        Integer index = (Integer)this.map.get(str);
        if (index == null) {
            int length = str.length();
            this.map.put(str, new Integer(this.count++));
            this.writeChars(str.toCharArray(), 0, length);
        } else {
            int i = index;
            this.write(i >>> 8 & 0xFF | 0x80);
            this.write(i >>> 0 & 0xFF);
        }
    }

    public final void writeChars(char[] ch, int start, int length) throws SAXException {
        char c;
        int utflen = 0;
        int count = 0;
        int i = 0;
        while (i < length) {
            c = ch[i + start];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > Short.MAX_VALUE) {
            throw new SAXException("UTFDataFormatException: String cannot be longer than 32k.");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < length) {
            c = ch[i2 + start];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        this.write(bytearr);
    }

    private void write(byte[] b) {
        int len = b.length;
        if (len == 0) {
            return;
        }
        int newcount = this.bufCount + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
        System.arraycopy(b, 0, this.buf, this.bufCount, len);
        this.bufCount = newcount;
    }

    private void write(int b) {
        int newcount = this.bufCount + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
        this.buf[this.bufCount] = (byte)b;
        this.bufCount = newcount;
    }
}

