/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.log.Logger;

public class InvokeContext
implements Recomposable,
Disposable,
Loggable {
    private List mapStack = new ArrayList();
    private StreamPipeline streamPipeline;
    private EventPipeline eventPipeline;
    private boolean isInternalRequest;
    private ComponentManager currentManager;
    private ComponentManager pipelinesManager;
    private Logger logger;

    public InvokeContext() {
        this.isInternalRequest = false;
    }

    public InvokeContext(StreamPipeline pipeline, EventPipeline eventPipeline) {
        this.isInternalRequest = true;
        this.streamPipeline = pipeline;
        this.eventPipeline = eventPipeline;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.currentManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.currentManager = manager;
        if (this.streamPipeline != null) {
            this.streamPipeline.recompose(manager);
            this.eventPipeline.recompose(manager);
        }
    }

    public final EventPipeline getEventPipeline() throws Exception {
        if (this.eventPipeline == null) {
            this.setupPipelines();
        }
        return this.eventPipeline;
    }

    public final StreamPipeline getStreamPipeline() throws Exception {
        if (this.streamPipeline == null) {
            this.setupPipelines();
        }
        return this.streamPipeline;
    }

    private final void setupPipelines() throws Exception {
        this.pipelinesManager = this.currentManager;
        this.eventPipeline = (EventPipeline)this.pipelinesManager.lookup("org.apache.cocoon.components.pipeline.EventPipeline");
        this.streamPipeline = (StreamPipeline)this.pipelinesManager.lookup("org.apache.cocoon.components.pipeline.StreamPipeline");
        this.streamPipeline.setEventPipeline(this.eventPipeline);
        this.eventPipeline.recompose(this.pipelinesManager);
        this.streamPipeline.recompose(this.pipelinesManager);
    }

    public final boolean isInternalRequest() {
        return this.isInternalRequest;
    }

    public final List getMapStack() {
        return this.mapStack;
    }

    public final void pushMap(Map map) {
        this.mapStack.add(map);
        if (this.logger.isDebugEnabled()) {
            this.dumpParameters(this.getMapStack());
        }
    }

    protected void dumpParameters(List list) {
        if (!list.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nCurrent Sitemap Parameters:\n");
            String path = "";
            int i = list.size() - 1;
            while (i >= 0) {
                Map map = (Map)list.get(i);
                Iterator keys = map.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    sb.append("PARAM: '").append(path).append(key);
                    sb.append("' VALUE: '").append(map.get(key)).append("'\n");
                }
                path = "../" + path;
                --i;
            }
            this.logger.debug(sb.toString());
        }
    }

    public final void popMap() {
        this.mapStack.remove(this.mapStack.size() - 1);
    }

    public void dispose() {
        if (!this.isInternalRequest && this.pipelinesManager != null) {
            this.pipelinesManager.release((Component)this.eventPipeline);
            this.pipelinesManager.release((Component)this.streamPipeline);
            this.pipelinesManager = null;
        }
    }
}

