/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.Iterator;
import java.util.List;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.source.CocoonSourceFactory;
import org.apache.cocoon.components.source.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.source.SourceHandler;
import org.apache.cocoon.components.source.URLSource;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Source;
import org.xml.sax.ContentHandler;

public class TreeProcessor
extends AbstractLoggable
implements ThreadSafe,
Processor,
Composable,
Configurable,
LogKitManageable,
RoleManageable,
Initializable,
Contextualizable,
Disposable {
    private static final String XCONF_URL = "resource://org/apache/cocoon/components/treeprocessor/treeprocessor-builtins.xml";
    protected TreeProcessor parent;
    protected Context context;
    protected ComponentManager manager;
    protected LogKitManager logKit;
    protected RoleManager roleManager;
    protected String language;
    protected ExtendedComponentSelector builderSelector;
    protected ProcessingNode rootNode;
    protected List disposableNodes;
    protected long lastModified = 0L;
    protected Source source;
    protected long lastModifiedDelay;
    protected Configuration currentLanguage;
    protected SourceHandler sourceHandler;

    public TreeProcessor() {
        this.language = "sitemap";
    }

    protected TreeProcessor(TreeProcessor parent, ComponentManager manager, String language) {
        this.parent = parent;
        this.language = language == null ? parent.language : language;
        this.context = parent.context;
        this.logKit = parent.logKit;
        this.builderSelector = parent.builderSelector;
        this.manager = manager;
    }

    public TreeProcessor createChildProcessor(ComponentManager manager, String language, Source source) throws Exception {
        TreeProcessor child = new TreeProcessor(this, manager, language);
        child.setLogger(this.getLogger());
        child.initialize();
        child.source = new DelayedRefreshSourceWrapper(source, 1000L);
        return child;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void setLogKitManager(LogKitManager logKit) {
        this.logKit = logKit;
    }

    public void setRoleManager(RoleManager rm) {
        this.roleManager = rm;
    }

    public void configure(Configuration config2) throws ConfigurationException {
        Configuration builtin;
        Configuration rootLangConfig = config2.getChild("root-language", false);
        if (rootLangConfig != null) {
            this.language = rootLangConfig.getAttribute("name");
        }
        String xconfURL = config2.getAttribute("config", XCONF_URL);
        this.lastModifiedDelay = config2.getChild("reload").getAttributeAsLong("delay", 1000L);
        try {
            URLFactory factory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
            URLSource source = new URLSource(factory.getURL(xconfURL), this.manager);
            try {
                SAXConfigurationHandler handler = new SAXConfigurationHandler();
                source.toSAX((ContentHandler)handler);
                builtin = handler.getConfiguration();
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.manager.release((Component)factory);
                if (source != null) {
                    source.recycle();
                }
                throw throwable;
            }
            this.manager.release((Component)factory);
            if (source != null) {
                source.recycle();
            }
        }
        catch (Exception e) {
            String msg = "Error while reading " + xconfURL + ": " + e.getMessage();
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg, (Throwable)e);
        }
        this.builderSelector = new ExtendedComponentSelector(Thread.currentThread().getContextClassLoader());
        try {
            LifecycleHelper.setupComponent((Object)this.builderSelector, this.getLogger(), this.context, this.manager, this.roleManager, this.logKit, builtin);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not setup builder selector", (Throwable)e);
        }
    }

    public void initialize() throws Exception {
        this.sourceHandler = (SourceHandler)this.manager.lookup("org.apache.cocoon.components.source.SourceHandler");
        this.sourceHandler.addFactory("cocoon", new CocoonSourceFactory(this, this.manager));
    }

    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        context.setLogger(this.getLogger());
        try {
            boolean bl = this.process(environment, context);
            Object var5_4 = null;
            context.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.dispose();
            throw throwable;
        }
    }

    public boolean process(Environment environment, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        boolean bl;
        InvokeContext context = new InvokeContext(pipeline, eventPipeline);
        context.setLogger(this.getLogger());
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        CocoonComponentManager.enterEnvironment(environment, environment.getObjectModel(), this);
        environment.setComponentManager(this.manager);
        try {
            environment.setSourceHandler(this.sourceHandler);
            bl = this.process(environment, context);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            CocoonComponentManager.leaveEnvironment();
            environment.setSourceHandler(oldSourceHandler);
            context.dispose();
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        environment.setSourceHandler(oldSourceHandler);
        context.dispose();
        return bl;
    }

    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        boolean bl;
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        CocoonComponentManager.enterEnvironment(environment, environment.getObjectModel(), this);
        environment.setComponentManager(this.manager);
        try {
            environment.setSourceHandler(this.sourceHandler);
            if (this.rootNode == null || this.source.getLastModified() > this.lastModified) {
                this.setupRootNode(environment);
            }
            bl = this.rootNode.invoke(environment, context);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CocoonComponentManager.leaveEnvironment();
            environment.setSourceHandler(oldSourceHandler);
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        environment.setSourceHandler(oldSourceHandler);
        return bl;
    }

    protected synchronized void setupRootNode(Environment env) throws Exception {
        ProcessingNode root;
        if (this.rootNode != null && this.source.getLastModified() <= this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.disposeTree();
        TreeBuilder builder = (TreeBuilder)this.builderSelector.select(this.language);
        try {
            if (builder instanceof Recomposable) {
                ((Recomposable)builder).recompose(this.manager);
            }
            builder.setProcessor(this);
            if (this.source == null) {
                this.source = new DelayedRefreshSourceWrapper(env.resolve(builder.getFileName()), 1000L);
            }
            root = builder.build(this.source);
            this.disposableNodes = builder.getDisposableNodes();
            Object var7_5 = null;
            this.builderSelector.release(builder);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.builderSelector.release(builder);
            throw throwable;
        }
        this.lastModified = System.currentTimeMillis();
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(this.lastModified - startTime) / 1000.0;
            this.getLogger().debug("TreeProcessor built in " + time + " secs from " + this.source.getSystemId());
        }
        this.rootNode = root;
    }

    public void dispose() {
        this.disposeTree();
        this.manager.release((Component)this.sourceHandler);
        if (this.parent == null) {
            this.builderSelector.dispose();
        }
    }

    protected void disposeTree() {
        if (this.disposableNodes != null) {
            Iterator iter = this.disposableNodes.iterator();
            while (iter.hasNext()) {
                ((Disposable)iter.next()).dispose();
            }
            this.disposableNodes = null;
        }
    }
}

