/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.xscript.XScriptManager;
import org.apache.cocoon.components.xscript.XScriptManagerImpl;
import org.apache.cocoon.components.xscript.XScriptObjectResult;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XScriptObject
implements Source,
Composable {
    Date lastModifiedDate = new Date();
    XScriptManager xscriptManager;
    protected ComponentManager componentManager;

    public XScriptObject(XScriptManager manager) {
        this.xscriptManager = manager;
        ((XScriptManagerImpl)this.xscriptManager).register(this);
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.componentManager = manager;
    }

    public XScriptObject transform(XScriptObject stylesheet, Parameters params) throws IllegalArgumentException, ProcessingException {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            StreamResult result = new StreamResult(writer);
            XSLTProcessor transformer = (XSLTProcessor)this.componentManager.lookup("org.apache.cocoon.components.xslt.XSLTProcessor");
            try {
                transformer.transform(this, stylesheet, params, result);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.componentManager.release((Component)transformer);
                throw throwable;
            }
            this.componentManager.release((Component)transformer);
            return new XScriptObjectResult(this.xscriptManager, writer.toString());
        }
        catch (ComponentException ex) {
            throw new ProcessingException((Exception)((Object)ex));
        }
    }

    public void toEmbeddedSAX(ContentHandler handler) throws SAXException {
        EmbeddedXMLPipe newHandler = new EmbeddedXMLPipe(handler);
        this.toSAX(newHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        Parser parser = null;
        try {
            try {
                parser = (Parser)this.componentManager.lookup(Parser.ROLE);
                InputSource source = this.getInputSource();
                parser.parse(source, handler);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            Object var6_5 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (parser == null) throw throwable;
            this.componentManager.release((Component)parser);
            throw throwable;
        }
        this.componentManager.release((Component)parser);
    }

    public long getLastModified() {
        return this.lastModifiedDate.getTime();
    }

    public abstract long getContentLength();

    public InputSource getInputSource() throws ProcessingException, IOException {
        InputSource is = new InputSource(this.getInputStream());
        is.setSystemId(this.getSystemId());
        return is;
    }

    public void recycle() {
    }

    public abstract String getSystemId();

    public abstract InputStream getInputStream() throws ProcessingException, IOException;
}

