/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.collections.IteratorEnumeration;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceHandler;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Source;
import org.xml.sax.SAXException;

public abstract class AbstractEnvironment
extends AbstractLoggable
implements Environment {
    protected String uris;
    protected StringBuffer prefix = new StringBuffer();
    protected String view = null;
    protected String action = null;
    protected URL context = null;
    protected URL rootContext = null;
    protected HashMap objectModel = null;
    protected SourceHandler sourceHandler;
    private Map attributes = new HashMap();
    protected ComponentManager manager = null;

    public ComponentManager getComponentManager() {
        return this.manager;
    }

    public void setComponentManager(ComponentManager manager) {
        this.manager = manager;
    }

    public AbstractEnvironment(String uri, String view, String file) throws MalformedURLException {
        this(uri, view, new File(file), null);
    }

    public AbstractEnvironment(String uri, String view, String file, String action) throws MalformedURLException {
        this(uri, view, new File(file), action);
    }

    public AbstractEnvironment(String uri, String view, File file) throws MalformedURLException {
        this(uri, view, file, null);
    }

    public AbstractEnvironment(String uri, String view, File file, String action) throws MalformedURLException {
        this(uri, view, file.toURL(), action);
    }

    public AbstractEnvironment(String uri, String view, URL context, String action) throws MalformedURLException {
        this.uris = uri;
        this.view = view;
        this.context = context;
        this.action = action;
        this.objectModel = new HashMap();
        this.rootContext = context;
    }

    public SourceHandler getSourceHandler() {
        return this.sourceHandler;
    }

    public void setSourceHandler(SourceHandler sourceHandler) {
        this.sourceHandler = sourceHandler;
    }

    public String getURI() {
        return this.uris;
    }

    public URL getRootContext() {
        return this.rootContext;
    }

    public URL getContext() {
        return this.context;
    }

    public String getURIPrefix() {
        return this.prefix.toString();
    }

    protected void setURIPrefix(String prefix) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Set the URI Prefix (OLD=" + this.getURIPrefix() + ", NEW=" + prefix + ")");
        }
        this.prefix = new StringBuffer(prefix);
    }

    protected void setContext(URL context) {
        this.context = context;
    }

    public void setContext(String prefix, String uri) {
        this.setContext(this.getRootContext());
        this.setURIPrefix(prefix == null ? "" : prefix);
        this.uris = uri;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Reset context to " + this.context);
        }
    }

    public void changeContext(String prefix, String newContext) throws MalformedURLException {
        int l;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Changing Cocoon context");
            this.getLogger().debug("  from context(" + this.context.toExternalForm() + ") and prefix(" + this.prefix + ")");
            this.getLogger().debug("  to context(" + newContext + ") and prefix(" + prefix + ")");
            this.getLogger().debug("  at URI " + this.uris);
        }
        if ((l = prefix.length()) >= 1) {
            if (!this.uris.startsWith(prefix)) {
                String message = "The current URI (" + this.uris + ") doesn't start with given prefix (" + prefix + ")";
                this.getLogger().error(message);
                throw new RuntimeException(message);
            }
            this.prefix.append(prefix);
            this.uris = this.uris.substring(l);
            if (this.uris.startsWith("/")) {
                this.uris = this.uris.substring(1);
                this.prefix.append('/');
            }
        }
        if (this.context.getProtocol().equals("zip")) {
            this.getLogger().debug("Base context is zip: " + this.context);
            this.context = new URL(this.context.toString() + newContext);
        } else {
            String sContext = newContext.charAt(0) == '/' ? "file:" + newContext : (newContext.indexOf(58) > 1 ? newContext : new URL(this.context, newContext).toString());
            int i = sContext.lastIndexOf(47);
            if (i != -1 && i + 1 < sContext.length()) {
                sContext = sContext.substring(0, i + 1);
            }
            this.context = new URL(sContext);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New context is " + this.context.toExternalForm());
        }
    }

    public abstract void redirect(boolean var1, String var2) throws IOException;

    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        this.redirect(sessionmode, newURL);
    }

    public String getView() {
        return this.view;
    }

    public String getAction() {
        return this.action;
    }

    public void setStatus(int statusCode) {
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    public Source resolve(String systemId) throws ProcessingException, SAXException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving '" + systemId + "' in context '" + this.context + "'");
        }
        if (systemId == null) {
            throw new SAXException("Invalid System ID");
        }
        Source source = systemId.length() == 0 ? this.sourceHandler.getSource(this, this.context.toExternalForm()) : (systemId.charAt(0) == '/' ? (systemId.length() > 2 && systemId.charAt(2) == ':' ? this.sourceHandler.getSource(this, "file:" + systemId) : this.sourceHandler.getSource(this, this.context.getProtocol() + ":" + systemId)) : (systemId.indexOf(":") > 1 ? this.sourceHandler.getSource(this, systemId) : (systemId.length() > 1 && systemId.charAt(1) == ':' ? this.sourceHandler.getSource(this, "file:/" + systemId) : this.sourceHandler.getSource(this, this.context, systemId))));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved to '" + source.getSystemId() + "'");
        }
        return source;
    }

    public boolean isResponseModified(long lastModified) {
        return true;
    }

    public void setResponseIsNotModified() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public boolean tryResetResponse() {
        return false;
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void setContentLength(int var1);

    public abstract String getContentType();

    public abstract void setContentType(String var1);
}

