/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLResourceBundle
extends ResourceBundle
implements Loggable,
Component,
Composable,
Disposable {
    protected static DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
    private Hashtable cache = new Hashtable();
    private Map cacheNotFound = new HashMap();
    private String name = "";
    private Document doc;
    private Locale locale;
    protected XMLResourceBundle parent = null;
    protected Logger logger;
    protected ComponentManager manager = null;
    private XPathProcessor processor = null;
    static /* synthetic */ Class class$org$apache$cocoon$i18n$XMLResourceBundle;

    public void compose(ComponentManager manager) {
        this.manager = manager;
        try {
            this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        }
        catch (Exception e) {
            this.logger.error("cannot obtain XPathProcessor", (Throwable)e);
        }
    }

    public void dispose() {
        this.manager.release((Component)this.processor);
        this.processor = null;
    }

    public void init(String name, String fileName, Locale locale, XMLResourceBundle parent, boolean cacheAtStartup) throws IOException, ParserConfigurationException, SAXException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Constructing XMLResourceBundle: " + name + ", locale: " + locale);
        }
        this.name = name;
        this.doc = XMLResourceBundle.loadResourceBundle(fileName);
        this.locale = locale;
        this.parent = parent;
        if (cacheAtStartup) {
            Element root = this.doc.getDocumentElement();
            this.cacheAll(root, "/" + root.getNodeName());
        }
    }

    protected static Document loadResourceBundle(String fileName) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(fileName);
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private boolean cacheContains(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": cache contains: " + key);
        }
        return this.cache.containsKey(key);
    }

    private boolean cacheNotFoundContains(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": cache_not_found contains: " + key);
        }
        return this.cacheNotFound.containsKey(key);
    }

    private void cacheKey(String key, String value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": caching: " + key + " = " + value);
        }
        this.cache.put(key, value);
    }

    private void cacheNotFoundKey(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": caching not_found: " + key);
        }
        this.cacheNotFound.put(key, "");
    }

    private String getFromCache(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": returning from cache: " + key);
        }
        return (String)this.cache.get(key);
    }

    private void cacheAll(Node parent, String pathToParent) {
        NodeList children = parent.getChildNodes();
        int childnum = children.getLength();
        int i = 0;
        while (i < childnum) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String childValue;
                StringBuffer pathToChild = new StringBuffer(pathToParent).append('/').append(child.getNodeName());
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null) {
                    Node temp = null;
                    Object pathToAttr = null;
                    int attrnum = attrs.getLength();
                    int j = 0;
                    while (j < attrnum) {
                        temp = attrs.item(j);
                        if (!temp.getNodeName().equalsIgnoreCase("xml:lang")) {
                            pathToChild.append("[@").append(temp.getNodeName()).append("='").append(temp.getNodeValue()).append("']");
                        }
                        ++j;
                    }
                }
                if ((childValue = XMLResourceBundle.getTextValue(child)) != null) {
                    this.cacheKey(pathToChild.toString(), childValue);
                } else {
                    this.cacheAll(child, pathToChild.toString());
                }
            }
            ++i;
        }
    }

    public String getString(String key, Map dictionary) throws MissingResourceException {
        String value = this._getString(key);
        if (value == null) {
            throw new MissingResourceException("Unable to locate resource: " + key, (class$org$apache$cocoon$i18n$XMLResourceBundle == null ? (class$org$apache$cocoon$i18n$XMLResourceBundle = XMLResourceBundle.class$("org.apache.cocoon.i18n.XMLResourceBundle")) : class$org$apache$cocoon$i18n$XMLResourceBundle).getName(), key);
        }
        return this.substitute(value, dictionary);
    }

    private String _getString(String key) {
        if (key == null) {
            return null;
        }
        String value = this.getFromCache(key);
        if (value == null && !this.cacheNotFoundContains(key)) {
            if (this.doc != null) {
                value = this._getString(this.doc.getDocumentElement(), key);
            }
            if (value == null && this.parent != null) {
                value = this.parent._getString(key);
            }
            if (value != null) {
                this.cacheKey(key, value);
            } else {
                this.cacheNotFoundKey(key);
            }
        }
        return value;
    }

    private String _getString(Node node, String key) {
        try {
            return XMLResourceBundle.getTextValue(this._getNode(node, key));
        }
        catch (Exception e) {
            this.logger.error(this.name + ": error while locating resource: " + key, (Throwable)e);
            return null;
        }
    }

    private static String getTextValue(Node element) {
        if (element == null) {
            return null;
        }
        NodeList list = element.getChildNodes();
        int listsize = list.getLength();
        Node item = null;
        String itemValue = null;
        int i = 0;
        if (i < listsize) {
            item = list.item(i);
            if (item.getNodeType() != 3) {
                return null;
            }
            itemValue = item.getNodeValue();
            if (itemValue == null) {
                return null;
            }
            if ((itemValue = itemValue.trim()).length() == 0) {
                return null;
            }
            return itemValue;
        }
        return null;
    }

    private Node _getNode(String key) {
        return this._getNode(this.doc.getDocumentElement(), key);
    }

    private Node _getNode(Node rootNode, String key) {
        try {
            return this.processor.selectSingleNode(rootNode, key);
        }
        catch (Exception e) {
            this.logger.error("Error while locating resource with key: " + key, (Throwable)e);
            return null;
        }
    }

    public String substitute(String value, Map dictionary) {
        if (value == null || dictionary == null) {
            return value;
        }
        StringBuffer result = new StringBuffer(value.length());
        int startPos = 0;
        int endPos = 0;
        int lastPos = value.length();
        String varValue = "";
        String varKey = "";
        String oldKey = "";
        while (endPos < lastPos) {
            startPos = endPos;
            if ((endPos = value.indexOf(123, startPos)) == -1) {
                endPos = lastPos;
            }
            result.append(value.substring(startPos, endPos));
            if (endPos < lastPos) {
                ++endPos;
            }
            if (endPos >= lastPos) continue;
            startPos = endPos;
            if ((endPos = value.indexOf(125, startPos)) == -1) {
                endPos = lastPos;
            }
            if (!(oldKey = varKey).equals(varKey = value.substring(startPos, endPos))) {
                varValue = dictionary.get(varKey);
            }
            if (varValue != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Substituting var: " + varKey + " --> " + varValue);
                }
                result.append((Object)varValue);
            } else {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(this.name + ": var not found: " + varKey);
                }
                result.append('{').append(varKey).append('}');
            }
            if (endPos >= lastPos) continue;
            ++endPos;
        }
        return result.toString();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        return this.getString(key, null);
    }

    public Enumeration getKeys() {
        return this.cache.keys();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

