/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.HashUtil;
import org.xml.sax.SAXException;

public class ResourceReader
extends AbstractReader
implements Cacheable {
    private Source inputSource;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.inputSource = this.resolver.resolve(this.source);
    }

    public void recycle() {
        super.recycle();
        if (this.inputSource != null) {
            this.inputSource.recycle();
            this.inputSource = null;
        }
    }

    public long generateKey() {
        if (this.inputSource.getLastModified() != 0L) {
            return HashUtil.hash(this.inputSource.getSystemId());
        }
        return 0L;
    }

    public CacheValidity generateValidity() {
        if (this.inputSource.getLastModified() != 0L) {
            return new TimeStampCacheValidity(this.inputSource.getLastModified());
        }
        return null;
    }

    public long getLastModified() {
        return this.inputSource.getLastModified();
    }

    public void generate() throws IOException, ProcessingException {
        long contentLength;
        Response response = ObjectModelHelper.getResponse(this.objectModel);
        long expires = this.parameters.getParameterAsInteger("expires", -1);
        if (expires > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expires);
        }
        if ((contentLength = this.inputSource.getContentLength()) != -1L) {
            response.setHeader("Content-Length", Long.toString(contentLength));
        }
        response.setHeader("Accept-Ranges", "none");
        byte[] buffer = new byte[8192];
        int length = -1;
        InputStream inputStream = this.inputSource.getInputStream();
        while ((length = inputStream.read(buffer)) > -1) {
            this.out.write(buffer, 0, length);
        }
        inputStream.close();
        inputStream = null;
        this.out.flush();
    }

    public String getMimeType() {
        Context ctx = ObjectModelHelper.getContext(this.objectModel);
        if (ctx != null) {
            return ctx.getMimeType(this.source);
        }
        return null;
    }
}

