/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.components.renderer.ExtendableRendererFactory;
import org.apache.cocoon.components.renderer.RendererFactory;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.URLFactorySourceResolver;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.xml.sax.ContentHandler;

public class FOPSerializer
extends AbstractSerializer
implements Composable,
Configurable,
Cacheable {
    protected static RendererFactory factory = ExtendableRendererFactory.getRendererFactoryImplementation();
    protected Driver driver;
    protected Renderer renderer;
    protected String mimetype;
    protected String rendererName;
    protected boolean setContentLength = true;
    protected Logger logger;
    private static boolean configured = false;
    protected ComponentManager manager;
    static /* synthetic */ Class class$org$apache$cocoon$serialization$FOPSerializer;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration conf) throws ConfigurationException {
        this.logger = new LogKitLogger(this.getLogger().getChildLogger("fop"));
        MessageHandler.setScreenLogger((Logger)this.logger);
        Class clazz = class$org$apache$cocoon$serialization$FOPSerializer == null ? (class$org$apache$cocoon$serialization$FOPSerializer = FOPSerializer.class$("org.apache.cocoon.serialization.FOPSerializer")) : class$org$apache$cocoon$serialization$FOPSerializer;
        synchronized (clazz) {
            if (!configured) {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Loading default configuration");
                    }
                    new Options();
                }
                catch (Exception e) {
                    this.getLogger().error("Cannot load default configuration. Proceeding.", (Throwable)e);
                }
                configured = true;
            }
        }
        this.setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
        String configUrl = conf.getChild("user-config").getAttribute("src", null);
        if (configUrl != null) {
            try {
                configUrl = new File(configUrl).toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                this.getLogger().warn("Can not load config file " + configUrl, (Throwable)e);
                configUrl = null;
            }
        } else {
            configUrl = conf.getChild("user-config").getValue(null);
        }
        if (configUrl != null) {
            URLFactory urlFactory = null;
            Source configSource = null;
            try {
                try {
                    urlFactory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
                    URLFactorySourceResolver urlResolver = new URLFactorySourceResolver(urlFactory, this.manager);
                    configSource = urlResolver.resolve(configUrl);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Loading configuration from " + configSource.getSystemId());
                    }
                    configSource.toSAX((ContentHandler)new ConfigurationParser());
                }
                catch (Exception e) {
                    this.getLogger().warn("Cannot load configuration from " + configUrl);
                    throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
                }
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.manager.release((Component)urlFactory);
                if (configSource != null) {
                    configSource.recycle();
                }
                throw throwable;
            }
            this.manager.release((Component)urlFactory);
            if (configSource != null) {
                configSource.recycle();
            }
        }
        this.mimetype = conf.getAttribute("mime-type");
        Configuration[] parameters = conf.getChildren("parameter");
        int i = 0;
        while (true) {
            if (i >= parameters.length) {
                if (this.renderer == null) {
                    this.renderer = factory.createRenderer(this.mimetype);
                }
                if (this.renderer != null) break;
                throw new ConfigurationException("Could not autodetect renderer for FOPSerializer and no renderer was specified in the sitemap configuration.");
            }
            String name = parameters[i].getAttribute("name");
            if ("renderer".equals(name)) {
                this.rendererName = parameters[i].getAttribute("value");
                try {
                    this.renderer = (Renderer)ClassUtils.newInstance(this.rendererName);
                }
                catch (Exception ex) {
                    this.getLogger().error("Cannot load  class " + this.rendererName, (Throwable)ex);
                    throw new ConfigurationException("Cannot load class " + this.rendererName, (Throwable)ex);
                }
            }
            ++i;
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void setOutputStream(OutputStream out) {
        this.driver = new Driver();
        this.driver.setLogger(this.logger);
        if (this.rendererName == null) {
            this.renderer = factory.createRenderer(this.mimetype);
        } else {
            try {
                this.renderer = (Renderer)ClassUtils.newInstance(this.rendererName);
            }
            catch (Exception e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Cannot load  class " + this.rendererName, (Throwable)e);
                }
                throw new CascadingRuntimeException("Cannot load class " + this.rendererName, (Throwable)e);
            }
        }
        this.driver.setRenderer(this.renderer);
        this.driver.setOutputStream(out);
        this.setContentHandler(this.driver.getContentHandler());
    }

    public long generateKey() {
        return 1L;
    }

    public CacheValidity generateValidity() {
        return NOPCacheValidity.CACHE_VALIDITY;
    }

    public void recycle() {
        super.recycle();
        this.driver = null;
        this.renderer = null;
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

