/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CIncludeTransformer
extends AbstractTransformer
implements Composable {
    public static final String CINCLUDE_NAMESPACE_URI = "http://apache.org/cocoon/include/1.0";
    public static final String CINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE = "src";
    public static final String CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE = "element";
    public static final String CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE = "ns";
    public static final String CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE = "prefix";
    protected SourceResolver sourceResolver;
    protected ComponentManager manager = null;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.sourceResolver = resolver;
    }

    public final void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void recycle() {
        super.recycle();
        this.sourceResolver = null;
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (uri != null && name != null && uri.equals(CINCLUDE_NAMESPACE_URI) && name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            this.processCIncludeElement(attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE));
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (uri != null && name != null && uri.equals(CINCLUDE_NAMESPACE_URI) && name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            return;
        }
        super.endElement(uri, name, raw);
    }

    protected void processCIncludeElement(String src, String element, String ns, String prefix) throws SAXException {
        if (element == null) {
            element = "";
        }
        if (ns == null) {
            ns = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        this.getLogger().debug("Processing CInclude element: src=" + src + ", element=" + element + ", ns=" + ns + ", prefix=" + prefix);
        IncludeXMLConsumer consumer = new IncludeXMLConsumer(this);
        if (!"".equals(element)) {
            AttributesImpl attrs = new AttributesImpl();
            if (!ns.equals("")) {
                super.startPrefixMapping(prefix, ns);
            }
            super.startElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element, attrs);
        }
        Source source = null;
        try {
            try {
                source = this.sourceResolver.resolve(src);
                source.toSAX(consumer);
            }
            catch (IOException e) {
                this.getLogger().error("CIncludeTransformer", (Throwable)e);
                throw new SAXException("CIncludeTransformer could not read resource", e);
            }
            catch (ProcessingException e) {
                this.getLogger().error("Could not stream input", (Throwable)((Object)e));
                throw new SAXException("Exception in CIncludeTransformer", (Exception)((Object)e));
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            source.recycle();
            throw throwable;
        }
        source.recycle();
        if (!"".equals(element)) {
            super.endElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element);
            if (!ns.equals("")) {
                super.endPrefixMapping(prefix);
            }
        }
    }
}

