/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.avalon.excalibur.collections.BucketMap;
import org.apache.avalon.excalibur.component.AbstractDualLogEnabled;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;

public class DefaultComponentFactory
extends AbstractDualLogEnabled
implements ObjectFactory,
Disposable,
ThreadSafe {
    private Class m_componentClass;
    private Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private RoleManager m_roles;
    private LogkitLoggerManager m_loggerManager;
    private final BucketMap m_components = new BucketMap();
    private InstrumentManager m_instrumentManager;
    private String m_instrumentableName;

    public DefaultComponentFactory(Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roles, LogkitLoggerManager loggerManager) {
        this(componentClass, configuration, componentManager, context, roles, loggerManager, null, "N/A");
    }

    public DefaultComponentFactory(Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roles, LogkitLoggerManager loggerManager, InstrumentManager instrumentManager, String instrumentableName) {
        this.m_componentClass = componentClass;
        this.m_configuration = configuration;
        this.m_componentManager = componentManager;
        this.m_context = context;
        this.m_roles = roles;
        this.m_loggerManager = loggerManager;
        this.m_instrumentManager = instrumentManager;
        this.m_instrumentableName = instrumentableName;
    }

    public Object newInstance() throws Exception {
        Object manager;
        String logger;
        Object component = this.m_componentClass.newInstance();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentFactory creating new instance of " + this.m_componentClass.getName() + ".");
        }
        if (component instanceof LogEnabled) {
            if (null == this.m_loggerManager || null == this.m_configuration) {
                ((LogEnabled)component).enableLogging(this.getLogger());
            } else {
                logger = this.m_configuration.getAttribute("logger", null);
                if (null == logger) {
                    this.getLogger().debug("no logger attribute available, using standard logger");
                    ((LogEnabled)component).enableLogging(this.getLogger());
                } else {
                    this.getLogger().debug("logger attribute is " + logger);
                    ((LogEnabled)component).enableLogging(this.m_loggerManager.getLoggerForCategory(logger));
                }
            }
        }
        if (component instanceof Loggable) {
            if (null == this.m_loggerManager || null == this.m_configuration) {
                ((Loggable)component).setLogger(this.getLogkitLogger());
            } else {
                logger = this.m_configuration.getAttribute("logger", null);
                if (null == logger) {
                    this.getLogger().debug("no logger attribute available, using standard logger");
                    ((Loggable)component).setLogger(this.getLogkitLogger());
                } else {
                    this.getLogger().debug("logger attribute is " + logger);
                    ((Loggable)component).setLogger(this.m_loggerManager.getLogKitLoggerForCategory(logger));
                }
            }
        }
        if (component instanceof Instrumentable) {
            Instrumentable instrumentable = (Instrumentable)component;
            instrumentable.setInstrumentableName(this.m_instrumentableName);
        }
        if (component instanceof InstrumentManageable && this.m_instrumentManager != null) {
            ((InstrumentManageable)component).setInstrumentManager(this.m_instrumentManager);
        }
        if (component instanceof Contextualizable) {
            ((Contextualizable)component).contextualize(this.m_context);
        }
        Object proxy = null;
        if (component instanceof Composable) {
            manager = new ComponentManagerProxy(this.m_componentManager);
            ((Composable)component).compose((ComponentManager)manager);
            proxy = manager;
        }
        if (component instanceof Serviceable) {
            manager = new ServiceManagerProxy(this.m_componentManager);
            ((Serviceable)component).service((ServiceManager)manager);
            proxy = manager;
        }
        if (component instanceof RoleManageable) {
            ((RoleManageable)component).setRoleManager(this.m_roles);
        }
        if (component instanceof LogKitManageable) {
            ((LogKitManageable)component).setLogKitManager(this.m_loggerManager.getLogKitManager());
        }
        if (component instanceof Configurable) {
            ((Configurable)component).configure(this.m_configuration);
        }
        if (component instanceof Parameterizable) {
            ((Parameterizable)component).parameterize(Parameters.fromConfiguration((Configuration)this.m_configuration));
        }
        if (component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (component instanceof Instrumentable && this.m_instrumentManager != null) {
            this.m_instrumentManager.registerInstrumentable((Instrumentable)component, this.m_instrumentableName);
        }
        if (component instanceof Startable) {
            ((Startable)component).start();
        }
        this.m_components.put(component, proxy);
        return component;
    }

    public final Class getCreatedClass() {
        return this.m_componentClass;
    }

    public final void decommission(Object component) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentFactory decommissioning instance of " + this.m_componentClass.getName() + ".");
        }
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
        if (component instanceof Composable) {
            ((ComponentManagerProxy)this.m_components.get(component)).releaseAll();
        }
        if (component instanceof Serviceable) {
            ((ServiceManagerProxy)this.m_components.get(component)).releaseAll();
        }
        this.m_components.remove(component);
    }

    public final void dispose() {
        Component[] components = new Component[this.m_components.keySet().size()];
        this.m_components.keySet().toArray(components);
        int i = 0;
        while (i < components.length) {
            block3: {
                try {
                    this.decommission(components[i]);
                }
                catch (Exception e) {
                    if (!this.getLogger().isWarnEnabled()) break block3;
                    this.getLogger().warn("Error decommissioning component: " + this.getCreatedClass().getName(), (Throwable)e);
                }
            }
            ++i;
        }
    }

    private static class ServiceManagerProxy
    implements ServiceManager {
        private final ComponentManager m_realManager;
        private final Collection m_unreleased = new ArrayList();

        ServiceManagerProxy(ComponentManager manager) {
            this.m_realManager = manager;
        }

        public Object lookup(String role) throws ServiceException {
            try {
                Component component = this.m_realManager.lookup(role);
                this.addUnreleased(component);
                return component;
            }
            catch (ClassCastException e) {
                throw new ServiceException(role, "Casting exception (does your Serviceable implement Component)", (Throwable)e);
            }
            catch (ComponentException e) {
                throw new ServiceException(e.getRole(), e.getMessage(), (Throwable)e);
            }
        }

        public boolean hasService(String role) {
            return this.m_realManager.hasComponent(role);
        }

        public void release(Object component) {
            this.removeUnreleased(component);
            this.m_realManager.release((Component)component);
        }

        private synchronized void addUnreleased(Object component) {
            this.m_unreleased.add(component);
        }

        private synchronized void removeUnreleased(Object component) {
            this.m_unreleased.remove(component);
        }

        private void releaseAll() {
            Component[] unreleased;
            ServiceManagerProxy serviceManagerProxy = this;
            synchronized (serviceManagerProxy) {
                unreleased = new Component[this.m_unreleased.size()];
                this.m_unreleased.toArray(unreleased);
            }
            int i = 0;
            while (i < unreleased.length) {
                this.release(unreleased[i]);
                ++i;
            }
        }
    }

    private static class ComponentManagerProxy
    implements ComponentManager {
        private final ComponentManager m_realManager;
        private final Collection m_unreleased = new ArrayList();

        ComponentManagerProxy(ComponentManager manager) {
            this.m_realManager = manager;
        }

        public Component lookup(String role) throws ComponentException {
            Component component = this.m_realManager.lookup(role);
            this.addUnreleased(component);
            return component;
        }

        public boolean hasComponent(String role) {
            return this.m_realManager.hasComponent(role);
        }

        public void release(Component component) {
            this.removeUnreleased(component);
            this.m_realManager.release(component);
        }

        private synchronized void addUnreleased(Component component) {
            this.m_unreleased.add(component);
        }

        private synchronized void removeUnreleased(Component component) {
            this.m_unreleased.remove(component);
        }

        private void releaseAll() {
            Component[] unreleased;
            ComponentManagerProxy componentManagerProxy = this;
            synchronized (componentManagerProxy) {
                unreleased = new Component[this.m_unreleased.size()];
                this.m_unreleased.toArray(unreleased);
            }
            int i = 0;
            while (i < unreleased.length) {
                this.release(unreleased[i]);
                ++i;
            }
        }
    }
}

