/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeScript
extends NativeFunction
implements Script {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;
    private int prototypeIdShift;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeScript nativeScript = new NativeScript();
        nativeScript.scopeInit(context, scriptable, bl);
    }

    private void scopeInit(Context context, Scriptable scriptable, boolean bl) {
        this.prototypeIdShift = super.maxInstanceId() + 1;
        this.addAsPrototype(4 + this.prototypeIdShift - 1, context, scriptable, bl);
    }

    public String getClassName() {
        return "Script";
    }

    public void initScript(Scriptable scriptable) {
    }

    public int methodArity(int n) {
        if (this.prototypeIdShift != 0) {
            switch (n - this.prototypeIdShift + 1) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeIdShift != 0) {
            switch (n - this.prototypeIdShift + 1) {
                case 1: {
                    return NativeScript.jsConstructor(context, scriptable, objectArray);
                }
                case 2: {
                    return this.realThis(scriptable2, idFunction, true).jsFunction_toString(context, objectArray);
                }
                case 4: {
                    return this.realThis(scriptable2, idFunction, true).jsFunction_exec();
                }
                case 3: {
                    return this.realThis(scriptable2, idFunction, false).jsFunction_compile(ScriptRuntime.toString(objectArray, 0));
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeScript realThis(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeScript)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeScript)scriptable;
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        return NativeScript.compile(scriptable, string);
    }

    public static Script compile(Scriptable scriptable, String string) {
        Context context = Context.getContext();
        StringReader stringReader = new StringReader(string);
        try {
            int[] nArray = new int[]{0};
            String string2 = Context.getSourcePositionFromStack(nArray);
            if (string2 == null) {
                string2 = "<Script object>";
                nArray[0] = 1;
            }
            Object object = context.getSecurityDomainForStackDepth(5);
            return context.compileReader(scriptable, stringReader, string2, nArray[0], object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IOException");
        }
    }

    private Scriptable jsFunction_compile(String string) {
        this.script = NativeScript.compile(null, string);
        return this;
    }

    private Object jsFunction_exec() throws JavaScriptException {
        throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
    }

    private Object jsFunction_toString(Context context, Object[] objectArray) {
        Script script = this.script;
        if (script == null) {
            script = this;
        }
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        return context.decompileScript(script, scriptable, 0);
    }

    public String getFunctionName() {
        return "";
    }

    public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(context, scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return this.exec(context, scriptable);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    protected String getIdName(int n) {
        if (this.prototypeIdShift != 0) {
            switch (n - this.prototypeIdShift + 1) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(n);
    }

    protected int mapNameToId(String string) {
        int n;
        if (this.prototypeIdShift != 0 && (n = NativeScript.toPrototypeId(string)) != 0) {
            return n + this.prototypeIdShift - 1;
        }
        return super.mapNameToId(string);
    }

    private static int toPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "exec";
                n = 4;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 3;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

