/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.JComboBox;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.tools.debugger.Main;

class UpdateContext
implements Runnable {
    Main db;
    Context cx;
    DebuggableEngine engine;

    UpdateContext(Main main, Context context) {
        this.db = main;
        this.cx = context;
        this.engine = context.getDebuggableEngine();
    }

    public void run() {
        this.db.context.enable();
        JComboBox jComboBox = this.db.context.context;
        Vector vector = this.db.context.toolTips;
        this.db.context.disableUpdate();
        int n = this.engine.getFrameCount();
        jComboBox.removeAllItems();
        vector.clear();
        int n2 = 0;
        while (n2 < n) {
            String string;
            DebugFrame debugFrame = this.engine.getFrame(n2);
            String string2 = string = debugFrame.getSourceName();
            int n3 = debugFrame.getLineNumber();
            if (string == null) {
                if (n3 == -1) {
                    string = "<eval>";
                    string2 = "<eval>";
                } else {
                    string = "<stdin>";
                    string2 = "<stdin>";
                }
            } else if (string.length() > 20) {
                string2 = new File(string).getName();
            }
            String string3 = "\"" + string2 + "\", line " + n3;
            jComboBox.insertItemAt(string3, n2);
            string3 = "\"" + string + "\", line " + n3;
            vector.addElement(string3);
            ++n2;
        }
        this.db.context.enableUpdate();
        jComboBox.setSelectedIndex(0);
        jComboBox.setMinimumSize(new Dimension(50, jComboBox.getMinimumSize().height));
    }
}

