/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.util.ArrayList;
import org.jfor.jfor.converter.BuilderContext;
import org.jfor.jfor.converter.FoUnitsConverter;
import org.jfor.jfor.converter.ValueConversionException;

class TableContext {
    private final BuilderContext m_context;
    private final ArrayList m_colWidths = new ArrayList();
    private int m_colIndex;
    public static final float INVALID_COLUM_WIDTH = 200.0f;

    TableContext(BuilderContext builderContext) {
        this.m_context = builderContext;
    }

    void setNextColumnWidth(String string) throws ValueConversionException {
        this.m_colWidths.add(new Float(FoUnitsConverter.getInstance().convertToTwips(string)));
    }

    void selectFirstColumn() {
        this.m_colIndex = 0;
    }

    void selectNextColumn() {
        ++this.m_colIndex;
    }

    float getColumnWidth() {
        try {
            return ((Float)this.m_colWidths.get(this.m_colIndex)).floatValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.m_context.log.logWarning("fo:table-column width not defined,using 200.0");
            return 200.0f;
        }
    }
}

