/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.JenaProcessProfile;
import com.hp.hpl.deli.LegacyDevices;
import com.hp.hpl.deli.ProcessProfile;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.ProfileCache;
import com.hp.hpl.deli.UAProfProfileAttribute;
import com.hp.hpl.deli.Vocabulary;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Workspace {
    private static final long HOURINMILLISECONDS = 3600000L;
    private Vector vocabularyFileList;
    private Vector schemaFileList;
    private Vector schemaURIlist;
    private StringBuffer debugLog = new StringBuffer();
    private ServletContext servletContext;
    protected long maxCachedProfileLifetime = 86400000L;
    protected int maxCacheSize = 100;
    protected boolean refreshStaleProfiles = false;
    protected boolean normaliseWhitespaceInProfileDiff = true;
    protected boolean profileDiffDigestVerification = true;
    protected boolean supportLegacyDevices = true;
    protected boolean printDefaults = true;
    protected boolean debug = false;
    protected boolean printProfileBeforeMerge = false;
    protected String legacyDeviceFile = "config/legacyDevice.xml";
    protected String rdfUri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected String rdfsUri = "http://www.w3.org/1999/PR-rdf-schema-19990303#";
    protected String componentProperty = "component";
    protected String ccppReaderType = "jena";
    protected String profileAttribute = "UAProf";
    protected Vocabulary vocabulary;
    protected ProfileCache profileCache;
    protected LegacyDevices legacyDevice;
    protected String path;

    public Workspace(ServletContext servletContext, String string) throws ParserConfigurationException, MalformedURLException {
        System.setProperty("com.hp.hpl.mesa.rdf.jena.reader.RDF/XML", "com.hp.hpl.mesa.rdf.jena.common.RDFXMLReader");
        this.servletContext = servletContext;
        if (this.servletContext != null) {
            try {
                this.path = this.servletContext.getResource("/WEB-INF").toString();
                this.path = this.path.substring(0, this.path.length() - "WEB-INF".length());
            }
            catch (MalformedURLException malformedURLException) {
                this.printDebug("Unable to determine servlet context URL." + malformedURLException.toString());
                throw malformedURLException;
            }
        } else {
            this.path = "";
        }
        this.vocabularyFileList = new Vector();
        this.schemaFileList = new Vector();
        this.schemaURIlist = new Vector();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            this.traverse(documentBuilder.parse(this.path + string));
        }
        catch (Exception exception) {
            this.printDebug("Workspace: Cannot load workspace configuration file from " + this.path + string);
        }
        this.printDebug("Workspace: loading vocabularies");
        this.vocabulary = new Vocabulary(this, this.vocabularyFileList, this.schemaFileList, this.schemaURIlist, this.path);
        this.printDebug("Workspace: Creating the profile cache");
        this.profileCache = new ProfileCache(this);
        this.printDebug("Workspace: Creating the legacy device database");
        this.legacyDevice = new LegacyDevices(this, this.path + this.legacyDeviceFile);
        this.printDebug("Workspace: Finished creating workspace");
        this.debugLog = new StringBuffer();
    }

    private void traverse(Node node) {
        Object object;
        String string = node.getNodeName();
        if (string.equals("debug")) {
            this.debug = this.setBooleanProperty(node);
            this.printDebug("Setting debug: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("refreshStaleProfiles")) {
            this.refreshStaleProfiles = this.setBooleanProperty(node);
            this.printDebug("Setting refreshStaleProfiles: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("normaliseWhitespaceInProfileDiff")) {
            this.normaliseWhitespaceInProfileDiff = this.setBooleanProperty(node);
            this.printDebug("Setting normaliseWhitespaceInProfileDiff: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("supportLegacyDevices")) {
            this.supportLegacyDevices = this.setBooleanProperty(node);
            this.printDebug("Setting supportLegacyDevices: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("printDefaults")) {
            this.printDefaults = this.setBooleanProperty(node);
            this.printDebug("Setting printDefaults: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("profileAttributel")) {
            this.profileAttribute = node.getFirstChild().getNodeValue();
            this.printDebug("Setting profileAttribute: " + this.profileAttribute);
        } else if (string.equals("printProfileBeforeMerge")) {
            this.printProfileBeforeMerge = this.setBooleanProperty(node);
            this.printDebug("Setting printProfileBeforeMerge: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("vocabularyFile")) {
            object = node.getFirstChild().getNodeValue();
            this.vocabularyFileList.add(object);
            this.printDebug("Adding vocabularyFile: " + (String)object);
        } else if (string.equals("schemaVocabularyFile")) {
            object = node.getFirstChild().getNodeValue();
            this.schemaFileList.add(object);
            this.printDebug("Adding schemaVocabularyFile: " + (String)object);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName();
                if (string2.equals("namespace")) {
                    String string3 = attr.getValue();
                    this.schemaURIlist.add(string3);
                    this.printDebug("With namespace: " + string3);
                }
                ++n;
            }
        } else if (string.equals("legacyDeviceFile")) {
            this.legacyDeviceFile = node.getFirstChild().getNodeValue();
            this.printDebug("Setting legacyDeviceFile: " + this.legacyDeviceFile);
        } else if (string.equals("componentProperty")) {
            this.componentProperty = node.getFirstChild().getNodeValue();
            this.printDebug("Setting componentProperty: " + this.componentProperty);
        } else if (string.equals("ccppReaderType")) {
            this.ccppReaderType = node.getFirstChild().getNodeValue();
            this.printDebug("Setting ccppReaderType: " + this.ccppReaderType);
        } else if (string.equals("rdfUri")) {
            this.rdfUri = this.setUriProperty(node);
            this.printDebug("Setting rdfUri: " + this.rdfUri);
        } else if (string.equals("rdfsUri")) {
            this.rdfsUri = this.setUriProperty(node);
            this.printDebug("Setting rdfsUri: " + this.rdfsUri);
        } else if (string.equals("maxCachedProfileLifetime")) {
            this.maxCachedProfileLifetime = Long.parseLong(node.getFirstChild().getNodeValue()) * 3600000L;
            this.printDebug("Setting maxCachedProfileLifetime: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("maxCacheSize")) {
            this.maxCacheSize = Integer.parseInt(node.getFirstChild().getNodeValue());
            this.printDebug("Setting maxCacheSize: " + node.getFirstChild().getNodeValue());
        } else if (string.equals("profileDiffDigestVerification")) {
            this.profileDiffDigestVerification = this.setBooleanProperty(node);
            this.printDebug("Setting profileDiffDigestVerification: " + node.getFirstChild().getNodeValue());
        } else if (node.hasChildNodes()) {
            this.traverse(node.getFirstChild());
        }
        object = node.getNextSibling();
        if (object != null) {
            this.traverse((Node)object);
        }
    }

    protected void printDebug(String string) {
        if (this.debug) {
            System.out.println(string);
            if (this.debugLog != null) {
                this.debugLog = this.debugLog.append(string).append("\n");
            }
        }
    }

    protected String retrieveDebug() {
        if (this.debug) {
            if (this.debugLog != null) {
                String string = this.debugLog.toString();
                this.debugLog = new StringBuffer();
                return string;
            }
            return null;
        }
        return null;
    }

    private boolean setBooleanProperty(Node node) {
        String string = node.getFirstChild().getNodeValue();
        return string.toLowerCase().equals("true");
    }

    private String setUriProperty(Node node) {
        String string = node.getFirstChild().getNodeValue();
        if (string != null) {
            if (string.charAt(string.length() - 1) != '#') {
                string = string + '#';
            }
            return string;
        }
        return null;
    }

    protected ProfileAttribute profileAttributeFactory() {
        if (this.profileAttribute.toLowerCase().equals("uaprof")) {
            return new UAProfProfileAttribute(this, this.vocabulary);
        }
        return null;
    }

    protected ProcessProfile processProfileFactory() throws Exception {
        if (this.ccppReaderType.toLowerCase().startsWith("jena")) {
            return new JenaProcessProfile(this);
        }
        return null;
    }

    protected Reader getResource(String string) throws Exception {
        try {
            InputStreamReader inputStreamReader;
            if (string.startsWith("http")) {
                this.printDebug("Reading global resource: " + string);
                inputStreamReader = new InputStreamReader(new URL(string).openStream());
            } else if (this.servletContext != null) {
                this.printDebug("Reading local resource: " + string);
                inputStreamReader = new InputStreamReader(this.servletContext.getResourceAsStream(string));
            } else {
                this.printDebug("Reading file: " + string);
                inputStreamReader = new FileReader(string);
            }
            return inputStreamReader;
        }
        catch (Exception exception) {
            this.printDebug("Cannot retrieve resource:" + string);
            this.printDebug(exception.toString());
            throw exception;
        }
    }
}

