/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.BTreeException;
import com.coyotegulch.jisp.BTreeSharedConstants;
import com.coyotegulch.jisp.BTreeSharedExceptions;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.Page;
import com.coyotegulch.jisp.PageDatabaseFile;
import com.coyotegulch.jisp.PageFileHeader;
import java.io.File;
import java.io.IOException;

class BTreePageFile
implements BTreeSharedExceptions,
BTreeSharedConstants {
    private static final int MINIMUM_ORDER = 5;
    protected PageFileHeader m_header;
    private PageDatabaseFile m_datafile;

    BTreePageFile(String string) throws IOException, ClassNotFoundException {
        this.m_datafile = new PageDatabaseFile(string);
        this.m_datafile.rewind();
        this.m_header = (PageFileHeader)this.m_datafile.readObject();
    }

    BTreePageFile(String string, int n, KeyObject keyObject, boolean bl) throws IOException, ClassNotFoundException {
        File file = new File(string);
        file.delete();
        this.m_datafile = new PageDatabaseFile(string);
        this.constructorHelper(n, keyObject, bl);
    }

    private void constructorHelper(int n, KeyObject keyObject, boolean bl) throws BTreeException, IOException, ClassNotFoundException {
        if (n < 5) {
            n = 5;
        } else if ((n & 1) != 1) {
            ++n;
        }
        this.m_header = new PageFileHeader();
        this.m_header.m_order = n;
        this.m_header.m_maxKeys = n - 1;
        this.m_header.m_minKeys = n / 2;
        this.m_header.m_rootPtr = -1L;
        this.m_header.m_hasDupes = bl;
        this.m_header.m_nullKey = keyObject;
        this.m_datafile.writeObject(this.m_header);
        Page page = new Page(this.m_header);
        page.m_header.m_filePtr = this.m_datafile.getNextOpen();
        this.m_header.m_rootPtr = this.m_datafile.writeObject(page);
        this.m_datafile.rewind();
        this.m_datafile.rewriteObject(this.m_header);
    }

    void write(Page page, boolean bl) throws BTreeException, IOException {
        if (page.m_header.m_filePtr == -1L) {
            page.m_header.m_filePtr = this.m_datafile.getNextOpen();
            this.m_datafile.writeObject(page);
        } else {
            this.m_datafile.seek(page.m_header.m_filePtr);
            this.m_datafile.rewriteObject(page);
        }
        if (bl) {
            this.m_header.m_rootPtr = page.m_header.m_filePtr;
            this.m_datafile.rewind();
            this.m_datafile.rewriteObject(this.m_header);
        }
    }

    Page read(long l) throws BTreeException, IOException, ClassNotFoundException {
        this.m_datafile.seek(l);
        return (Page)this.m_datafile.readObject();
    }

    Page readRoot() throws BTreeException, IOException, ClassNotFoundException {
        return this.read(this.m_header.m_rootPtr);
    }

    void delete(Page page) throws BTreeException, IOException {
        this.m_datafile.seek(page.m_header.m_filePtr);
        this.m_datafile.delete();
    }
}

