/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Map;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.littleendian.ClassID;
import org.apache.poi.hpsf.littleendian.DWord;
import org.apache.poi.hpsf.wellknown.SectionIDMap;

public class Section {
    protected Map dictionary;
    private ClassID formatID;
    private int offset;
    private int size;
    private int propertyCount;
    private Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public Section(byte[] src, int offset) {
        this.formatID = new ClassID(src, offset);
        offset += 16;
        offset = this.offset = new DWord(src, offset).intValue();
        this.size = new DWord(src, offset).intValue();
        this.propertyCount = new DWord(src, offset += 4).intValue();
        offset += 4;
        this.properties = new Property[this.propertyCount];
        int i = 0;
        while (i < this.properties.length) {
            int id = new DWord(src, offset).intValue();
            int sOffset = new DWord(src, offset += 4).intValue();
            int length = i == this.properties.length - 1 ? src.length - this.offset - sOffset : new DWord(src, (offset += 4) + 4).intValue() - sOffset;
            this.properties[i] = new Property(id, src, this.offset + sOffset, length);
            ++i;
        }
        this.dictionary = (Map)this.getProperty(0);
    }

    protected Object getProperty(int id) {
        this.wasNull = false;
        int i = 0;
        while (i < this.properties.length) {
            if (id == this.properties[i].getID()) {
                return this.properties[i].getValue();
            }
            ++i;
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(int id) {
        Integer i = (Integer)this.getProperty(id);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(int pid) {
        String s = null;
        if (this.dictionary != null) {
            s = (String)this.dictionary.get(new Integer(pid));
        }
        if (s == null) {
            s = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s == null) {
            s = "[undefined]";
        }
        return s;
    }
}

