/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class CategorySeriesAxisRecord
extends Record {
    public static final short sid = 4128;
    private short field_1_crossingPoint;
    private short field_2_labelFrequency;
    private short field_3_tickMarkFrequency;
    private short field_4_options;
    private BitField valueAxisCrossing = new BitField(1);
    private BitField crossesFarRight = new BitField(2);
    private BitField reversed = new BitField(4);

    public CategorySeriesAxisRecord() {
    }

    public CategorySeriesAxisRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public CategorySeriesAxisRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4128) {
            throw new RecordFormatException("Not a CategorySeriesAxis record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_crossingPoint = LittleEndian.getShort(data, 0 + offset);
        this.field_2_labelFrequency = LittleEndian.getShort(data, 2 + offset);
        this.field_3_tickMarkFrequency = LittleEndian.getShort(data, 4 + offset);
        this.field_4_options = LittleEndian.getShort(data, 6 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CategorySeriesAxis]\n");
        buffer.append("    .crossingPoint        = ").append("0x").append(HexDump.toHex(this.getCrossingPoint())).append(" (").append(this.getCrossingPoint()).append(" )\n");
        buffer.append("    .labelFrequency       = ").append("0x").append(HexDump.toHex(this.getLabelFrequency())).append(" (").append(this.getLabelFrequency()).append(" )\n");
        buffer.append("    .tickMarkFrequency    = ").append("0x").append(HexDump.toHex(this.getTickMarkFrequency())).append(" (").append(this.getTickMarkFrequency()).append(" )\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )\n");
        buffer.append("         .valueAxisCrossing        = ").append(this.isValueAxisCrossing()).append('\n');
        buffer.append("         .crossesFarRight          = ").append(this.isCrossesFarRight()).append('\n');
        buffer.append("         .reversed                 = ").append(this.isReversed()).append('\n');
        buffer.append("[/CategorySeriesAxis]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4128);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_crossingPoint);
        LittleEndian.putShort(data, 6 + offset, this.field_2_labelFrequency);
        LittleEndian.putShort(data, 8 + offset, this.field_3_tickMarkFrequency);
        LittleEndian.putShort(data, 10 + offset, this.field_4_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 4128;
    }

    public short getCrossingPoint() {
        return this.field_1_crossingPoint;
    }

    public void setCrossingPoint(short field_1_crossingPoint) {
        this.field_1_crossingPoint = field_1_crossingPoint;
    }

    public short getLabelFrequency() {
        return this.field_2_labelFrequency;
    }

    public void setLabelFrequency(short field_2_labelFrequency) {
        this.field_2_labelFrequency = field_2_labelFrequency;
    }

    public short getTickMarkFrequency() {
        return this.field_3_tickMarkFrequency;
    }

    public void setTickMarkFrequency(short field_3_tickMarkFrequency) {
        this.field_3_tickMarkFrequency = field_3_tickMarkFrequency;
    }

    public short getOptions() {
        return this.field_4_options;
    }

    public void setOptions(short field_4_options) {
        this.field_4_options = field_4_options;
    }

    public void setValueAxisCrossing(boolean value) {
        this.field_4_options = this.valueAxisCrossing.setShortBoolean(this.field_4_options, value);
    }

    public boolean isValueAxisCrossing() {
        return this.valueAxisCrossing.isSet(this.field_4_options);
    }

    public void setCrossesFarRight(boolean value) {
        this.field_4_options = this.crossesFarRight.setShortBoolean(this.field_4_options, value);
    }

    public boolean isCrossesFarRight() {
        return this.crossesFarRight.isSet(this.field_4_options);
    }

    public void setReversed(boolean value) {
        this.field_4_options = this.reversed.setShortBoolean(this.field_4_options, value);
    }

    public boolean isReversed() {
        return this.reversed.isSet(this.field_4_options);
    }

    static {
        sid = (short)4128;
    }
}

