/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class ChartRecord
extends Record {
    public static final short sid = 4098;
    private int field_1_x;
    private int field_2_y;
    private int field_3_width;
    private int field_4_height;

    public ChartRecord() {
    }

    public ChartRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ChartRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4098) {
            throw new RecordFormatException("Not a Chart record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_x = LittleEndian.getInt(data, 0 + offset);
        this.field_2_y = LittleEndian.getInt(data, 4 + offset);
        this.field_3_width = LittleEndian.getInt(data, 8 + offset);
        this.field_4_height = LittleEndian.getInt(data, 12 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Chart]\n");
        buffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )\n");
        buffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )\n");
        buffer.append("    .width                = ").append("0x").append(HexDump.toHex(this.getWidth())).append(" (").append(this.getWidth()).append(" )\n");
        buffer.append("    .height               = ").append("0x").append(HexDump.toHex(this.getHeight())).append(" (").append(this.getHeight()).append(" )\n");
        buffer.append("[/Chart]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4098);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset, this.field_1_x);
        LittleEndian.putInt(data, 8 + offset, this.field_2_y);
        LittleEndian.putInt(data, 12 + offset, this.field_3_width);
        LittleEndian.putInt(data, 16 + offset, this.field_4_height);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 4098;
    }

    public int getX() {
        return this.field_1_x;
    }

    public void setX(int field_1_x) {
        this.field_1_x = field_1_x;
    }

    public int getY() {
        return this.field_2_y;
    }

    public void setY(int field_2_y) {
        this.field_2_y = field_2_y;
    }

    public int getWidth() {
        return this.field_3_width;
    }

    public void setWidth(int field_3_width) {
        this.field_3_width = field_3_width;
    }

    public int getHeight() {
        return this.field_4_height;
    }

    public void setHeight(int field_4_height) {
        this.field_4_height = field_4_height;
    }

    static {
        sid = (short)4098;
    }
}

