/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class MergeCellsRecord
extends Record {
    public static final short sid = 229;
    private short field_1_num_areas;
    private ArrayList field_2_regions;

    public MergeCellsRecord() {
    }

    public MergeCellsRecord(short sid, short size, byte[] data) {
        super(sid, size, data);
    }

    public MergeCellsRecord(short sid, short size, byte[] data, int offset) {
        super(sid, size, data, offset);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_num_areas = LittleEndian.getShort(data, 0 + offset);
        this.field_2_regions = new ArrayList(this.field_1_num_areas + 10);
        int pos = 2;
        int k = 0;
        while (k < this.field_1_num_areas) {
            MergedRegion region = new MergedRegion(LittleEndian.getShort(data, pos + offset), LittleEndian.getShort(data, pos + 2 + offset), LittleEndian.getShort(data, pos + 4 + offset), LittleEndian.getShort(data, pos + 6 + offset));
            pos += 8;
            this.field_2_regions.add(region);
            ++k;
        }
    }

    public short getNumAreas() {
        return this.field_1_num_areas;
    }

    public void setNumAreas(short numareas) {
        this.field_1_num_areas = numareas;
    }

    public int addArea(short rowfrom, short colfrom, short rowto, short colto) {
        if (this.field_2_regions == null) {
            this.field_2_regions = new ArrayList(10);
        }
        MergedRegion region = new MergedRegion(rowfrom, rowto, colfrom, colto);
        this.field_2_regions.add(region);
        this.field_1_num_areas = (short)(this.field_1_num_areas + 1);
        return this.field_2_regions.size() - 1;
    }

    public void removeAreaAt(int area) {
        this.field_2_regions.remove(area);
        this.field_1_num_areas = (short)(this.field_1_num_areas - 1);
    }

    public MergedRegion getAreaAt(int index) {
        return (MergedRegion)this.field_2_regions.get(index);
    }

    public int getRecordSize() {
        int retValue = 6 + 8 * this.field_2_regions.size();
        return retValue;
    }

    public short getSid() {
        return 229;
    }

    public int serialize(int offset, byte[] data) {
        int recordsize = this.getRecordSize();
        int pos = 6;
        LittleEndian.putShort(data, offset + 0, (short)229);
        LittleEndian.putShort(data, offset + 2, (short)(recordsize - 4));
        LittleEndian.putShort(data, offset + 4, this.getNumAreas());
        int k = 0;
        while (k < this.getNumAreas()) {
            MergedRegion region = this.getAreaAt(k);
            LittleEndian.putShort(data, offset + pos, region.row_from);
            LittleEndian.putShort(data, offset + (pos += 2), region.row_to);
            LittleEndian.putShort(data, offset + (pos += 2), region.col_from);
            LittleEndian.putShort(data, offset + (pos += 2), region.col_to);
            pos += 2;
            ++k;
        }
        return recordsize;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[MERGEDCELLS]").append("\n");
        retval.append("     .sid        =").append(229).append("\n");
        retval.append("     .numregions =").append(this.field_1_num_areas).append("\n");
        int k = 0;
        while (k < this.field_1_num_areas) {
            MergedRegion region = (MergedRegion)this.field_2_regions.get(k);
            retval.append("     .rowfrom    =").append(region.row_from).append("\n");
            retval.append("     .colfrom    =").append(region.col_from).append("\n");
            retval.append("     .rowto      =").append(region.row_to).append("\n");
            retval.append("     .colto      =").append(region.col_to).append("\n");
            ++k;
        }
        retval.append("[MERGEDCELLS]").append("\n");
        return retval.toString();
    }

    protected void validateSid(short id) {
        if (id != 229) {
            throw new RecordFormatException("NOT A MERGEDCELLS RECORD!! " + id);
        }
    }

    static {
        sid = (short)229;
    }

    public class MergedRegion {
        public short row_from;
        public short row_to;
        public short col_from;
        public short col_to;

        public MergedRegion(short row_from, short row_to, short col_from, short col_to) {
            this.row_from = row_from;
            this.row_to = row_to;
            this.col_from = col_from;
            this.col_to = col_to;
        }
    }
}

