/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _lbuffer = new StringBuffer(8);
    private static final StringBuffer _cbuffer = new StringBuffer(2);
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    private HexDump() {
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int j = index;
        while (j < data.length) {
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            int k2 = 0;
            while (k2 < chars_read) {
                if (data[k2 + j] >= 32 && data[k2 + j] < 127) {
                    buffer.append((char)data[k2 + j]);
                } else {
                    buffer.append('.');
                }
                ++k2;
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
            j += 16;
        }
    }

    private static StringBuffer dump(long value) {
        _lbuffer.setLength(0);
        int j = 0;
        while (j < 8) {
            _lbuffer.append(_hexcodes[(int)(value >> _shifts[j]) & 0xF]);
            ++j;
        }
        return _lbuffer;
    }

    private static StringBuffer dump(byte value) {
        _cbuffer.setLength(0);
        int j = 0;
        while (j < 2) {
            _cbuffer.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
            ++j;
        }
        return _cbuffer;
    }

    public static String toHex(short value) {
        return HexDump.toHex(value, 4);
    }

    public static String toHex(byte value) {
        return HexDump.toHex(value, 2);
    }

    public static String toHex(int value) {
        return HexDump.toHex(value, 8);
    }

    private static String toHex(long value, int digits) {
        StringBuffer result = new StringBuffer(digits);
        int j = 0;
        while (j < digits) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (8 - digits)] & 0xFL)]);
            ++j;
        }
        return result.toString();
    }
}

