/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLDataInstance;
import com.hp.hpl.jena.daml.DAMLDatatype;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.PropertyIterator;
import com.hp.hpl.jena.daml.common.DAMLCommonImpl;
import com.hp.hpl.jena.daml.common.DatatypeTranslator;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.util.Iterator;

public class DAMLDataInstanceImpl
extends DAMLCommonImpl
implements DAMLDataInstance {
    protected PropertyAccessor m_propsameIndividualAs = null;

    public DAMLDataInstanceImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
    }

    public DAMLDataInstanceImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
    }

    Object getKey() {
        return DAML_OIL.Thing.getURI();
    }

    public PropertyAccessor prop_sameIndividualAs() {
        if (this.m_propsameIndividualAs == null) {
            this.m_propsameIndividualAs = new PropertyAccessorImpl(this.getVocabulary().sameIndividualAs(), this);
        }
        return this.m_propsameIndividualAs;
    }

    public Iterator getSameInstances() {
        return new PropertyIterator(this, this.getVocabulary().sameIndividualAs(), this.getVocabulary().sameIndividualAs(), true, true);
    }

    public DatatypeTranslator getTranslator() {
        Iterator iterator = this.getRDFTypes(false);
        if (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource instanceof DAMLDatatype) {
                if (iterator.hasNext()) {
                    Log.warning("DAMLInstance " + this + " has more than one rdf:type, only returning first one");
                }
                return ((DAMLDatatype)resource).getTranslator();
            }
            Log.warning("DAMLInstance has rdf:type that is not a DAMLDatatype");
        }
        return null;
    }

    public Object getValue() {
        try {
            return this.getTranslator().deserialize(this.getProperty(RDF.value).getObject());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while setting value of data instance: " + rDFException, rDFException);
            return null;
        }
    }

    public void setValue(Object object) {
        this.replaceProperty(RDF.value, this.getTranslator().serialize(object, this.getDAMLModel()));
    }
}

