/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.IntLiteralAccessor;
import com.hp.hpl.jena.daml.common.LiteralAccessorImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;

public class IntLiteralAccessorImpl
extends LiteralAccessorImpl
implements IntLiteralAccessor {
    public IntLiteralAccessorImpl(Property property, DAMLCommon dAMLCommon) {
        super(property, dAMLCommon);
    }

    public int getInt() {
        try {
            NodeIterator nodeIterator = this.getValues();
            if (nodeIterator == null || !nodeIterator.hasNext()) {
                throw new RuntimeException("No value defined for property " + this.getProperty());
            }
            return ((Literal)nodeIterator.next()).getInt();
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception when getting literal values: " + rDFException, rDFException);
            throw new RuntimeException("RDF exception when getting literal values: " + rDFException);
        }
    }

    public void addInt(int n) {
        this.addValue(Integer.toString(n));
    }

    public void removeInt(int n) {
        this.removeValue(Integer.toString(n));
    }

    public boolean hasIntValue(int n) {
        return this.hasValue(Integer.toString(n));
    }
}

