/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.Token;
import java.util.BitSet;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ParseException
extends SAXParseException
implements ARPErrorNumbers,
RDFParserConstants {
    private int id;
    private Location where;
    boolean specialConstructor;
    Token currentToken;
    private boolean isFatal;
    int[][] expectedTokenSequences;
    private String[] tokenImage;
    boolean promoteMe;
    private Token startAttributes;
    static String eol = System.getProperty("line.separator", "\n");

    ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(null, ParseException.publicId(token), ParseException.systemId(token), ParseException.line(token), ParseException.col(token));
        this.specialConstructor = true;
        this.where = token.location;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.id = 201;
        this.tokenImage = stringArray;
    }

    private static String systemId(Token token) {
        return token.location != null ? token.location.inputName : null;
    }

    private static String publicId(Token token) {
        return null;
    }

    private static int line(Token token) {
        return token.location != null ? token.location.endLine : -1;
    }

    private static int col(Token token) {
        return token.location != null ? token.location.endColumn : -1;
    }

    ParseException(int n, Location location, String string) {
        super(string, location.inputName, null, location.endLine, location.endColumn);
        this.where = location;
        this.id = n;
        this.specialConstructor = false;
    }

    ParseException(int n, String string) {
        super(string, (Locator)null);
        this.id = n;
        this.specialConstructor = false;
    }

    ParseException() {
        super((String)null, (Locator)null);
        this.specialConstructor = false;
    }

    public int getErrorNumber() {
        return this.id;
    }

    void setFatal(boolean bl) {
        this.isFatal = bl;
    }

    boolean getFatal() {
        return this.isFatal;
    }

    public void promote() {
        this.promoteMe = true;
    }

    void setStartAttribute(Token token) {
        this.startAttributes = token;
    }

    private void startAttrSkip(Token token) {
        Token token2 = this.startAttributes;
        while (token2 != token.next) {
            switch (token2.kind) {
                case 10: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    this.startAttributes = token2;
                    return;
                }
            }
            token2 = token2.next;
        }
    }

    private String getAttributes(Token token) {
        String string = "";
        Token token2 = this.startAttributes;
        while (token2 != token.next) {
            switch (token2.kind) {
                case 12: {
                    string = string + ", rdf:type";
                    break;
                }
                case 6: {
                    string = string + ", rdf:about";
                    break;
                }
                case 7: {
                    string = string + ", rdf:aboutEach";
                    break;
                }
                case 8: {
                    string = string + ", rdf:bagID";
                    break;
                }
                case 5: {
                    string = string + ", rdf:ID";
                    break;
                }
                case 16: {
                    string = string + ", rdf:parseType";
                    break;
                }
                case 20: {
                    string = string + ", rdf:resource";
                    break;
                }
                case 11: {
                    string = string + ", rdf:_NNN";
                    break;
                }
                case 9: {
                    string = string + ", a property attribute";
                    break;
                }
                case 17: {
                    string = string + "='Literal'";
                    break;
                }
                case 19: {
                    string = string + "='Resource'";
                    break;
                }
                case 18: {
                    string = string + "='daml:collection'";
                    break;
                }
                case 10: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    return "Internal mishap in ParseException.getAttributes()";
                }
            }
            token2 = token2.next;
        }
        return string.length() > 2 ? string.substring(2) : string;
    }

    public String getMessage() {
        int n;
        String string;
        String string2 = this.id != 0 ? "{" + (this.id < 200 ? "W" : "E") + ("" + (1000 + this.id)).substring(1) + "} " : (string = "");
        if (!this.specialConstructor) {
            return string + super.getMessage();
        }
        Token token = this.currentToken.next;
        this.startAttrSkip(token);
        String string3 = "Syntax error when processing " + token.toString() + "." + eol;
        if (this.expectedTokenSequences.length == 2 && (this.expectedTokenSequences[0][0] == 3 && this.expectedTokenSequences[1][0] == 1 || this.expectedTokenSequences[1][0] == 3 && this.expectedTokenSequences[0][0] == 1) && (token.kind == 4 || token.kind == 13 || token.kind == 14 || token.kind == 15)) {
            return string + string3 + "Cannot have another XML element here." + eol + "(Maybe one object has already been given as the value of the enclosing property).";
        }
        switch (token.kind) {
            case 1: {
                break;
            }
            case 4: {
                return string + string3 + "rdf:Description elements generally may" + eol + "only occur to describe an object.";
            }
            case 2: {
                return string + string3 + "rdf:RDF element tags generally may not occur inside RDF content.";
            }
            case 9: 
            case 11: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have property attributes in this context.";
                    }
                    return string + string3 + "Cannot have property attributes with the following other attributes:" + eol + "    " + this.getAttributes(this.currentToken);
                }
            }
            case 12: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have rdf:type attribute in this context.";
                    }
                    return string + string3 + "Cannot have rdf:type attribute with the following other attributes:" + eol + "    " + this.getAttributes(this.currentToken);
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 20: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have " + this.tokenImage[token.kind] + " in this context.";
                    }
                    return string + string3 + "In this context, the following attributes are not allowed together:" + eol + "    " + this.getAttributes(token);
                }
            }
            default: {
                string3 = "Unusual " + string3;
            }
        }
        String string4 = "";
        int n2 = 0;
        BitSet bitSet = new BitSet();
        bitSet.set(23);
        int n3 = 0;
        while (n3 < this.expectedTokenSequences.length) {
            switch (this.expectedTokenSequences[n3][0]) {
                case 13: {
                    bitSet.set(14);
                    bitSet.set(15);
                    break;
                }
                case 9: {
                    bitSet.set(11);
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.expectedTokenSequences.length) {
            if (!bitSet.get(this.expectedTokenSequences[n4][0])) {
                if (n2 < this.expectedTokenSequences[n4].length) {
                    n2 = this.expectedTokenSequences[n4].length;
                }
                n = 0;
                while (n < this.expectedTokenSequences[n4].length) {
                    string4 = string4 + this.tokenImage[this.expectedTokenSequences[n4][n]] + " ";
                    ++n;
                }
                string4 = string4 + eol + "    ";
            }
            ++n4;
        }
        string3 = string3 + "Encountered ";
        n = 0;
        while (n < n2) {
            if (n != 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + token.toString();
            if (token.kind == 0) break;
            token = token.next;
            ++n;
        }
        string3 = this.expectedTokenSequences.length == 1 ? string3 + " Was expecting:" + eol + "    " : string3 + " Was expecting one of:" + eol + "    ";
        string3 = string3 + string4;
        return string + string3;
    }

    public static String formatMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof SAXParseException) {
            String string2;
            SAXParseException sAXParseException = (SAXParseException)exception;
            String string3 = sAXParseException.getSystemId();
            if (string3 == null) {
                string3 = sAXParseException.getPublicId();
            }
            String string4 = string2 = string3 == null ? "" : string3;
            if (sAXParseException.getLineNumber() != -1) {
                if (sAXParseException.getColumnNumber() == -1) {
                    return string2 + "[" + sAXParseException.getLineNumber() + "]: " + string;
                }
                return string2 + "[" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + "]: " + string;
            }
            return (string3 != null ? string3 + ": " : "") + string;
        }
        return string;
    }
}

