/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.Code;

public class SecurityHandler
extends AbstractHttpHandler {
    private String _authMethod = "BASIC";
    private String _realmName;
    private boolean _realmForced = false;

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("Handler started");
        }
        this._authMethod = method;
    }

    public void start() throws Exception {
        if (this.getHttpContext().getAuthenticator() == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new BasicAuthenticator());
            } else if ("CLIENT-CERT".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new ClientCertAuthenticator());
            } else {
                Code.warning("Unknown Authentication method:" + this._authMethod);
            }
        }
        super.start();
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        this.getHttpContext().checkSecurityConstraints(pathInContext, request, response);
    }
}

