/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.ExceptionReply;
import org.apache.excalibur.altrmi.common.FacadeRefHolder;
import org.apache.excalibur.altrmi.common.MethodReply;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.NoSuchReferenceReply;
import org.apache.excalibur.altrmi.server.AltrmiPublisher;
import org.apache.excalibur.altrmi.server.MethodInvocationHandler;
import org.apache.excalibur.altrmi.server.PublicationDescription;

public class DefaultMethodInvocationHandler
implements MethodInvocationHandler {
    private WeakHashMap mRefBeans = new WeakHashMap();
    private WeakHashMap mBeanRefs = new WeakHashMap();
    private HashMap mMethodMap;
    private static int NEXT_REFERENCE = 1;
    private AltrmiPublisher mAltrmiPublisher;
    private String mPublishedThing;
    private Object mBeanImpl;
    private final PublicationDescription mPublicationDescription;

    public DefaultMethodInvocationHandler(AltrmiPublisher altrmiPublisher, String publishedThing, HashMap methodMap, PublicationDescription publicationDescription) {
        this.mAltrmiPublisher = altrmiPublisher;
        this.mPublishedThing = publishedThing;
        this.mMethodMap = methodMap;
        this.mPublicationDescription = publicationDescription;
    }

    public String toString() {
        return "DMIH:" + this.mPublishedThing;
    }

    public void addImplementationBean(Long referenceID, Object beanImpl) {
        if (referenceID.equals(new Long(0L))) {
            this.mBeanImpl = beanImpl;
        }
        this.mRefBeans.put(referenceID, new WeakReference<Object>(beanImpl));
        this.mBeanRefs.put(beanImpl, referenceID);
    }

    public void replaceImplementationBean(Object implBean, Object withImplBean) {
        Long ref = (Long)this.mBeanRefs.get(implBean);
        this.mRefBeans.put(ref, new WeakReference<Object>(withImplBean));
        this.mBeanRefs.remove(implBean);
        this.mBeanRefs.put(withImplBean, ref);
        if (this.mBeanImpl == implBean) {
            this.mBeanImpl = withImplBean;
        }
    }

    public Long getOrMakeReferenceIDForBean(Object implBean) {
        Long ref = (Long)this.mBeanRefs.get(implBean);
        if (ref == null) {
            ref = new Long(NEXT_REFERENCE++);
            this.addImplementationBean(ref, implBean);
        }
        return ref;
    }

    public AltrmiReply handleMethodInvocation(MethodRequest request) {
        String methodSignature = request.getMethodSignature();
        if (!this.mMethodMap.containsKey(methodSignature)) {
            return new ExceptionReply((Throwable)new AltrmiInvocationException("Method not present in impl"));
        }
        Method method = (Method)this.mMethodMap.get(methodSignature);
        try {
            WeakReference wr = (WeakReference)this.mRefBeans.get(request.getReferenceID());
            if (wr == null) {
                System.out.println("missing weak reference for referenceID - " + request.getReferenceID() + " pub " + this.mPublishedThing);
                return new NoSuchReferenceReply(request.getReferenceID());
            }
            Object beanImpl = wr.get();
            if (beanImpl == null) {
                System.out.println("Missin beanImpl for " + request.getReferenceID());
                return new NoSuchReferenceReply(request.getReferenceID());
            }
            Object[] args = request.getArgs();
            this.correctArgs(request, args);
            return new MethodReply(method.invoke(beanImpl, request.getArgs()));
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Serializable) {
                return new ExceptionReply(t);
            }
            return new ExceptionReply((Throwable)new AltrmiInvocationException("Exception was not serializable :" + t.getClass().getName()));
        }
        catch (Throwable t) {
            System.out.flush();
            t.printStackTrace();
            return new ExceptionReply((Throwable)new AltrmiInvocationException("Some ServerSide exception problem :" + t.getMessage()));
        }
    }

    private void correctArgs(MethodRequest mr, Object[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof FacadeRefHolder) {
                FacadeRefHolder frh = (FacadeRefHolder)args[i];
                DefaultMethodInvocationHandler methodInvocationHandler = (DefaultMethodInvocationHandler)this.mAltrmiPublisher.getMethodInvocationHandler(frh.getObjectName());
                WeakReference wr = (WeakReference)methodInvocationHandler.mRefBeans.get(frh.getReferenceID());
                args[i] = wr.get();
            }
            ++i;
        }
    }

    private void debug(Object[] args) {
        System.out.println("*************************");
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            System.out.println("i = " + i + " class= " + args[i].getClass().getName() + " " + args[i].toString());
            ++i;
        }
        System.out.println("*************************");
    }

    public Class getMostDerivedType(Object beanImpl) {
        return this.mPublicationDescription.getMostDerivedType(beanImpl);
    }

    public String encodeClassName(String className) {
        return className.replace('.', '$');
    }
}

