/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.adapters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.excalibur.altrmi.common.AltrmiAuthenticationException;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.ClassReply;
import org.apache.excalibur.altrmi.common.ClassRequest;
import org.apache.excalibur.altrmi.common.ClassRetrievalFailedReply;
import org.apache.excalibur.altrmi.common.ExceptionReply;
import org.apache.excalibur.altrmi.common.GarbageCollectionReply;
import org.apache.excalibur.altrmi.common.GarbageCollectionRequest;
import org.apache.excalibur.altrmi.common.ListReply;
import org.apache.excalibur.altrmi.common.LookupReply;
import org.apache.excalibur.altrmi.common.LookupRequest;
import org.apache.excalibur.altrmi.common.MethodFacadeArrayReply;
import org.apache.excalibur.altrmi.common.MethodFacadeReply;
import org.apache.excalibur.altrmi.common.MethodFacadeRequest;
import org.apache.excalibur.altrmi.common.MethodReply;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.NotPublishedReply;
import org.apache.excalibur.altrmi.common.OpenConnectionReply;
import org.apache.excalibur.altrmi.common.PingReply;
import org.apache.excalibur.altrmi.common.RequestFailedReply;
import org.apache.excalibur.altrmi.common.SuspendedReply;
import org.apache.excalibur.altrmi.server.AltrmiAuthenticator;
import org.apache.excalibur.altrmi.server.ClassRetrievalException;
import org.apache.excalibur.altrmi.server.ClassRetriever;
import org.apache.excalibur.altrmi.server.MethodInvocationHandler;
import org.apache.excalibur.altrmi.server.impl.AltrmiSession;
import org.apache.excalibur.altrmi.server.impl.DefaultAuthenticator;
import org.apache.excalibur.altrmi.server.impl.adapters.PublicationAdapter;
import org.apache.excalibur.altrmi.server.impl.classretrievers.NoClassRetriever;

public class InvocationHandlerAdapter
extends PublicationAdapter
implements AltrmiInvocationHandler {
    private static int SESSION = 0;
    private Long mLastSession = new Long(0L);
    private HashMap mSessions = new HashMap();
    private boolean mSuspend = false;
    private ClassRetriever mClassRetriever = new NoClassRetriever();
    private AltrmiAuthenticator mAltrmiAuthenticator = new DefaultAuthenticator();

    public final void setClassRetriever(ClassRetriever classRetriever) {
        this.mClassRetriever = classRetriever;
    }

    public final void setAuthenticator(AltrmiAuthenticator altrmiAuthenticator) {
        this.mAltrmiAuthenticator = altrmiAuthenticator;
    }

    public AltrmiReply handleInvocation(AltrmiRequest request) {
        if (this.mSuspend) {
            return new SuspendedReply();
        }
        if (request.getRequestCode() == 302) {
            return this.doMethodRequest(request);
        }
        if (request.getRequestCode() == 303) {
            return this.doMethodFacadeRequest(request);
        }
        if (request.getRequestCode() == 308) {
            return this.doGarbageCollectionRequest(request);
        }
        if (request.getRequestCode() == 304) {
            return this.doLookupRequest(request);
        }
        if (request.getRequestCode() == 301) {
            return this.doClassRequest(request);
        }
        if (request.getRequestCode() == 305) {
            return this.doOpenConnectionRequest();
        }
        if (request.getRequestCode() == 306) {
            return new PingReply();
        }
        if (request.getRequestCode() == 307) {
            return this.doListRequest();
        }
        return new RequestFailedReply("Unknown request :" + request.getClass().getName());
    }

    private AltrmiReply doMethodFacadeRequest(AltrmiRequest request) {
        MethodFacadeRequest mFacReq = (MethodFacadeRequest)request;
        String publishedThing = mFacReq.getPublishedServiceName() + "_" + mFacReq.getObjectName();
        if (!this.mPublishedObjects.containsKey(publishedThing)) {
            return new NotPublishedReply();
        }
        if (!this.sessionExists(mFacReq.getSession())) {
            return new ExceptionReply((Throwable)new AltrmiInvocationException("TODO - you dirty rat/hacker"));
        }
        MethodInvocationHandler methodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(publishedThing);
        AltrmiReply ar = methodInvocationHandler.handleMethodInvocation((MethodRequest)mFacReq);
        if (ar.getReplyCode() == 3) {
            return ar;
        }
        if (ar.getReplyCode() >= 100) {
            return ar;
        }
        if (ar.getReplyCode() == 2) {
            Object methodReply = ((MethodReply)ar).getReplyObject();
            if (methodReply == null) {
                return new MethodFacadeReply(null, null);
            }
            if (!methodReply.getClass().isArray()) {
                return this.doMethodFacadeRequestNonArray(methodReply, mFacReq);
            }
            return this.doMethodFacadeRequestArray(methodReply, mFacReq);
        }
        return new RequestFailedReply("TODO");
    }

    private AltrmiReply doMethodFacadeRequestArray(Object methodReply, MethodFacadeRequest mFacReq) {
        Object[] beanImpls = (Object[])methodReply;
        Long[] refs = new Long[beanImpls.length];
        String[] objectNames = new String[beanImpls.length];
        int i = 0;
        while (i < beanImpls.length) {
            Object impl = beanImpls[i];
            MethodInvocationHandler mainMethodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(mFacReq.getPublishedServiceName() + "_Main");
            objectNames[i] = this.encodeClassName(mainMethodInvocationHandler.getMostDerivedType(beanImpls[i]).getName());
            MethodInvocationHandler methodInvocationHandler2 = (MethodInvocationHandler)this.mPublishedObjects.get(mFacReq.getPublishedServiceName() + "_" + objectNames[i]);
            if (methodInvocationHandler2 == null) {
                return new NotPublishedReply();
            }
            if (!this.sessionExists(mFacReq.getSession())) {
                return new ExceptionReply((Throwable)new AltrmiInvocationException("TODO - you dirty rat/hacker"));
            }
            if (beanImpls[i] == null) {
                refs[i] = null;
            } else {
                refs[i] = methodInvocationHandler2.getOrMakeReferenceIDForBean(beanImpls[i]);
                AltrmiSession sess = (AltrmiSession)this.mSessions.get(mFacReq.getSession());
                sess.addBeanInUse(refs[i], beanImpls[i]);
            }
            ++i;
        }
        return new MethodFacadeArrayReply(refs, objectNames);
    }

    private AltrmiReply doMethodFacadeRequestNonArray(Object beanImpl, MethodFacadeRequest mFacReq) {
        MethodInvocationHandler mainMethodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(mFacReq.getPublishedServiceName() + "_Main");
        String objectName = this.encodeClassName(mainMethodInvocationHandler.getMostDerivedType(beanImpl).getName());
        MethodInvocationHandler methodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(mFacReq.getPublishedServiceName() + "_" + objectName);
        if (methodInvocationHandler == null) {
            return new NotPublishedReply();
        }
        if (!this.sessionExists(mFacReq.getSession())) {
            return new ExceptionReply((Throwable)new AltrmiInvocationException("TODO - you dirty rat/hacker"));
        }
        Long newRef = methodInvocationHandler.getOrMakeReferenceIDForBean(beanImpl);
        AltrmiSession sess = (AltrmiSession)this.mSessions.get(mFacReq.getSession());
        sess.addBeanInUse(newRef, beanImpl);
        return new MethodFacadeReply(newRef, objectName);
    }

    private AltrmiReply doMethodRequest(AltrmiRequest request) {
        MethodRequest mReq = (MethodRequest)request;
        String publishedThing = mReq.getPublishedServiceName() + "_" + mReq.getObjectName();
        if (!this.mPublishedObjects.containsKey(publishedThing)) {
            return new NotPublishedReply();
        }
        MethodInvocationHandler methodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(publishedThing);
        return methodInvocationHandler.handleMethodInvocation(mReq);
    }

    private AltrmiReply doLookupRequest(AltrmiRequest request) {
        LookupRequest lr = (LookupRequest)request;
        try {
            this.mAltrmiAuthenticator.checkAuthority(lr.getAltrmiAuthentication(), lr.getPublishedServiceName());
        }
        catch (AltrmiAuthenticationException aae) {
            return new ExceptionReply((Throwable)aae);
        }
        return new LookupReply(new Long(0L));
    }

    private AltrmiReply doClassRequest(AltrmiRequest request) {
        ClassRequest cr = (ClassRequest)request;
        String publishedThing = cr.getPublishedServiceName() + "_" + cr.getObjectName();
        try {
            return new ClassReply(this.mClassRetriever.getBeanBytes(publishedThing), this.mClassRetriever.getInterfaceImplementationBytes(publishedThing));
        }
        catch (ClassRetrievalException e) {
            e.printStackTrace();
            return new ClassRetrievalFailedReply(e.getMessage());
        }
    }

    private AltrmiReply doOpenConnectionRequest() {
        Long session = this.getNewSession();
        this.mSessions.put(session, new AltrmiSession(session));
        return new OpenConnectionReply(this.mAltrmiAuthenticator.getTextToSign(), session);
    }

    private AltrmiReply doListRequest() {
        Iterator iterator = this.mPublishedObjects.keySet().iterator();
        Vector<String> vecOfPublishedObjectNames = new Vector<String>();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (!item.endsWith("_Main")) continue;
            vecOfPublishedObjectNames.add(item.substring(0, item.lastIndexOf("_Main")));
        }
        String[] _listOfPublishedObjectNames = new String[vecOfPublishedObjectNames.size()];
        System.arraycopy(vecOfPublishedObjectNames.toArray(), 0, _listOfPublishedObjectNames, 0, vecOfPublishedObjectNames.size());
        return new ListReply(_listOfPublishedObjectNames);
    }

    private AltrmiReply doGarbageCollectionRequest(AltrmiRequest request) {
        GarbageCollectionRequest gcr = (GarbageCollectionRequest)request;
        String publishedThing = gcr.getPublishedServiceName() + "_" + gcr.getObjectName();
        if (!this.mPublishedObjects.containsKey(publishedThing)) {
            return new NotPublishedReply();
        }
        if (!this.sessionExists(gcr.getSession())) {
            return new ExceptionReply((Throwable)new AltrmiInvocationException("TODO - you dirty rat/hacker"));
        }
        AltrmiSession sess = (AltrmiSession)this.mSessions.get(gcr.getSession());
        if (sess == null) {
            System.out.println("DEBUG- GC on missing session -" + gcr.getSession());
        }
        if (gcr.getReferenceID() == null) {
            System.out.println("DEBUG- GC on missing referenceID -" + gcr.getReferenceID());
        }
        sess.removeBeanInUse(gcr.getReferenceID());
        MethodInvocationHandler methodInvocationHandler = (MethodInvocationHandler)this.mPublishedObjects.get(publishedThing);
        return new GarbageCollectionReply();
    }

    private boolean sessionExists(Long session) {
        if (this.mLastSession.equals(session)) {
            return true;
        }
        if (this.mSessions.containsKey(session)) {
            this.mLastSession = session;
            return true;
        }
        return false;
    }

    private Long getNewSession() {
        return new Long(((long)SESSION++ << 32) + Math.round(Math.random()));
    }

    public void suspend() {
        this.mSuspend = true;
    }

    public void resume() {
        this.mSuspend = false;
    }
}

