/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.classretrievers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.excalibur.altrmi.common.ProxyGenerator;
import org.apache.excalibur.altrmi.server.AltrmiProxyGenerator;
import org.apache.excalibur.altrmi.server.ClassRetrievalException;
import org.apache.excalibur.altrmi.server.ClassRetriever;
import org.apache.excalibur.altrmi.server.ProxyGenerationEnvironmentException;
import org.apache.excalibur.altrmi.server.PublicationDescription;
import org.apache.excalibur.altrmi.server.PublicationException;

public class AbstractDynamicGeneratorClassRetriever
implements AltrmiProxyGenerator,
ClassRetriever {
    private String m_altrmiClasspath;
    private String m_classGenDir = ".";
    private String m_srcGenDir;
    private Class m_generatorClass;

    public AbstractDynamicGeneratorClassRetriever(ClassLoader classLoader, String generatorClassName) {
        try {
            this.m_generatorClass = classLoader.loadClass(generatorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(generatorClassName);
        }
    }

    public void generate(String asName, Class interfaceToExpose, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, new PublicationDescription(interfaceToExpose), classLoader, false);
    }

    public void generate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, false);
    }

    public void deferredGenerate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, true);
    }

    public void setAltrmiClasspath(String altrmiClasspath) {
        this.m_altrmiClasspath = altrmiClasspath;
    }

    public void addToAltrmiClasspath(String classpathElement) {
        this.m_altrmiClasspath = this.m_altrmiClasspath + File.pathSeparator + classpathElement;
    }

    public void setClassGenDir(String classGenDir) {
        this.m_classGenDir = classGenDir;
    }

    public final byte[] getBeanBytes(String publishedName) throws ClassRetrievalException {
        return this.getThingBytes("AltrmiGenerated" + publishedName);
    }

    public final byte[] getInterfaceImplementationBytes(String publishedName) throws ClassRetrievalException {
        return this.getThingBytes("AltrmiGenerated2" + publishedName);
    }

    protected byte[] getThingBytes(String thingName) throws ClassRetrievalException {
        FileInputStream fis;
        thingName = thingName.replace('.', '\\') + ".class";
        try {
            fis = new FileInputStream(new File(this.m_classGenDir, thingName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Generated class not found in classloader specified : " + e.getMessage());
        }
        if (fis == null) {
            throw new ClassRetrievalException("Generated class not found in classloader specified.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        try {
            while (-1 != (i = fis.read())) {
                baos.write(i);
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Error retrieving generated class bytes : " + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public void setSrcGenDir(String srcGenDir) {
        this.m_srcGenDir = srcGenDir;
    }

    /*
     * Unable to fully structure code
     */
    private void generateProxy(String asName, PublicationDescription publicationDescription, ClassLoader classLoader, boolean deferred) throws PublicationException {
        block13: {
            block12: {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                interfacesToExpose = new Class[]{};
                addInfs = new Class[]{};
                interfacesToExpose = publicationDescription.getInterfacesToExpose();
                addInfs = publicationDescription.getAdditionalFacades();
                try {
                    proxyGenerator = (ProxyGenerator)this.m_generatorClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("ProxyGenerator cannot be instantiated.");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("ProxyGenerator was illegally accessed");
                }
                proxyGenerator.setSrcGenDir(this.m_srcGenDir);
                proxyGenerator.setClassGenDir(this.m_classGenDir);
                proxyGenerator.setGenName(asName);
                proxyGenerator.setClasspath(this.m_altrmiClasspath);
                proxyGenerator.setInterfacesToExpose(interfacesToExpose);
                proxyGenerator.setAdditionalFacades(addInfs);
                try {
                    proxyGenerator.generateSrc(classLoader);
                    break block12;
                }
                catch (Throwable t) {
                    System.out.println("******");
                    System.out.println("** Exception while making source : ");
                    System.out.flush();
                    t.printStackTrace();
                    System.out.println("** Name=" + asName);
                    System.out.println("** Classes/Interfaces to Expose..");
                    i = 0;
                    ** while (i < interfacesToExpose.length)
                }
lbl-1000:
                // 1 sources

                {
                    aString = interfacesToExpose[i].getName();
                    System.out.println("** .." + aString);
                    ++i;
                    continue;
                }
lbl36:
                // 1 sources

                System.out.println("******");
                System.out.flush();
            }
            if (!deferred) {
                try {
                    proxyGenerator.generateClass(classLoader);
                    break block13;
                }
                catch (Throwable t) {
                    if (t instanceof NoClassDefFoundError && t.getMessage().equals("sun/tools/javac/Main")) {
                        System.out.println("***************************************");
                        System.out.println("*                                     *");
                        System.out.println("* AltRMI problem......                *");
                        System.out.println("* Please copy JAVA_HOME/lib/tools.jar *");
                        System.out.println("* to your applications classpath so   *");
                        System.out.println("* that proxys can be compiled.        *");
                        System.out.println("*                                     *");
                        System.out.println("***************************************");
                        throw new ProxyGenerationEnvironmentException("tools.jar not found in classpath.");
                    }
                    System.out.println("******");
                    System.out.println("** Exception while making String : ");
                    System.out.flush();
                    t.printStackTrace();
                    System.out.println("** SrcDir=" + this.m_srcGenDir);
                    System.out.println("** ClassDir=" + this.m_classGenDir);
                    System.out.println("** Name=" + asName);
                    System.out.println("** CLasspath=" + this.m_altrmiClasspath);
                    System.out.println("** Classes/Interfaces to Expose..");
                    i = 0;
                    ** while (i < interfacesToExpose.length)
                }
lbl-1000:
                // 1 sources

                {
                    aString = interfacesToExpose[i].getName();
                    System.out.println("** .." + aString);
                    ++i;
                    continue;
                }
lbl69:
                // 1 sources

                System.out.println("******");
                System.out.flush();
            }
        }
    }

    public void generateDeferred(ClassLoader classLoader) {
        ProxyGenerator proxyGenerator;
        try {
            proxyGenerator = (ProxyGenerator)this.m_generatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("ProxyGenerator cannot be instantiated.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ProxyGenerator was illegally accessed");
        }
        proxyGenerator.generateDeferredClasses();
    }
}

