/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import java.io.File;
import java.util.Enumeration;

import org.apache.avalon.excalibur.xml.Parser;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;

import fr.gouv.culture.sdx.exception.SDXException;

/**
 * An indexable document is a document that can be indexed with SDX.
 *
 * <p>
 * Such a document must be able to receive SAX events that will build
 * the fields to index, and return thoses fields to the caller.
 */
public interface IndexableDocument extends fr.gouv.culture.sdx.document.Document, XMLConsumer {

    /** Returns an enumeration of Property, one for each field defined. */
    public Enumeration getFieldValues();

    /** Starts the indexing process. */
    public void startIndexing(Parser parser, XMLConsumer consumer) throws SDXException;

    /**Returns an enumeration of the documentsN attached to this document*/
    public Enumeration getAttachedDocuments();

    /**Returns an enumeration of the sub(Indexable) documents attached to this document*/
    public Enumeration getSubDocuments();

    /**Allows a transformed document to be built from a byte array*/
    public void setTransformedDocument(byte[] content) throws SDXException;

    /**Allows a transformed document to be built from a file*/
    public void setTransformedDocument(File file) throws SDXException;

    /**Returns the transformed document*/
    public IndexableDocument getTransformedDocument();

    public AbstractIndexableDocument.StoreHandler getStoreHandler();

    void setMessageHandler(ContentHandler handler);

    void setBoost(float boost);

    float getBoost();

    /**Reinits the Vector of attached documents*/
    void resetAttachedDocuments();

    /**Some additional system fields adding to the Lucene document*/
    public void addAdditionalSystemFields(org.apache.lucene.document.Document doc);


}
