/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.search.lucene.queryparser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 11 janv. 2004
 * Time: 18:42:27
 * To change this template use Options | File Templates.
 */

/**QueryParser for Analyzers returning tokens with positions increments set to
 * zero (code by Pierrick Brihaye)
 *
 */
public class ZeroPositionIncrementTokenQueryParser extends DefaultQueryParser {

    /**
     * @exception ParseException throw in overridden method to disallow
     */
    protected Query getFieldQuery(String field,
                                  Analyzer analyzer,
                                  String queryText) throws ParseException {
        // Use the analyzer to get all the tokens, and then build a TermQuery,
        // PhraseQuery, or nothing based on the term count

        TokenStream source = analyzer.tokenStream(field,
                new StringReader(queryText));
        Vector v = new Vector();
        org.apache.lucene.analysis.Token t;

        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;

        while (true) {
            try {
                t = source.next();
            } catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t);
            if (t.getPositionIncrement() == 1)
                positionCount++;
            else
                severalTokensAtSamePosition = true;
        }
        if (v.size() == 0)
            return null;
        else if (v.size() == 1) {
            t = (org.apache.lucene.analysis.Token) v.elementAt(0);
            return new TermQuery(new Term(field, t.termText()));
        } else {
            if (severalTokensAtSamePosition) {
                if (positionCount == 1) {
                    BooleanQuery q = new BooleanQuery();
                    for (int i = 0; i < v.size(); i++) {
                        t = (org.apache.lucene.analysis.Token) v.elementAt(i);
                        TermQuery currentQuery = new TermQuery(new Term(field, t.termText()));
                        q.add(currentQuery, false, false);
                    }
                    return q;
                } else {

                    BooleanQuery q = new BooleanQuery();
                    Vector queriesSoFar = new Vector();
                    Vector newQueries = new Vector();
                    PhraseQuery currentQuery;
                    int currentPosition = 0;

                    for (int i = 0; i < v.size(); i++) {
                        t = (org.apache.lucene.analysis.Token) v.elementAt(i);
                        //detect new position
                        if (t.getPositionIncrement() == 1) {
                            queriesSoFar.removeAllElements();
                            for (int j = 0; j < newQueries.size(); j++) {
                                queriesSoFar.add(newQueries.elementAt(j));
                            }
                            newQueries.removeAllElements();
                            currentPosition++;
                        }
                        if (currentPosition == 1) {
                            currentQuery = new PhraseQuery();
                            currentQuery.setSlop(phraseSlop);
                            currentQuery.add(new Term(field, t.termText()));
                            newQueries.add(currentQuery);
                            //Re-use previous queries
                        } else {
                            for (int j = 0; j < queriesSoFar.size(); j++) {
                                PhraseQuery previousQuery = (PhraseQuery) queriesSoFar.elementAt(j);
                                Term[] terms = previousQuery.getTerms();
                                currentQuery = new PhraseQuery();
                                currentQuery.setSlop(phraseSlop);
                                for (int k = 0; k < terms.length; k++) {
                                    currentQuery.add(terms[k]);
                                }
                                currentQuery.add(new Term(field, t.termText()));
                                newQueries.add(currentQuery);
                            }
                        }
                    }
                    for (int i = 0; i < newQueries.size(); i++) {
                        currentQuery = (PhraseQuery) newQueries.elementAt(i);
                        q.add(currentQuery, false, false);
                    }
                    return q;
                }
            } else {
                PhraseQuery q = new PhraseQuery();
                q.setSlop(phraseSlop);
                for (int i = 0; i < v.size(); i++) {
                    q.add(new Term(field, ((org.apache.lucene.analysis.Token) v.elementAt(i)).termText()));
                }
                return q;
            }
        }
    }


}
