/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.constants.Node;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

import java.io.File;
import java.util.Hashtable;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Feb 24, 2003
 * Time: 2:26:23 PM
 * To change this template use Options | File Templates.
 */
public class DatabaseBacked extends SdxObjectImpl implements Composable {
    //DatabaseBacked objects can be out of sync with a database object based upon
    //the users decision to change database type, this change should be wisely done
    //and a reindexation may be necessary
    protected final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.utils.database.";
    protected final String DEFAULT_DATABASE_TYPE = PACKAGE_QUALNAME + "HSQLDatabase";
    protected final String CLASS_NAME_SUFFIX = "Database";
    public static final String ELEMENT_NAME_DATABASE = "database";
    protected final String ATTRIBUTE_ID = Node.Name.ID;

    public String DATABASE_DIR_NAME = "sdx-database";//defaulted

    protected ComponentManager _manager = null;
    protected Hashtable props = null;
    protected Database database = null;
    protected String dbPath = null;
    protected File dbLocation = null;
    protected String id = null;
    protected Configuration databaseConf = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws SDXException {
        this.id = id;
    }


    public void setProperties(Hashtable props) {
        this.props = props;
    }

    /**
     * Sets the Avalon component manager.
     */
    public void compose(ComponentManager componentManager) throws ComponentException {
        this._manager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);

        this.id = configuration.getAttribute(ATTRIBUTE_ID, this.id);
        //establishing the default configuration object
        Configuration defaultDatabaseConf = (Configuration) props.get(Application.DEFAULT_DATABASE_CONF);
        if (defaultDatabaseConf == null) defaultDatabaseConf = new DefaultConfiguration("", "");
        this.databaseConf = configuration.getChild(ELEMENT_NAME_DATABASE, false);
        //verifying the configuration if not we use a default
        if (this.databaseConf == null && defaultDatabaseConf != null)
            this.databaseConf = defaultDatabaseConf;
        try {

            String dbType = databaseConf.getAttribute(Node.Name.TYPE, DEFAULT_DATABASE_TYPE);
            //reading the database type attribute, if not we use the default, currently "HSQLDatabase"
            //trying the attribute value, hopefully the user is providing a fully qualified attribute name
            String dbClassName = dbType;
            Class dbClass = null;
            try {
                dbClass = Class.forName(dbClassName);
            } catch (ClassNotFoundException e) {
                //logging the first failure
                Utilities.logWarn(logger, e.getMessage(), null);
                //trying to building the fully qualified class name based on the type
                dbClassName = PACKAGE_QUALNAME + dbType.substring(0, 1).toUpperCase() + dbType.substring(1, dbType.length())/*.toLowerCase()*/ + CLASS_NAME_SUFFIX;
                dbClass = Class.forName(dbClassName);
            }
            //building a new instance of a DB object
            //Object obj = dbClass.newInstance();
            //the object does implement our interface
            //casting it into a DataBase object
            try {
                database = (Database) dbClass.newInstance();
            } catch (ClassCastException e) {
                //the object doesn't implement our interface
                String[] args = new String[3];
                args[0] = CLASS_NAME_SUFFIX;
                args[1] = dbClass.getName();
                args[2] = dbType;
                throw new SDXException(logger, SDXExceptionCode.ERROR_CLASS_NOT_INSTANCEOF_SDX_INTERFACE, args, null);
            }

/*                if (obj == null) {
                    String[] args = new String[1];
                    args[0] = dbClassName;
                    throw new SDXException(logger, SDXExceptionCode.ERROR_NEW_OBJECT_INSTANCE_NULL, args, null);
                }
                //testing to see if the object implements the fr.gouv.culture.sdx.utils.database.Database Interface
                if (!(obj instanceof Database)) {
                    //the object doesn't implement our interface
                    String[] args = new String[3];
                    args[0] = CLASS_NAME_SUFFIX;
                    args[1] = dbClass.getName();
                    args[2] = dbType;
                    throw new SDXException(logger, SDXExceptionCode.ERROR_CLASS_NOT_INSTANCEOF_SDX_INTERFACE, args, null);
                }
                */
            //setting the DB's logger
            database.enableLogging(this.logger);
            database.compose(this._manager);
            //trying to set the database directory name something like _hsql, or _lucene
            String dbDirName = database.getDatabaseDirectoryName();
            if (Utilities.checkString(dbDirName))
                this.DATABASE_DIR_NAME = dbDirName;
            //setting properties for the database
            database.setProperties(this.props);
            //passing the id to the database, using for building table names in the configure() method
            database.setId(this.id);
            //configuring the database
            database.configure(databaseConf);


        } catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), e);
        } catch (InstantiationException e) {
            throw new ConfigurationException(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), e);
        } catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e);
        } catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }


    }

    public void init() throws SDXException {
        //TODOException: subclasses should verify class variable id at the end of their configure methods
        if (database != null)
            database.init();

    }

    public Database getDatabase() {
        return database;
    }
}
