/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import org.apache.cocoon.xml.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OAIError
extends OAIObjectImpl
implements XMLizable {
    public static final int ERROR_UNKNOWN = -1;
    public static final int ERROR_BAD_ARGUMENT = 0;
    public static final int ERROR_BAD_RESUMPTION_TOKEN = 1;
    public static final int ERROR_BAD_VERB = 2;
    public static final int ERROR_CANNOT_DISSEMINATE_FORMAT = 3;
    public static final int ERROR_ID_DOES_NOT_EXIST = 4;
    public static final int ERROR_NO_RECORDS_MATCH = 5;
    public static final int ERROR_NO_METADATA_FORMATS = 6;
    public static final int ERROR_NO_SET_HIERARCHY = 7;
    public static final int ERROR_BAD_DATE = 8;
    public static final String ERROR_STRING_UNKNOWN = "unknown";
    public static final String ERROR_STRING_BAD_ARGUMENT = "badArgument";
    public static final String ERROR_STRING_BAD_RESUMPTION_TOKEN = "badResumptionToken";
    public static final String ERROR_STRING_BAD_VERB = "badVerb";
    public static final String ERROR_STRING_CANNOT_DISSEMINATE_FORMAT = "cannotDisseminateFormat";
    public static final String ERROR_STRING_ID_DOES_NOT_EXIST = "idDoesNotExist";
    public static final String ERROR_STRING_NO_RECORDS_MATCH = "noRecordsMatch";
    public static final String ERROR_STRING_NO_METADATA_FORMATS = "noMetadataFormats";
    public static final String ERROR_STRING_NO_SET_HIERARCHY = "noSetHierarchy";
    public static final String ERROR_STRING_BAD_DATE = "badDate";
    int intErrorCode = -1;
    String stringErrorCode = "unknown";
    String reason = "";

    public OAIError(int errorCode) {
        this.setUp(errorCode);
    }

    public OAIError(int errorCode, String reason) {
        this(errorCode);
        this.reason = reason;
    }

    protected void setUp(int errorCode) {
        this.intErrorCode = errorCode;
        switch (this.intErrorCode) {
            case 0: {
                this.stringErrorCode = ERROR_STRING_BAD_ARGUMENT;
                break;
            }
            case 1: {
                this.stringErrorCode = ERROR_STRING_BAD_RESUMPTION_TOKEN;
                break;
            }
            case 2: {
                this.stringErrorCode = ERROR_STRING_BAD_VERB;
                break;
            }
            case 3: {
                this.stringErrorCode = ERROR_STRING_CANNOT_DISSEMINATE_FORMAT;
                break;
            }
            case 4: {
                this.stringErrorCode = ERROR_STRING_ID_DOES_NOT_EXIST;
                break;
            }
            case 5: {
                this.stringErrorCode = ERROR_STRING_NO_RECORDS_MATCH;
                break;
            }
            case 6: {
                this.stringErrorCode = ERROR_STRING_NO_METADATA_FORMATS;
                break;
            }
            case 7: {
                this.stringErrorCode = ERROR_STRING_NO_SET_HIERARCHY;
                break;
            }
            default: {
                this.stringErrorCode = ERROR_STRING_UNKNOWN;
            }
        }
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        ContentHandler currentHandler = this.contentHandler;
        super.setContentHandler(contentHandler);
        AttributesImpl atts = new AttributesImpl();
        if (OAIUtilities.checkString(this.stringErrorCode)) {
            atts.addAttribute("", "code", "code", "CDATA", this.stringErrorCode);
        }
        super.sendElement("http://www.openarchives.org/OAI/2.0/", "error", "error", atts, this.reason);
        super.setContentHandler(currentHandler);
    }
}

