/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIError;
import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.OAIResponse;
import fr.gouv.culture.oai.util.OAIUtilities;
import java.util.Date;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OAIResponseImpl
extends OAIObjectImpl
implements OAIResponse {
    protected OAIRequest request = null;
    protected OAIRepository repository = null;

    public void setRepository(OAIRepository repository) {
        this.repository = repository;
    }

    public OAIRepository getRepository() {
        return this.repository;
    }

    public void setRequest(OAIRequest request) {
        this.request = request;
    }

    public OAIRequest getRequest() {
        return this.request;
    }

    public void sendResponse() throws SAXException {
        if (this.request != null && this.repository != null) {
            int verb = this.request.getVerb();
            this.beginOaiEnvelopeEvents();
            switch (verb) {
                case 0: {
                    this.verifyParameters();
                    this.repository.identify(this.request);
                    break;
                }
                case 1: {
                    this.verifyParameters();
                    this.repository.listSets(this.request);
                    break;
                }
                case 2: {
                    this.verifyParameters();
                    this.repository.listMetadataFormats(this.request);
                    break;
                }
                case 3: {
                    this.verifyParameters();
                    this.repository.listIdentifiers(this.request);
                    break;
                }
                case 4: {
                    this.verifyParameters();
                    this.repository.listRecords(this.request);
                    break;
                }
                case 5: {
                    this.verifyParameters();
                    this.repository.getRecord(this.request);
                    break;
                }
                default: {
                    String verbString = this.request.getVerbString();
                    String errorString = "The verb";
                    if (OAIUtilities.checkString(verbString)) {
                        errorString = errorString + ", " + verbString + ",";
                    }
                    errorString = errorString + " is unknown or a value was not provided.";
                    new OAIError(2, errorString).toSAX((ContentHandler)((Object)this));
                }
            }
            this.endOaiEnvelopeEvents();
        }
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        ContentHandler currentHandler = this.contentHandler;
        super.setContentHandler(contentHandler);
        this.sendResponse();
        super.setContentHandler(currentHandler);
    }

    protected void beginOaiEnvelopeEvents() throws SAXException {
        this.startOaiRootElement();
        this.sendResponseDate();
        this.sendRequestEvents(this.verifyParameters());
    }

    protected void endOaiEnvelopeEvents() throws SAXException {
        this.endOaiRootElement();
    }

    protected void startOaiRootElement() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        super.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
        super.startElement("http://www.openarchives.org/OAI/2.0/", "OAI-PMH", "OAI-PMH", atts);
    }

    protected void endOaiRootElement() throws SAXException {
        super.endElement("http://www.openarchives.org/OAI/2.0/", "OAI-PMH", "OAI-PMH");
        super.endPrefixMapping("xsi");
    }

    protected void sendResponseDate() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        super.startElement("http://www.openarchives.org/OAI/2.0/", "responseDate", "responseDate", atts);
        Date date = OAIUtilities.Date.getUtcIso8601Date();
        String utcDate = OAIUtilities.Date.formatUtcISO8601Date(date);
        super.sendElementContent(utcDate);
        super.endElement("http://www.openarchives.org/OAI/2.0/", "responseDate", "responseDate");
    }

    protected void sendRequestEvents(boolean sendRequestParams) throws SAXException {
        if (this.request != null) {
            this.request.setConsumer(this.xmlConsumer);
            this.request.toSAX((ContentHandler)((Object)this), sendRequestParams);
        }
    }

    protected boolean verifyParameters() throws SAXException {
        if (this.repository != null) {
            return this.repository.verifyParameters(this.request);
        }
        return false;
    }
}

