/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.AbstractOAIHarvester;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.OAIRequestImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.OAIDocument;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.OAIEnvelopStripper;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.lucene.query.ComplexQuery;
import fr.gouv.culture.sdx.search.lucene.query.DateIntervalQuery;
import fr.gouv.culture.sdx.search.lucene.query.FieldQuery;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.utils.ConfigurationUtilities;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.SimpleTimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.Target;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTriggerFactory;
import fr.gouv.culture.util.apache.cocoon.xml.SynchronizedXMLConsumerWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLMulticaster;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractDocumentBaseOAIHarvester
extends AbstractOAIHarvester
implements Target {
    protected String ELEMENT_NAME_PIPELINE = "pipeline";
    protected DocumentBase docbase = null;
    protected String docbaseId = "";
    protected Hashtable docBaseProps = null;
    protected Pipeline pipe = null;
    protected Database database = null;
    protected Hashtable storedRequests = null;
    protected Hashtable storeRepositoriesRefs = null;
    protected TimeScheduler scheduler = null;
    protected IDGenerator harvesterIdGen = null;
    protected String TEMPFILE_SUFFIX = ".sdx";
    protected File tempDir = null;
    protected File harvestDoc = null;
    protected FileOutputStream fileOs = null;
    protected XMLDocument urlResource = null;
    protected ArrayList deletedDocs = null;
    protected ArrayList harvestedDocs = null;
    protected int noDocsHarvested = 0;
    protected int noDocsDeleted = 0;
    protected boolean keepDeletedRecords = false;
    protected int noRecordsPerBatch = 1000;
    protected static final String ELEMENT_NAME_OAI_DATA_PROVIDERS = "oai-data-providers";
    protected static final String ELEMENT_NAME_OAI_VERB = "oai-verb";
    protected static final String ELEMENT_NAME_OAI_IDENTIFIER = "oai-identifier";
    protected static final String ATTRIBUTE_NAME_NAME = "name";
    protected static final String ATTRIBUTE_NAME_ADMIN_EMAIL = "adminEmail";
    protected static final String ATTRIBUTE_NAME_USER_AGENT = "userAgent";
    protected static final String ATTRIBUTE_NAME_URL = "url";
    protected static final String ATTRIBUTE_NAME_UPDATE = "update";
    protected static final String ATTRIBUTE_NAME_METADATA_PREFIX = "metadataPrefix";
    protected static final String ATTRIBUTE_NAME_SDX_REPOSITORY = "sdxRepository";
    protected static final String ATTRIBUTE_NAME_FROM = "from";
    protected static final String ATTRIBUTE_USE_LAST_HARVEST_DATE = "useLastHarvestDate";
    protected static final String ATTRIBUTE_NAME_UNTIL = "until";
    protected static final String ATTRIBUTE_NAME_SET = "set";
    protected static final String ATTRIBUTE_NAME_KEEP_DELETED_RECORD = "keepDeletedRecords";
    protected static final String ATTRIBUTE_NO_RECORDS_PER_BATCH = "noRecordsPerBatch";
    protected static final String OAI_HARVEST_ID = "oaiHarvestId";
    protected static final String OAI_FAILED_HARVEST = "oaiFailedHarvest";
    protected static final String OAI_HARVESTER_LAST_UPDATED = "oaiHarvesterLastUpdated";
    protected static final String OAI_HARVESTER_RESUMPTION_TOKEN = "oaiHarvesterResumptionToken";
    protected static final String OAI_VERB = "oaiVerb";
    protected static final String OAI_IDENTIFIER = "oaiIdentifier";
    protected static final String OAI_METADATA_PREFIX = "oaiMetadataPrefix";
    protected static final String OAI_FROM = "oaiFrom";
    protected static final String OAI_UNTIL = "oaiUntil";
    protected static final String OAI_SET = "oaiSet";
    protected static final String NO_DOCS_DELETED = "noDocDeleted";
    protected static final String NO_DOCS_HARVESTED = "noDocHarvested";
    protected Hashtable filesProperties = null;

    public AbstractDocumentBaseOAIHarvester(DocumentBase base) {
        this.docbase = base;
        if (this.docbase != null) {
            this.docbaseId = this.docbase.getId();
        }
    }

    public void setProperties(Hashtable props) {
        this.docBaseProps = props;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.userAgent = configuration.getAttribute(ATTRIBUTE_NAME_USER_AGENT, "SDX OAI Harvester");
        this.keepDeletedRecords = configuration.getAttributeAsBoolean(ATTRIBUTE_NAME_KEEP_DELETED_RECORD, this.keepDeletedRecords);
        this.noRecordsPerBatch = configuration.getAttributeAsInteger(ATTRIBUTE_NO_RECORDS_PER_BATCH, this.noRecordsPerBatch);
        this.configureAdminEmails(configuration);
        this.configureDataProviders(configuration);
        this.configurePipeline(configuration);
        this.configureDatabase(configuration);
        this.configureHarvestIDGenerator(configuration);
    }

    protected void configureDatabase(Configuration configuration) throws ConfigurationException {
        DatabaseBacked internalDb = new DatabaseBacked();
        try {
            internalDb.setId(this.getHarvesterId());
            internalDb.compose(this.manager);
            internalDb.setProperties(this.docBaseProps);
            internalDb.configure(configuration);
            internalDb.init();
            this.database = internalDb.getDatabase();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void configureHarvestIDGenerator(Configuration configuration) throws ConfigurationException {
        this.harvesterIdGen = ConfigurationUtilities.configureIDGenerator(this.logger, configuration);
        this.harvesterIdGen.setDatabase(this.database);
    }

    protected String getHarvesterId() {
        String hid = "";
        hid = hid + "sdx_";
        hid = hid + "oai_";
        hid = hid + "harvester_";
        hid = hid + this.docbaseId;
        return hid;
    }

    protected void configureAdminEmails(Configuration configuration) throws ConfigurationException {
        ArrayList<String> locAdminEmailsList = new ArrayList<String>();
        String firstAdminEmail = configuration.getAttribute(ATTRIBUTE_NAME_ADMIN_EMAIL, null);
        Configuration[] locAdminEmails = configuration.getChildren(ATTRIBUTE_NAME_ADMIN_EMAIL);
        if (Utilities.checkString(firstAdminEmail)) {
            locAdminEmailsList.add(firstAdminEmail);
        }
        for (int i = 0; i < locAdminEmails.length; ++i) {
            String value;
            Configuration locAdminEmail = locAdminEmails[i];
            if (locAdminEmail == null || !Utilities.checkString(value = locAdminEmail.getValue())) continue;
            locAdminEmailsList.add(value);
        }
        if (locAdminEmailsList.size() <= 0) {
            Utilities.checkConfAttributeValue(ATTRIBUTE_NAME_ADMIN_EMAIL, null, configuration.getLocation());
        }
        this.adminEmails = locAdminEmailsList.toArray(new String[0]);
        locAdminEmailsList.clear();
        locAdminEmailsList = null;
    }

    protected void configureDataProviders(Configuration configuration) throws ConfigurationException {
        Configuration[] repoRequestConfs;
        Configuration dataProvidersConf;
        if (configuration != null && (dataProvidersConf = configuration.getChild(ELEMENT_NAME_OAI_DATA_PROVIDERS, false)) != null && (repoRequestConfs = dataProvidersConf.getChildren("oai-repository")) != null) {
            for (int x = 0; x < repoRequestConfs.length; ++x) {
                Configuration repoRequestConf = repoRequestConfs[x];
                if (repoRequestConf == null) continue;
                if (this.storedRequests == null) {
                    this.storedRequests = new Hashtable();
                }
                String repoUrl = repoRequestConf.getAttribute(ATTRIBUTE_NAME_URL);
                this.configureStoreRepositories(repoUrl, repoRequestConf);
                Configuration updateConf = repoRequestConf.getChild(ATTRIBUTE_NAME_UPDATE, false);
                Configuration[] verbConfs = repoRequestConf.getChildren(ELEMENT_NAME_OAI_VERB);
                if (verbConfs != null) {
                    for (int y = 0; y < verbConfs.length; ++y) {
                        OAIRequestImpl request = null;
                        Configuration verbConf = verbConfs[y];
                        if (verbConf == null) continue;
                        String verb = verbConf.getAttribute(ATTRIBUTE_NAME_NAME);
                        String mdPrefix = verbConf.getAttribute(ATTRIBUTE_NAME_METADATA_PREFIX);
                        Utilities.checkConfAttributeValue(ATTRIBUTE_NAME_METADATA_PREFIX, mdPrefix, verbConf.getLocation());
                        String verbId = verbConf.getAttribute("id");
                        Utilities.checkConfAttributeValue("id", verbId, verbConf.getLocation());
                        if (verb.equalsIgnoreCase("GetRecord")) {
                            verb = "GetRecord";
                            Configuration[] idsConf = verbConf.getChildren(ELEMENT_NAME_OAI_IDENTIFIER);
                            if (idsConf == null) continue;
                            for (int z = 0; z < idsConf.length; ++z) {
                                Configuration idConf = idsConf[z];
                                if (idConf == null) continue;
                                String id = idConf.getValue();
                                request = new OAIRequestImpl();
                                request.enableLogging(this.logger);
                                request.setRepositoryURL(repoUrl);
                                request.setVerbString(verb);
                                request.setMetadataPrefix(mdPrefix);
                                request.setVerbId(verbId);
                                request.setIdentifier(id);
                                this.storedRequests.put(request.getRequestURL(), request);
                                this.configureUpdateTriggers(request.getRequestURL(), updateConf);
                            }
                            continue;
                        }
                        if (verb.equalsIgnoreCase("ListRecords")) {
                            verb = "ListRecords";
                            String from = verbConf.getAttribute(ATTRIBUTE_NAME_FROM, null);
                            boolean useLastHarvestDate = verbConf.getAttributeAsBoolean(ATTRIBUTE_USE_LAST_HARVEST_DATE, true);
                            String until = verbConf.getAttribute(ATTRIBUTE_NAME_UNTIL, null);
                            String set = verbConf.getAttribute(ATTRIBUTE_NAME_SET, null);
                            request = new OAIRequestImpl();
                            request.enableLogging(this.logger);
                            request.setRepositoryURL(repoUrl);
                            request.setVerbString(verb);
                            request.setMetadataPrefix(mdPrefix);
                            request.setVerbId(verbId);
                            request.setFrom(from);
                            request.setUseLastHarvestDate(useLastHarvestDate);
                            request.setUntil(until);
                            request.setSetIdentifier(set);
                            this.storedRequests.put(request.getRequestURL(), request);
                            this.configureUpdateTriggers(request.getRequestURL(), updateConf);
                            continue;
                        }
                        throw new ConfigurationException("this verb action is not supported for harvesting : " + verb);
                    }
                }
                this.configurePipeline(repoRequestConf);
            }
            if (this.scheduler != null) {
                this.scheduler.start();
            }
        }
    }

    protected void configureUpdateTriggers(String requestUrl, Configuration updateConf) throws ConfigurationException {
        TimeTrigger trigger;
        if (Utilities.checkString(requestUrl) && updateConf != null && (trigger = new TimeTriggerFactory().createTimeTrigger(updateConf)) != null) {
            if (this.scheduler == null) {
                this.scheduler = new SimpleTimeScheduler();
            }
            this.scheduler.addTrigger(requestUrl, trigger, this);
        }
    }

    protected void configureStoreRepositories(String repoUrl, Configuration oaiRepoConf) throws ConfigurationException {
        String ref;
        if (Utilities.checkString(repoUrl) && Utilities.checkString(ref = oaiRepoConf.getAttribute(ATTRIBUTE_NAME_SDX_REPOSITORY, null))) {
            Repository repo = null;
            Hashtable appRepos = (Hashtable)this.docBaseProps.get("appRepos");
            if (appRepos != null) {
                repo = (Repository)appRepos.get(ref);
            }
            if (repo == null) {
                try {
                    repo = this.docbase.getRepository(ref);
                }
                catch (SDXException e) {
                    String[] args = new String[]{ref};
                    SDXException sdxE = new SDXException(this.logger, 29, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
            }
            if (this.storeRepositoriesRefs == null) {
                this.storeRepositoriesRefs = new Hashtable();
            }
            this.storeRepositoriesRefs.put(repoUrl, repo);
        }
    }

    protected void configurePipeline(Configuration configuration) throws ConfigurationException {
        Configuration pipeConf = configuration.getChild(this.ELEMENT_NAME_PIPELINE, false);
        if (pipeConf != null) {
            this.pipe = new GenericPipeline();
            this.pipe.enableLogging(this.logger);
            try {
                this.pipe.compose(this.manager);
            }
            catch (ComponentException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            this.pipe.setProperties(this.docBaseProps);
            this.pipe.configure(pipeConf);
        }
    }

    protected File getNewTempDir() throws SDXException, IOException {
        File ret = (File)this.docBaseProps.get("upload-directory");
        String childDir = Utilities.getStringFromHashtable("appPathName", this.docBaseProps) + "_oaiHarvests" + File.separator + this.docbaseId + File.separator + "harvest-" + Utilities.encodeURL(Long.toString(new java.util.Date().getTime()), null);
        if (Utilities.checkString(this.resumptionToken)) {
            childDir = childDir + "-resumptionToken-" + this.resumptionToken;
        }
        ret = ret.canWrite() ? new File(ret, childDir) : new File(Utilities.getSystemTempDir(), childDir);
        Utilities.checkDirectory(ret.getCanonicalPath(), this.logger);
        return ret;
    }

    protected void deleteTempDir() {
        if (this.tempDir != null) {
            try {
                FileUtil.deleteDirectory((File)this.tempDir);
            }
            catch (IOException e) {
                Utilities.logWarn(this.logger, e.getMessage(), e);
            }
        }
    }

    protected void initTempDir() throws SDXException, IOException {
        this.tempDir = this.getNewTempDir();
    }

    protected String getIsoDate() {
        return Date.formatDate(Date.getUtcIso8601Date());
    }

    protected void prepareRecordCapture() throws SAXException {
        try {
            if (this.tempDir == null || !this.tempDir.exists()) {
                this.initTempDir();
            }
            this.harvestDoc = File.createTempFile("oaiHarvestedRecord", this.TEMPFILE_SUFFIX, this.tempDir);
            this.fileOs = new FileOutputStream(this.harvestDoc);
            if (this.filesProperties == null) {
                this.filesProperties = new Hashtable();
            }
            Properties props = new Properties();
            this.filesProperties.put(this.harvestDoc.getName(), props);
            this.currentOaiStatus = null;
            this.currentOaiIdentifier = null;
            this.currentMetadtaUrlIdentifier = null;
            this.currentDatestamp = null;
            this.deleteRecord = false;
            XMLSerializer cBytes = new XMLSerializer();
            cBytes.setOutputStream((OutputStream)this.fileOs);
            OAIEnvelopStripper oaiStripper = new OAIEnvelopStripper();
            oaiStripper.setConsumer((XMLConsumer)cBytes);
            OAIEnvelopStripper newConsumer = null;
            newConsumer = this.firstXmlConsumer != null ? new XMLMulticaster((XMLConsumer)oaiStripper, this.firstXmlConsumer) : oaiStripper;
            super.setSynchronizedConsumer(new SynchronizedXMLConsumerWrapper((XMLConsumer)newConsumer));
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (SDXException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    protected void captureRecord() throws Exception {
        if (this.fileOs != null && this.harvestDoc != null) {
            this.fileOs.flush();
            this.fileOs.close();
            if ("deleted".equalsIgnoreCase(this.currentOaiStatus)) {
                this.resetRecordCaptureFields(true);
            } else {
                Properties oaiProps = (Properties)this.filesProperties.get(this.harvestDoc.getName());
                if (this.currentDatestamp != null) {
                    oaiProps.setProperty("datestamp", this.currentDatestamp);
                } else {
                    oaiProps.setProperty("datestamp", "");
                }
                if (this.currentOaiIdentifier != null) {
                    oaiProps.setProperty("oaiid", this.currentOaiIdentifier);
                } else {
                    oaiProps.setProperty("oaiid", "");
                }
                if (this.currentOaiStatus != null) {
                    oaiProps.setProperty("oaistatus", this.currentOaiStatus);
                } else {
                    oaiProps.setProperty("oaistatus", "");
                }
                this.resetRecordCaptureFields(false);
            }
        }
    }

    protected void resetRecordCaptureFields(boolean deleteDoc) {
        if (this.fileOs != null) {
            try {
                this.fileOs.flush();
                this.fileOs.close();
                this.fileOs = null;
            }
            catch (IOException e) {
                Utilities.logException(this.logger, e);
            }
        }
        if (this.harvestDoc != null) {
            if (deleteDoc) {
                this.harvestDoc.delete();
            }
            this.harvestDoc = null;
        }
        super.setConsumer(this.firstXmlConsumer);
    }

    protected void prepareRecordForDeletion() {
        if (this.deletedDocs == null) {
            this.deletedDocs = new ArrayList();
        }
        if (Utilities.checkString(this.currentOaiIdentifier)) {
            XMLDocument deleteDoc = null;
            try {
                deleteDoc = new XMLDocument(this.currentOaiIdentifier);
            }
            catch (SDXException sDXException) {
                // empty catch block
            }
            if (deleteDoc != null) {
                this.deletedDocs.add(deleteDoc);
            }
        }
    }

    protected boolean storeHarvestedData() throws ProcessingException, IOException, SDXException, SAXException {
        boolean dataHarvested = false;
        if (this.docbase != null) {
            if (this.deletedDocs != null && this.deletedDocs.size() > 0) {
                this.deleteOAIDocuments();
            }
            IndexableDocument[] indexDocs = null;
            if (this.tempDir != null) {
                String[] files = this.tempDir.list();
                this.harvestedDocs = new ArrayList();
                ArrayList<OAIDocument> docs = new ArrayList<OAIDocument>();
                IndexParameters indexParams = this.getIndexParameters();
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    Properties oaiProps = (Properties)this.filesProperties.get(fileName);
                    this.currentDatestamp = oaiProps.getProperty("datestamp");
                    this.currentOaiIdentifier = oaiProps.getProperty("oaiid");
                    this.currentOaiStatus = oaiProps.getProperty("oaistatus");
                    if (this.currentOaiStatus != null && !"deleted".equalsIgnoreCase(this.currentOaiStatus)) {
                        OAIDocument metadataDoc = new OAIDocument();
                        metadataDoc.setDateString(this.currentDatestamp);
                        metadataDoc.setIdentifier(this.currentOaiIdentifier);
                        try {
                            metadataDoc.setContent(new File(this.tempDir, fileName).toURL());
                            if (docs == null) {
                                docs = new ArrayList();
                            }
                            docs.add(metadataDoc);
                            this.harvestedDocs.add(metadataDoc);
                        }
                        catch (MalformedURLException e) {
                            Utilities.logException(this.logger, e);
                        }
                    }
                    int modulusTopLimit = indexParams.getBatchMax() - 1;
                    if (i != files.length - 1 && (i <= 0 || i % modulusTopLimit != 0) || (indexDocs = docs.toArray(new IndexableDocument[0])) == null) continue;
                    Repository repo = null;
                    if (Utilities.checkString(this.repoUrl) && this.storeRepositoriesRefs != null) {
                        repo = (Repository)this.storeRepositoriesRefs.get(this.repoUrl);
                    }
                    this.docbase.index(indexDocs, repo, indexParams, (ContentHandler)((Object)this));
                    dataHarvested = true;
                    docs = null;
                    indexDocs = null;
                }
                this.noDocsHarvested += this.harvestedDocs.size();
            }
        }
        return dataHarvested;
    }

    protected void deleteOAIDocuments() throws IOException, ProcessingException, SDXException, SAXException {
        if (this.deletedDocs != null && this.deletedDocs.size() > 0) {
            SearchLocations slocs = new SearchLocations();
            slocs.enableLogging(this.logger);
            slocs.addIndex(this.docbase.getIndex());
            ComplexQuery cq = new ComplexQuery();
            cq.enableLogging(this.logger);
            cq.setUp(slocs, 0);
            for (int i = 0; i < this.deletedDocs.size(); ++i) {
                XMLDocument doc = (XMLDocument)this.deletedDocs.get(i);
                String sdxoaiid = doc.getId();
                FieldQuery fq = new FieldQuery();
                fq.setUp(slocs, sdxoaiid, "sdxoaiid");
                cq.addComponent(fq);
            }
            cq.prepare();
            Results res = cq.execute();
            if (res != null && res.count() > 0) {
                String[] ids = res.getDocIds();
                Document[] docs = new XMLDocument[ids.length];
                for (int j = 0; j < docs.length; ++j) {
                    docs[j] = new XMLDocument(ids[j]);
                }
                this.docbase.delete(docs, null);
                this.noDocsDeleted += docs.length;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResumptionToken() {
        if (Utilities.checkString(this.resumptionToken) && Utilities.checkString(this.repoUrl)) {
            String verb = "";
            if (this.requestParams != null) {
                verb = this.requestParams.getParameter("verb", "");
            } else if (this.storedRequests.size() > 0) {
                verb = ((OAIRequest)this.storedRequests.get(this.requestUrl)).getVerbString();
            }
            try {
                if (Utilities.checkString(verb)) {
                    this.newRequestUrl = this.repoUrl + "?" + "verb" + "=" + verb + "&" + "resumptionToken" + "=" + this.resumptionToken;
                    this.resetAllFields();
                    try {
                        this.initTempDir();
                    }
                    catch (SDXException e) {
                        Utilities.logException(this.logger, e);
                    }
                    catch (IOException e) {
                        Utilities.logException(this.logger, e);
                    }
                }
            }
            catch (NullPointerException npe) {
                Utilities.logError(this.logger, "Request parameters have been reset or expired..", npe);
            }
            finally {
                super.resetResumptionToken();
            }
        }
    }

    protected void prepareResourceFromUrlIdentifierCapture() {
        if (Utilities.checkString(this.currentMetadtaUrlIdentifier)) {
            try {
                URL resourceUrl = new URL(this.currentMetadtaUrlIdentifier);
                XMLDocument resource = new XMLDocument();
                resource.setId(this.currentMetadtaUrlIdentifier);
                resource.setContent(resourceUrl);
                this.urlResource = resource;
            }
            catch (MalformedURLException e) {
                Utilities.logException(this.logger, e);
            }
            catch (SDXException e) {
                Utilities.logException(this.logger, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureResourceFromUrlIdentifier() {
        if (this.urlResource != null) {
            try {
                IncludeXMLConsumer include;
                block8: {
                    include = new IncludeXMLConsumer((XMLConsumer)this.synchronizedXmlConsumer);
                    this.urlResource.setConsumer((XMLConsumer)include);
                    include.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource", (Attributes)new AttributesImpl());
                    Parser parser = null;
                    try {
                        parser = (Parser)this.manager.lookup(Parser.ROLE);
                        this.urlResource.parse(parser);
                        Object var4_6 = null;
                        if (parser == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        if (parser != null) {
                            this.manager.release((Component)parser);
                        }
                        this.urlResource = null;
                        include.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource");
                        throw throwable;
                    }
                    this.manager.release((Component)parser);
                }
                this.urlResource = null;
                include.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource");
                {
                }
            }
            catch (SAXException e) {
                Utilities.logException(this.logger, e);
            }
            catch (ComponentException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
            }
            catch (SDXException e) {
                Utilities.logException(this.logger, e);
            }
        }
    }

    protected void resetAllFields() {
        this.noDocsDeleted = 0;
        this.noDocsHarvested = 0;
        this.harvestedDocs = null;
        this.deletedDocs = null;
        this.urlResource = null;
        this.resetRecordCaptureFields(false);
        this.deleteTempDir();
        this.tempDir = null;
        super.resetAllFields();
    }

    protected IndexParameters getIndexParameters() {
        IndexParameters params = new IndexParameters();
        params.setSendIndexationEvents(5);
        params.setBatchMax(this.noRecordsPerBatch);
        if (this.pipe != null) {
            params.setPipeline(this.pipe);
        } else if (this.docbase != null) {
            params.setPipeline(this.docbase.getIndexationPipeline());
        }
        params.setPipelineParams(super.getHarvestParameters());
        return params;
    }

    public void sendStoredHarvestingRequests() throws SAXException {
        try {
            if (this.storedRequests != null && this.storedRequests.size() > 0) {
                this.acquire();
                super.acquireSynchronizedXMLConsumer();
                super.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "storedHarvestRequests", "sdx:storedHarvestRequests", null);
                Enumeration requests = this.storedRequests.elements();
                if (requests != null) {
                    while (requests.hasMoreElements()) {
                        OAIRequest request = (OAIRequest)requests.nextElement();
                        if (request == null) continue;
                        request.toSAX((ContentHandler)((Object)this));
                    }
                }
                super.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "storedHarvestRequests", "sdx:storedHarvestRequests");
            }
        }
        catch (InterruptedException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            super.releaseSynchronizedXMLConsumer();
            this.release();
        }
    }

    public synchronized void targetTriggered(String triggerName) {
        OAIRequest request = (OAIRequest)this.storedRequests.get(triggerName);
        if (request != null) {
            boolean useLastHarvestDate = request.getUseLastHarvestDate();
            if (useLastHarvestDate) {
                try {
                    DatabaseEntity dbe = this.database.getEntity(request.getVerbId());
                    if (dbe != null) {
                        String lastHarvestDate = dbe.getProperty(OAI_HARVESTER_LAST_UPDATED);
                        request.setFrom(lastHarvestDate);
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
            }
            String requestUrl = request.getRequestURL();
            this.receiveSynchronizedRequest(requestUrl, triggerName);
        }
    }

    public void startElement(String s, String s1, String s2, Attributes attributes) throws SAXException {
        if (Utilities.checkString(this.identifierName) && attributes != null && this.identifierName.equals(attributes.getValue(ATTRIBUTE_NAME_NAME))) {
            this.captureElemContent = true;
        }
        super.startElement(s, s1, s2, attributes);
    }

    public void endElement(String s, String s1, String s2) throws SAXException {
        if (this.sBuff != null && this.sBuff.length() > 0) {
            String content = this.sBuff.toString();
            if (!"http://www.openarchives.org/OAI/2.0/".equals(s) && "field".equals(s1)) {
                this.currentMetadtaUrlIdentifier = content;
                try {
                    this.prepareResourceFromUrlIdentifierCapture();
                }
                catch (Exception e) {
                    Utilities.logException(this.logger, e);
                }
            }
        }
        super.endElement(s, s1, s2);
    }

    protected boolean shouldHarvestDocument() {
        boolean ret;
        block6: {
            ret = true;
            try {
                OAIRequest request = (OAIRequest)this.storedRequests.get(this.requestUrl);
                if (request != null && request.getVerbId() != null && !request.getVerbId().equals("") && this.database.entityExists(request.getVerbId())) {
                    DatabaseEntity dbe = this.database.getEntity(request.getVerbId());
                    String formattedDate = dbe.getProperty(OAI_HARVESTER_LAST_UPDATED);
                    java.util.Date lastUpdatedDate = Date.parseDate(formattedDate);
                    java.util.Date currentDocumentDate = Date.parseDate(this.currentDatestamp);
                    if (currentDocumentDate.getTime() > lastUpdatedDate.getTime()) {
                        return ret;
                    }
                    break block6;
                }
                if (!Utilities.checkString(this.currentOaiIdentifier)) break block6;
                ComplexQuery cq = new ComplexQuery();
                SearchLocations slocs = new SearchLocations();
                slocs.enableLogging(this.logger);
                slocs.addIndex(this.docbase.getIndex());
                cq.enableLogging(this.logger);
                cq.setUp(slocs, 1);
                FieldQuery fq = new FieldQuery();
                fq.setUp(slocs, this.currentOaiIdentifier, "sdxoaiid");
                cq.addComponent(fq);
                DateIntervalQuery dq = new DateIntervalQuery();
                java.util.Date currentOaiDocumentDate = Date.parseDate(this.currentDatestamp);
                dq.setUp(slocs, "sdxoaidate", currentOaiDocumentDate, null, true);
                cq.addComponent(dq);
                cq.prepare();
                Results res = cq.execute();
                if (res != null && res.count() == 1) {
                    ret = false;
                    break block6;
                }
                if (res != null && res.count() > 1) {
                    OAIUtilities.logError(this.logger, "A problem occured during harvesting: " + res.count() + " documents correspond to the OAI identifier: " + this.currentOaiIdentifier, null);
                    break block6;
                }
                return ret;
            }
            catch (SDXException e) {
                Utilities.logException(this.logger, e);
            }
        }
        return ret;
    }

    protected void saveCriticalFields(boolean dataHarvested) throws SAXException {
        try {
            OAIRequest request = (OAIRequest)this.storedRequests.get(this.requestUrl);
            if (request != null && request.getVerbId() != null && !request.getVerbId().equals("")) {
                String verb;
                Property[] props;
                DatabaseEntity dbe = this.database.getEntity(request.getVerbId());
                if (dbe == null) {
                    dbe = new DatabaseEntity(request.getVerbId());
                }
                if ((props = dbe.getProperties()).length > 0) {
                    for (int i = 0; i < props.length; ++i) {
                        Property prop = props[i];
                        dbe.deleteProperty(props[i].getName());
                    }
                }
                if (Utilities.checkString(this.repoUrl)) {
                    dbe.addProperty("oaiRequestUrl", this.requestUrl);
                }
                if (Utilities.checkString(this.repoUrl)) {
                    dbe.addProperty("oaiRepositoryUrl", this.repoUrl);
                }
                if (this.requestParams != null && Utilities.checkString(verb = this.requestParams.getParameter("verb", null))) {
                    String mdPrefix = this.requestParams.getParameter(ATTRIBUTE_NAME_METADATA_PREFIX, null);
                    if (verb.equals("GetRecord")) {
                        String id;
                        dbe.addProperty(OAI_VERB, verb);
                        if (Utilities.checkString(mdPrefix)) {
                            dbe.addProperty(OAI_METADATA_PREFIX, mdPrefix);
                        }
                        if (Utilities.checkString(id = this.requestParams.getParameter("identifier", null))) {
                            dbe.addProperty(OAI_IDENTIFIER, id);
                        }
                    }
                    if (verb.equals("ListRecords")) {
                        String set;
                        String until;
                        String from;
                        dbe.addProperty(OAI_VERB, verb);
                        if (Utilities.checkString(mdPrefix)) {
                            dbe.addProperty(OAI_METADATA_PREFIX, mdPrefix);
                        }
                        if (Utilities.checkString(from = this.requestParams.getParameter(ATTRIBUTE_NAME_FROM, null))) {
                            dbe.addProperty(OAI_FROM, from);
                        }
                        if (Utilities.checkString(until = this.requestParams.getParameter(ATTRIBUTE_NAME_UNTIL, null))) {
                            dbe.addProperty(OAI_UNTIL, until);
                        }
                        if (Utilities.checkString(set = this.requestParams.getParameter(ATTRIBUTE_NAME_SET, null))) {
                            dbe.addProperty(OAI_SET, set);
                        }
                    }
                }
                dbe.setId(request.getVerbId());
                if (Utilities.checkString(this.responseDate)) {
                    dbe.addProperty(OAI_HARVESTER_LAST_UPDATED, this.responseDate);
                }
                if (Utilities.checkString(this.resumptionToken)) {
                    dbe.addProperty(OAI_HARVESTER_RESUMPTION_TOKEN, this.resumptionToken);
                }
                dbe.addProperty(NO_DOCS_DELETED, Integer.toString(this.noDocsDeleted));
                dbe.addProperty(NO_DOCS_HARVESTED, Integer.toString(this.noDocsHarvested));
                this.database.update(dbe);
                this.database.optimize();
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    protected String generateNewHarvestId() {
        return this.harvesterIdGen.generate();
    }

    public void sendPastHarvestsSummary() throws SAXException {
        try {
            DatabaseEntity[] dbes = this.database.getEntities();
            if (dbes != null && dbes.length > 0) {
                this.acquire();
                this.acquireSynchronizedXMLConsumer();
                super.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "previousHarvests", "sdx:previousHarvests", null);
                for (int i = 0; i < dbes.length; ++i) {
                    Property[] props;
                    DatabaseEntity dbe = dbes[i];
                    AttributesImpl atts = new AttributesImpl();
                    String repoUrl = null;
                    if (dbe != null && (props = dbe.getProperties()) != null) {
                        for (int j = 0; j < props.length; ++j) {
                            String propName;
                            Property prop = props[j];
                            if (prop == null || !Utilities.checkString(propName = prop.getName()) || OAI_HARVEST_ID.equals(propName)) continue;
                            String propVal = prop.getValue();
                            if (propName.equals("oaiRepositoryUrl")) {
                                repoUrl = propVal;
                                continue;
                            }
                            if (!Utilities.checkString(propVal)) continue;
                            atts.addAttribute("", propName, propName, "CDATA", propVal);
                        }
                    }
                    this.sendElement("http://www.openarchives.org/OAI/2.0/", "request", "request", atts, repoUrl);
                }
                super.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "previousHarvests", "sdx:previousHarvests");
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            this.releaseSynchronizedXMLConsumer();
            this.release();
        }
    }

    public java.util.Date lastUpdated() {
        return this.docbase.lastModificationDate();
    }

    public void purgePastHarvestsData() {
        try {
            DatabaseEntity[] dbes = this.database.getEntities();
            for (int i = 0; i < dbes.length; ++i) {
                DatabaseEntity dbe = dbes[i];
                this.database.delete(dbe);
            }
            this.database.optimize();
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
        }
    }

    protected void storeFailedHarvestData(Exception e) {
        try {
            DatabaseEntity dbe = new DatabaseEntity(this.generateNewHarvestId());
            String message = "noMessage";
            if (e != null) {
                message = e.getMessage();
            }
            dbe.addProperty(OAI_FAILED_HARVEST, message);
            dbe.addProperty("oaiRequestUrl", this.requestUrl);
            this.database.update(dbe);
        }
        catch (SDXException e1) {
            Utilities.logException(this.logger, e1);
        }
    }
}

