/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.OAIError;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.LuceneDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.AbstractDocumentBaseOAIRepository;
import fr.gouv.culture.sdx.oai.BasicOAIMetadataFormat;
import fr.gouv.culture.sdx.oai.SDXOAIMetadataFormat;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.FieldsDefinition;
import fr.gouv.culture.sdx.search.lucene.analysis.MetaAnalyzer;
import fr.gouv.culture.sdx.search.lucene.filter.AbstractFilter;
import fr.gouv.culture.sdx.search.lucene.query.DateIntervalQuery;
import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SimpleQuery;
import fr.gouv.culture.sdx.search.lucene.query.Terms;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneDocumentBaseOAIRepository
extends AbstractDocumentBaseOAIRepository {
    protected LuceneIndex luceneSearchIndex = null;
    protected SimpleQuery includeQuery = null;
    protected SimpleQuery excludeQuery = null;
    protected Hashtable setMappings = null;
    protected final String ATTRIBUTE_NAME_SDXFIELD = "sdxField";
    protected final String ELEMENT_NAME_OAI_FORMAT = "oai-format";
    protected final String ELEMENT_NAME_OAI_SUBSET = "oai-subset";
    protected final String ELEMENT_NAME_INCLUDE = "include";
    protected final String ELEMENT_NAME_EXCLUDE = "exclude";
    protected static final String ATTRIBUTE_NAME_INCLUDE_QUERY = "includeQuery";
    protected static final String ATTRIBUTE_NAME_EXCLUDE_QUERY = "excludeQuery";
    public static final String PARAMETER_NAME_INCLUDE_QUERY = "includeQuery";
    public static final String PARAMETER_NAME_EXCLUDE_QUERY = "excludeQuery";

    public LuceneDocumentBaseOAIRepository(LuceneDocumentBase base) {
        if (base != null) {
            this.documentBase = base;
            this.documentBaseId = base.getId();
            this.luceneSearchIndex = (LuceneIndex)base.getIndex();
        }
        this.protocolVersion = "2.0";
        this.granularity = "YYYY-MM-DDThh:mm:ssZ";
        this.deletedRecord = "transient";
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configureSets(configuration);
        this.configureFormats(configuration);
        this.configureSubset(configuration);
    }

    protected void configureSets(Configuration configuration) throws ConfigurationException {
        Configuration setsConf = configuration.getChild("oai-sets", false);
        if (setsConf != null) {
            Configuration[] sets = setsConf.getChildren("oai-set");
            for (int i = 0; i < sets.length; ++i) {
                fr.gouv.culture.sdx.search.lucene.Field sdxField;
                FieldsDefinition fieldsDef;
                MetaAnalyzer ma;
                Configuration set = sets[i];
                if (set == null) continue;
                String sdxFieldName = set.getAttribute("sdxField", "");
                String setName = set.getAttribute("name", null);
                String setSpec = set.getAttribute("spec", sdxFieldName);
                String includeQuery = set.getAttribute("includeQuery", "");
                String excludeQuery = set.getAttribute("excludeQuery", "");
                Utilities.checkConfAttributeValue("sdxField", sdxFieldName, set.getLocation());
                Utilities.checkConfAttributeValue("name", setName, set.getLocation());
                if (this.luceneSearchIndex != null && (ma = this.luceneSearchIndex.getMetaAnalyzer()) != null && (fieldsDef = ma.getFieldsDefinition()) != null && (sdxField = fieldsDef.getField(sdxFieldName)) != null && !sdxField.isInBrief()) {
                    String[] args = new String[]{sdxFieldName};
                    SDXException sdxE = new SDXException(this.logger, 45, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                Parameters setParams = new Parameters();
                if (Utilities.checkString(setName)) {
                    setParams.setParameter("setName", setName);
                }
                if (Utilities.checkString(sdxFieldName)) {
                    setParams.setParameter("sdxFieldName", sdxFieldName);
                }
                if (Utilities.checkString(setSpec)) {
                    setParams.setParameter("setSpec", sdxFieldName);
                }
                if (Utilities.checkString(includeQuery)) {
                    try {
                        this.getLuceneSimpleQuery(includeQuery);
                        setParams.setParameter("includeQuery", includeQuery);
                    }
                    catch (SDXException e) {
                        throw new ConfigurationException(e.getMessage(), (Throwable)e);
                    }
                }
                if (Utilities.checkString(excludeQuery)) {
                    try {
                        this.getLuceneSimpleQuery(excludeQuery);
                        setParams.setParameter("excludeQuery", excludeQuery);
                    }
                    catch (SDXException e) {
                        throw new ConfigurationException(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.setMappings == null) {
                    this.setMappings = new Hashtable();
                }
                this.setMappings.put(setSpec, setParams);
            }
        }
    }

    protected void configureFormats(Configuration configuration) throws ConfigurationException {
        Configuration[] formats = configuration.getChildren("oai-format");
        if (formats.length > 0) {
            this.metadataFormats = new Hashtable();
        }
        for (int i = 0; i < formats.length; ++i) {
            BasicOAIMetadataFormat format = null;
            String formatPrefix = formats[i].getAttribute("metadataPrefix");
            format = formatPrefix.equalsIgnoreCase("sdx") ? new SDXOAIMetadataFormat() : new BasicOAIMetadataFormat();
            try {
                format.enableLogging(this.logger);
                format.compose(this.manager);
                format.setProperties(this.documentBaseProps);
                format.configure(formats[i]);
                formatPrefix = format.getPrefix();
                if (!Utilities.checkString(formatPrefix)) continue;
                this.metadataFormats.put(formatPrefix, format);
                continue;
            }
            catch (ComponentException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        if (!this.metadataFormats.containsKey("oai_dc")) {
            String[] args = new String[]{this.documentBaseId};
            SDXException sdxE = new SDXException(this.logger, 44, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
    }

    protected void configureSubset(Configuration configuration) throws ConfigurationException {
        Configuration oaiSubset = configuration.getChild("oai-subset", false);
        if (oaiSubset != null) {
            String excludeQueryString;
            String includeQueryString;
            SearchLocations sLocs = this.getSearchLocation();
            Configuration include = oaiSubset.getChild("include", false);
            Configuration exclude = oaiSubset.getChild("exclude", false);
            if (include != null && exclude == null && Utilities.checkString(includeQueryString = include.getAttribute("query"))) {
                this.includeQuery = new SimpleQuery();
                this.includeQuery.enableLogging(this.logger);
                try {
                    this.includeQuery.setUp(sLocs, null, includeQueryString);
                }
                catch (SDXException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (exclude != null && include == null && Utilities.checkString(excludeQueryString = exclude.getAttribute("query"))) {
                this.excludeQuery = new SimpleQuery();
                this.excludeQuery.enableLogging(this.logger);
                try {
                    this.excludeQuery.setUp(sLocs, null, excludeQueryString);
                }
                catch (SDXException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (exclude != null && include != null) {
                String includeQueryString2;
                excludeQueryString = exclude.getAttribute("query");
                if (Utilities.checkString(excludeQueryString)) {
                    this.excludeQuery = new SimpleQuery();
                    this.excludeQuery.enableLogging(this.logger);
                    try {
                        this.excludeQuery.setUp(sLocs, null, excludeQueryString);
                    }
                    catch (SDXException e) {
                        throw new ConfigurationException(e.getMessage(), (Throwable)e);
                    }
                }
                if (Utilities.checkString(includeQueryString2 = include.getAttribute("query"))) {
                    this.includeQuery = new SimpleQuery();
                    this.includeQuery.enableLogging(this.logger);
                    try {
                        this.includeQuery.setUp(sLocs, null, includeQueryString2);
                    }
                    catch (SDXException e) {
                        throw new ConfigurationException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void listSets(OAIRequest request) throws SAXException {
        if (this.setMappings == null || this.setMappings.size() == 0) {
            super.sendNoSetHierarchyError();
        } else if (Utilities.checkString(request.getResumptionToken())) {
            new OAIError(1, "This repository does not support resumptionTokens for ListSets requests").toSAX((ContentHandler)((Object)this));
        } else {
            super.startVerbEvent(request);
            Enumeration sets = this.setMappings.keys();
            if (sets != null) {
                while (sets.hasMoreElements()) {
                    TreeMap termsMap;
                    String setSpec = (String)sets.nextElement();
                    if (!Utilities.checkString(setSpec)) continue;
                    Parameters setParams = (Parameters)this.setMappings.get(setSpec);
                    String setName = "";
                    String sdxFieldName = "";
                    if (setParams != null) {
                        setName = setParams.getParameter("setName", "");
                        sdxFieldName = setParams.getParameter("sdxFieldName", "");
                    }
                    Terms terms = new Terms();
                    if (Utilities.checkString(sdxFieldName)) {
                        terms.enableLogging(this.logger);
                        try {
                            terms.setUp(this.getSearchLocation(), sdxFieldName, "*");
                        }
                        catch (SDXException e) {
                            Utilities.logException(this.logger, e);
                        }
                    }
                    if ((termsMap = terms.getList()) != null && termsMap.size() > 0) {
                        Iterator termsItr = termsMap.keySet().iterator();
                        while (termsItr.hasNext()) {
                            String key;
                            setSpec = key = (String)termsItr.next();
                            super.startElement("http://www.openarchives.org/OAI/2.0/", "set", "set", null);
                            if (Utilities.checkString(setName)) {
                                super.sendElement("http://www.openarchives.org/OAI/2.0/", "setName", "setName", null, setName);
                            }
                            if (Utilities.checkString(setSpec)) {
                                super.sendElement("http://www.openarchives.org/OAI/2.0/", "setSpec", "setSpec", null, setSpec);
                            }
                            super.endElement("http://www.openarchives.org/OAI/2.0/", "set", "set");
                        }
                        continue;
                    }
                    super.startElement("http://www.openarchives.org/OAI/2.0/", "set", "set", null);
                    if (Utilities.checkString(setName)) {
                        super.sendElement("http://www.openarchives.org/OAI/2.0/", "setName", "setName", null, setName);
                    }
                    if (Utilities.checkString(setSpec)) {
                        super.sendElement("http://www.openarchives.org/OAI/2.0/", "setSpec", "setSpec", null, setSpec);
                    }
                    super.endElement("http://www.openarchives.org/OAI/2.0/", "set", "set");
                }
            }
            super.endVerbEvent(request);
        }
    }

    public void getRecord(OAIRequest request) throws SAXException {
        String mdPrefix = request.getMetadataPrefix();
        if (!Utilities.checkString(mdPrefix) || !this.metadataFormats.containsKey(mdPrefix)) {
            return;
        }
        String id = request.getIdentifier();
        Hits hits = this.executeIdQuery(request);
        if (hits == null || hits.length() == 0) {
            new OAIError(4, "The value of the identifier argument, " + id + ", is unknown or illegal in this repository.").toSAX((ContentHandler)((Object)this));
            return;
        }
        if (hits.length() == 1) {
            try {
                ArrayList availableFormats = this.verifyMetadataFormatForRecord(hits.doc(0), mdPrefix);
                if (availableFormats != null && !availableFormats.contains(this.metadataFormats.get(mdPrefix))) {
                    new OAIError(3, "The value of the metadataPrefix argument, " + mdPrefix + ", is not supported by the item identified by the value of the identifier argument, " + id + " .").toSAX((ContentHandler)((Object)this));
                } else {
                    super.startVerbEvent(request);
                    this.sendRecord(request, hits.doc(0), mdPrefix);
                    super.endVerbEvent(request);
                }
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    public void listRecords(OAIRequest request) throws SAXException {
        this.listIdentifiersOrRecords(request);
    }

    public void listIdentifiers(OAIRequest request) throws SAXException {
        this.listIdentifiersOrRecords(request);
    }

    protected void listIdentifiersOrRecords(OAIRequest request) throws SAXException {
        int verb = request.getVerb();
        String mdPrefix = request.getMetadataPrefix();
        String resumptionToken = request.getResumptionToken();
        String newResumptionToken = "";
        int currentBatch = 0;
        int cursor = -1;
        Hits hits = null;
        if (Utilities.checkString(resumptionToken)) {
            if (!this.database.entityExists(resumptionToken)) {
                new OAIError(1, "The value of the resumptionToken argument is invalid or expired.").toSAX((ContentHandler)((Object)this));
            } else {
                mdPrefix = this.getResumptionTokenProperty(resumptionToken, "metadataPrefix");
                cursor = Integer.parseInt(this.getResumptionTokenCursor(resumptionToken));
                currentBatch = cursor / this.numRecordsPerResponse + 1;
                try {
                    hits = (Hits)this.context.get((Object)this.getResumptionTokenProperty(resumptionToken, "resultsId"));
                }
                catch (ContextException e) {
                    Utilities.logException(this.logger, (Exception)((Object)e));
                    new OAIError(1, "The value of the resumptionToken argument is invalid or expired.").toSAX((ContentHandler)((Object)this));
                    this.resetInternalObjects(resumptionToken, newResumptionToken);
                }
            }
        } else {
            if (!Utilities.checkString(mdPrefix)) {
                new OAIError(6, "The request does not contain any metadataPrefix").toSAX((ContentHandler)((Object)this));
                this.resetInternalObjects(resumptionToken, newResumptionToken);
                return;
            }
            if (!this.metadataFormats.containsKey(mdPrefix)) {
                new OAIError(6, "The metadataPrefix is not available: \"" + mdPrefix + "\"").toSAX((ContentHandler)((Object)this));
                this.resetInternalObjects(resumptionToken, newResumptionToken);
                return;
            }
            try {
                hits = this.executeQueryForRequestParams(request);
            }
            catch (SDXException e) {
                Utilities.logException(this.logger, e);
                this.resetInternalObjects(resumptionToken, newResumptionToken);
            }
        }
        if (hits == null || hits.length() == 0) {
            new OAIError(5, "The combination of the values of the from \"" + request.getFrom() + "\", until \"" + request.getUntil() + "\", set \"" + request.getSetIdentifier() + "\", and metadataPrefix \"" + mdPrefix + "\" arguments results in an empty list.").toSAX((ContentHandler)((Object)this));
            if (Utilities.checkString(resumptionToken) | Utilities.checkString(newResumptionToken)) {
                this.resetInternalObjects(resumptionToken, newResumptionToken);
            }
            return;
        }
        boolean startVerbEventSent = false;
        int resultsLength = hits.length();
        int end = resultsLength - 1;
        int start = currentBatch * this.numRecordsPerResponse;
        int endBatch = start + (this.numRecordsPerResponse - 1);
        for (int i = start; i < resultsLength && i <= endBatch; ++i) {
            try {
                ArrayList avaliableFormats;
                Document hitDoc = hits.doc(i);
                if (i == endBatch && i != end) {
                    if (newResumptionToken == null || newResumptionToken.equals("")) {
                        try {
                            newResumptionToken = this.createResumptionToken(request);
                        }
                        catch (SDXException e) {
                            Utilities.logException(this.logger, e);
                            this.resetInternalObjects(resumptionToken, newResumptionToken);
                        }
                    }
                    this.context.put((Object)(newResumptionToken + "_results"), (Object)hits);
                }
                if (i == end && Utilities.checkString(resumptionToken)) {
                    this.resetInternalObjects(resumptionToken, newResumptionToken);
                }
                if ((avaliableFormats = this.verifyMetadataFormatForRecord(hitDoc, mdPrefix)) == null || !avaliableFormats.contains(this.metadataFormats.get(mdPrefix))) continue;
                if (!startVerbEventSent) {
                    super.startVerbEvent(request);
                    startVerbEventSent = true;
                }
                switch (verb) {
                    case 3: {
                        this.sendIdentifier(request, hitDoc);
                        break;
                    }
                    case 4: {
                        this.sendRecord(request, hitDoc, mdPrefix);
                        break;
                    }
                    default: {
                        String verbString = request.getVerbString();
                        String errorString = "The verb";
                        if (OAIUtilities.checkString(verbString)) {
                            errorString = errorString + ", " + verbString + ",";
                        }
                        errorString = errorString + " is unknown or a value was not provided.";
                        new OAIError(2, errorString).toSAX((ContentHandler)((Object)this));
                    }
                }
                continue;
            }
            catch (IOException e) {
                Utilities.logException(this.logger, e);
            }
        }
        if (startVerbEventSent) {
            if (OAIUtilities.checkString(newResumptionToken)) {
                super.sendResumptionToken(newResumptionToken, this.getResumptionTokenCursor(newResumptionToken), new String("" + resultsLength));
            } else if (OAIUtilities.checkString(resumptionToken)) {
                super.sendResumptionToken(null, new String("" + resultsLength), new String("" + resultsLength));
            }
        } else {
            new OAIError(5, "The combination of the values of the from \"" + request.getFrom() + "\", until \"" + request.getUntil() + "\", set \"" + request.getSetIdentifier() + "\", and metadataPrefix \"" + mdPrefix + "\" arguments results in an empty list.").toSAX((ContentHandler)((Object)this));
            this.resetInternalObjects(resumptionToken, newResumptionToken);
            return;
        }
        super.endVerbEvent(request);
    }

    protected void resetInternalObjects(String resumptionToken, String newResumptionToken) {
        String currentRt = resumptionToken;
        if (currentRt == null || currentRt.equals("")) {
            currentRt = newResumptionToken;
        }
        if (currentRt != null && !currentRt.equals("")) {
            try {
                String resultsId = this.getResumptionTokenProperty(currentRt, "resultsId");
                if (resultsId != null) {
                    this.context.put((Object)resultsId, null);
                }
                this.database.delete(new DatabaseEntity(currentRt));
                this.database.optimize();
                newResumptionToken = null;
            }
            catch (SDXException e) {
                Utilities.logException(this.logger, e);
            }
        }
    }

    public void listMetadataFormats(OAIRequest request) throws SAXException {
        if (request != null) {
            String id = request.getIdentifier();
            if (!Utilities.checkString(id)) {
                Enumeration mdformats = this.metadataFormats.elements();
                if (mdformats != null) {
                    super.startVerbEvent(request);
                    while (mdformats.hasMoreElements()) {
                        BasicOAIMetadataFormat mdformat = (BasicOAIMetadataFormat)mdformats.nextElement();
                        if (mdformat == null) continue;
                        mdformat.toSAX((ContentHandler)((Object)this));
                    }
                    super.endVerbEvent(request);
                }
            } else {
                Hits hits = this.executeIdQuery(request);
                if (hits == null || hits.length() == 0) {
                    new OAIError(4, "The value of the identifier argument, " + id + ", is unknown or illegal in this repository.").toSAX((ContentHandler)((Object)this));
                    return;
                }
                if (hits.length() == 1) {
                    try {
                        ArrayList availableFormats = this.verifyMetadataFormatForRecord(hits.doc(0));
                        if (availableFormats == null || availableFormats.size() <= 0) {
                            new OAIError(3, "There are no metadata formats available for the specified item, " + id + " .").toSAX((ContentHandler)((Object)this));
                        } else {
                            super.startVerbEvent(request);
                            for (int i = 0; i < availableFormats.size(); ++i) {
                                BasicOAIMetadataFormat mdFormat = (BasicOAIMetadataFormat)availableFormats.get(i);
                                if (mdFormat == null) continue;
                                mdFormat.toSAX((ContentHandler)((Object)this));
                            }
                            super.endVerbEvent(request);
                        }
                    }
                    catch (IOException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected ArrayList verifyMetadataFormatForRecord(Document document) {
        return this.verifyMetadataFormatForRecord(document, null);
    }

    protected ArrayList verifyMetadataFormatForRecord(Document document, String mdPrefix) {
        ArrayList<BasicOAIMetadataFormat> availableFormats = null;
        if (document != null) {
            Enumeration<Object> formatsToCheck = null;
            if (Utilities.checkString(mdPrefix)) {
                BasicOAIMetadataFormat metadataFormat = (BasicOAIMetadataFormat)this.metadataFormats.get(mdPrefix);
                Vector<BasicOAIMetadataFormat> format = new Vector<BasicOAIMetadataFormat>();
                format.add(metadataFormat);
                formatsToCheck = format.elements();
            } else {
                formatsToCheck = this.metadataFormats.elements();
            }
            if (formatsToCheck != null) {
                availableFormats = new ArrayList<BasicOAIMetadataFormat>();
                while (formatsToCheck.hasMoreElements()) {
                    String[] sdxFieldNames;
                    BasicOAIMetadataFormat formatToCheck = (BasicOAIMetadataFormat)formatsToCheck.nextElement();
                    if (formatToCheck == null) continue;
                    if ("sdx".equalsIgnoreCase(formatToCheck.getPrefix())) {
                        availableFormats.add(formatToCheck);
                        continue;
                    }
                    Pipeline pipe = formatToCheck.getPipeline();
                    Parameters mappings = formatToCheck.getMappings();
                    boolean metadataFormatHasMappings = true;
                    if (mappings == null || mappings.getNames() == null && mappings.getNames().length == 0) {
                        metadataFormatHasMappings = false;
                    }
                    if (pipe != null) {
                        availableFormats.add(formatToCheck);
                        continue;
                    }
                    if (!metadataFormatHasMappings || (sdxFieldNames = mappings.getNames()) == null) continue;
                    for (int i = 0; i < sdxFieldNames.length; ++i) {
                        String sdxFieldName = sdxFieldNames[i];
                        if (!Utilities.checkString(sdxFieldName) || sdxFieldName.equals("sdxdocid") || document.getField(sdxFieldName) == null && document.getField("sdxOaiDeletedRecord") == null) continue;
                        availableFormats.add(formatToCheck);
                    }
                }
            }
        }
        return availableFormats;
    }

    protected SearchLocations getSearchLocation() {
        SearchLocations sLocs = new SearchLocations();
        sLocs.enableLogging(this.logger);
        sLocs.setUp(this.luceneSearchIndex);
        return sLocs;
    }

    protected BooleanQuery getBaseQuery() {
        BooleanQuery bq = new BooleanQuery();
        if (this.includeQuery != null) {
            bq.add(this.includeQuery.getLuceneQuery(), true, false);
        }
        if (this.excludeQuery != null) {
            bq.add(this.excludeQuery.getLuceneQuery(), false, true);
        }
        bq.add((Query)new WildcardQuery(new Term("sdxOaiDeletedRecord", "*")), false, false);
        return bq;
    }

    protected BooleanQuery getBaseQueryForResults() {
        BooleanQuery bq = new BooleanQuery();
        WildcardQuery oaiDeleted = new WildcardQuery(new Term("sdxOaiDeletedRecord", "*"));
        TermQuery query = new TermQuery(new Term("sdxall", "1"));
        if (this.includeQuery == null && this.excludeQuery == null) {
            bq.add((Query)query, false, false);
            bq.add((Query)oaiDeleted, false, false);
        } else if (this.includeQuery != null && this.excludeQuery == null) {
            BooleanQuery bq2 = new BooleanQuery();
            bq2.add(this.includeQuery.getLuceneQuery(), true, false);
            bq.add((Query)bq2, false, false);
            bq.add((Query)oaiDeleted, false, false);
        } else if (this.excludeQuery != null && this.includeQuery == null) {
            BooleanQuery bq2 = new BooleanQuery();
            bq2.add((Query)query, true, false);
            bq2.add(this.excludeQuery.getLuceneQuery(), true, true);
            bq.add((Query)bq2, false, false);
            bq.add((Query)oaiDeleted, false, false);
        } else if (this.excludeQuery != null && this.includeQuery != null) {
            BooleanQuery bq2 = new BooleanQuery();
            bq2.add(this.includeQuery.getLuceneQuery(), true, false);
            bq2.add(this.excludeQuery.getLuceneQuery(), true, true);
            bq.add((Query)bq2, false, false);
            bq.add((Query)oaiDeleted, false, false);
        }
        return bq;
    }

    protected TermQuery getIdQuery(String id) {
        TermQuery tq = null;
        if (Utilities.checkString(id)) {
            tq = new TermQuery(new Term("sdxdocid", id));
        }
        return tq;
    }

    protected Hits executeIdQuery(OAIRequest request) throws SAXException {
        String id = request.getIdentifier();
        String internalId = this.deriveInternalSdxId(request, id);
        Hits hits = null;
        if (Utilities.checkString(internalId)) {
            try {
                BooleanQuery bq = this.getBaseQueryForResults();
                TermQuery idQuery = this.getIdQuery(internalId);
                bq.add((Query)idQuery, true, false);
                if (this.luceneSearchIndex != null) {
                    hits = this.luceneSearchIndex.search((Query)bq);
                }
            }
            catch (SDXException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
        return hits;
    }

    protected void sendRecord(OAIRequest request, Document doc, String mdPrefix) throws SAXException {
        BasicOAIMetadataFormat metadataFormat = (BasicOAIMetadataFormat)this.metadataFormats.get(mdPrefix);
        String formatPrefix = metadataFormat.getPrefix();
        boolean isSDXFormat = formatPrefix.equalsIgnoreCase("sdx");
        if (doc != null) {
            if (doc.getField("sdxdocid") == null || doc.getField("sdxOaiDeletedRecord") != null) {
                super.startElement("http://www.openarchives.org/OAI/2.0/", "record", "record", null);
                this.sendHeaderEvents(request, doc);
                super.endElement("http://www.openarchives.org/OAI/2.0/", "record", "record");
            } else if (metadataFormat != null) {
                super.startElement("http://www.openarchives.org/OAI/2.0/", "record", "record", null);
                this.sendHeaderEvents(request, doc);
                Enumeration fields = doc.fields();
                Pipeline pipe = null;
                boolean metadataFormatHasMappings = true;
                if (fields != null) {
                    boolean startEventsSent = false;
                    while (fields.hasMoreElements()) {
                        Field field;
                        if (metadataFormat.getMappings() == null || metadataFormat.getMappings().getNames() == null && metadataFormat.getMappings().getNames().length == 0) {
                            metadataFormatHasMappings = false;
                        }
                        if ((pipe = metadataFormat.getPipeline()) != null) {
                            Pipeline addRootAttPipe = metadataFormat.getAddRootAttributePipe();
                            if (addRootAttPipe != null) {
                                addRootAttPipe.setConsumer((XMLConsumer)new IncludeXMLConsumer((XMLConsumer)this));
                            }
                            pipe.setConsumer((XMLConsumer)addRootAttPipe);
                        }
                        if (!startEventsSent) {
                            super.startElement("http://www.openarchives.org/OAI/2.0/", "metadata", "metadata", null);
                            metadataFormat.setConsumer((XMLConsumer)this);
                            if (metadataFormatHasMappings || isSDXFormat) {
                                metadataFormat.startMetadataFormatRootElement();
                            }
                            startEventsSent = true;
                        }
                        if ((field = (Field)fields.nextElement()) == null) continue;
                        String origName = field.name();
                        String val = field.stringValue();
                        if (!Utilities.checkString(origName)) continue;
                        try {
                            String newVal = val;
                            if (origName.equals("sdxdocid")) {
                                if (pipe != null && !metadataFormatHasMappings) {
                                    XMLDocument xdoc = new XMLDocument();
                                    xdoc.enableLogging(this.logger);
                                    xdoc.setId(val);
                                    this.documentBase.getDocument(xdoc, (XMLConsumer)pipe, false);
                                    continue;
                                }
                                if (isSDXFormat) {
                                    metadataFormat.sendElement(origName, newVal);
                                    continue;
                                }
                                newVal = this.buildUrlLocator(request, val);
                                metadataFormat.sendElement(origName, newVal);
                                continue;
                            }
                            metadataFormat.sendElement(origName, newVal);
                        }
                        catch (SDXException e) {
                            Utilities.logException(this.logger, e);
                        }
                    }
                    if (startEventsSent) {
                        if (metadataFormatHasMappings || isSDXFormat) {
                            metadataFormat.endMetadataFormatRootElement();
                        }
                        super.endElement("http://www.openarchives.org/OAI/2.0/", "metadata", "metadata");
                    }
                }
                super.endElement("http://www.openarchives.org/OAI/2.0/", "record", "record");
            }
        }
    }

    protected void sendIdentifier(OAIRequest request, Document doc) throws SAXException {
        if (doc != null) {
            this.sendHeaderEvents(request, doc);
        }
    }

    protected void sendHeaderEvents(OAIRequest request, Document doc) throws SAXException {
        Enumeration sets;
        String deletedId;
        String id = doc.get("sdxdocid");
        String externalId = "";
        String status = null;
        if (!Utilities.checkString(id) && Utilities.checkString(deletedId = doc.get("sdxOaiDeletedRecord"))) {
            status = "deleted";
            id = deletedId;
        }
        externalId = this.buildExternalOaiId(request, id);
        String datestamp = doc.get("sdxmoddate");
        AttributesImpl atts = new AttributesImpl();
        if (Utilities.checkString(status)) {
            atts.addAttribute("", "status", "status", "CDATA", status);
        }
        super.startElement("http://www.openarchives.org/OAI/2.0/", "header", "header", atts);
        datestamp = Date.formatUtcISO8601Date(DateField.stringToDate(datestamp));
        super.sendElement("http://www.openarchives.org/OAI/2.0/", "identifier", "identifier", null, externalId);
        super.sendElement("http://www.openarchives.org/OAI/2.0/", "datestamp", "datestamp", null, datestamp);
        if (this.setMappings != null && (sets = this.setMappings.keys()) != null) {
            while (sets.hasMoreElements()) {
                String setSpec;
                Parameters setParams = this.getDocumentSetParameters(doc);
                if (setParams == null || !Utilities.checkString(setSpec = setParams.getParameter("setSpec", ""))) continue;
                String encoding = Utilities.getStringFromHashtable("encoding", this.documentBaseProps);
                setSpec = Utilities.encodeURL(setSpec, encoding);
                super.sendElement("http://www.openarchives.org/OAI/2.0/", "setSpec", "setSpec", null, setSpec);
            }
        }
        super.endElement("http://www.openarchives.org/OAI/2.0/", "header", "header");
    }

    public void addDeletedRecord(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return;
        }
        String docId = id;
        Document deletedRecord = new Document();
        Hits hits = null;
        BooleanQuery bq = this.getBaseQuery();
        bq.add((Query)this.getIdQuery(docId), true, false);
        hits = this.luceneSearchIndex.search((Query)bq);
        try {
            if (hits != null && hits.length() == 1 && docId.equals(hits.doc(0).get("sdxdocid"))) {
                deletedRecord.add(Field.Keyword((String)"sdxOaiDeletedRecord", (String)id));
                java.util.Date date = Date.getUtcIso8601Date();
                deletedRecord.add(Field.Keyword((String)"sdxmoddate", (String)DateField.dateToString(date)));
                this.luceneSearchIndex.writeDocument(deletedRecord, false);
            }
        }
        catch (IOException e) {
            Utilities.logException(this.logger, e);
        }
    }

    public void removeDeletedRecord(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return;
        }
        Term term = new Term("sdxOaiDeletedRecord", id);
        this.luceneSearchIndex.delete(term);
    }

    protected BooleanQuery addSetQuery(String setSpec) {
        Parameters setParams;
        BooleanQuery bq = new BooleanQuery();
        if (this.setMappings != null && Utilities.checkString(setSpec) && (setParams = (Parameters)this.setMappings.get(setSpec)) != null) {
            String sdxFieldName = setParams.getParameter("sdxFieldName", "");
            String includeQuery = setParams.getParameter("includeQuery", "");
            String excludeQuery = setParams.getParameter("excludeQuery", "");
            if (Utilities.checkString(includeQuery) || Utilities.checkString(excludeQuery)) {
                try {
                    Query inQuery = this.getLuceneSimpleQuery(includeQuery);
                    if (inQuery != null) {
                        bq.add(inQuery, true, false);
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
                try {
                    Query exQuery = this.getLuceneSimpleQuery(excludeQuery);
                    if (exQuery != null) {
                        bq.add(exQuery, false, true);
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
            } else if (Utilities.checkString(sdxFieldName)) {
                bq.add((Query)new WildcardQuery(new Term(sdxFieldName, setSpec)), true, false);
            }
        }
        return bq;
    }

    protected Query getLuceneSimpleQuery(String query) throws SDXException {
        Query ret = null;
        if (Utilities.checkString(query)) {
            SearchLocations sLocs = this.getSearchLocation();
            SimpleQuery sQuery = new SimpleQuery();
            sQuery.enableLogging(this.logger);
            sQuery.setUp(sLocs, null, query);
            ret = sQuery.getLuceneQuery();
        }
        return ret;
    }

    protected Parameters getDocumentSetParameters(Document doc) {
        Parameters ret = null;
        String docId = doc.get("sdxdocid");
        Enumeration setSpecs = this.setMappings.keys();
        if (setSpecs != null) {
            block7: while (setSpecs.hasMoreElements()) {
                Field field;
                String setSpec = (String)setSpecs.nextElement();
                Parameters setParams = (Parameters)this.setMappings.get(setSpec);
                String sdxFieldName = setParams.getParameter("sdxFieldName", "");
                if (Utilities.checkString(sdxFieldName) && (field = doc.getField(sdxFieldName)) != null) {
                    String fieldValue = field.stringValue();
                    if (Utilities.checkString(setSpec) && setSpec.equals(sdxFieldName) || setSpec.equals(fieldValue)) {
                        ret = setParams;
                        break;
                    }
                }
                BooleanQuery bq = this.getBaseQueryForResults();
                String includeQuery = setParams.getParameter("includeQuery", "");
                String excludeQuery = setParams.getParameter("excludeQuery", "");
                if (!Utilities.checkString(includeQuery) && !Utilities.checkString(excludeQuery)) continue;
                try {
                    Query inQuery = this.getLuceneSimpleQuery(includeQuery);
                    if (inQuery != null) {
                        bq.add(inQuery, true, false);
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
                try {
                    Query exQuery = this.getLuceneSimpleQuery(excludeQuery);
                    if (exQuery != null) {
                        bq.add(exQuery, false, true);
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
                if (this.luceneSearchIndex == null) continue;
                try {
                    Hits hits = this.luceneSearchIndex.search((Query)bq);
                    if (hits == null || hits.length() <= 0) continue;
                    for (int i = 0; i < hits.length(); ++i) {
                        Document hitDoc = hits.doc(i);
                        String id = hitDoc.get("sdxdocid");
                        if (!Utilities.checkString(id) || !Utilities.checkString(docId) || !id.equals(docId)) continue;
                        ret = setParams;
                        continue block7;
                    }
                }
                catch (SDXException e) {
                    Utilities.logException(this.logger, e);
                }
                catch (IOException e) {
                    Utilities.logException(this.logger, e);
                }
            }
        }
        return ret;
    }

    protected Hits executeQueryForRequestParams(OAIRequest request) throws SDXException, SAXException {
        String set = "";
        String resumptionToken = "";
        String from = "";
        String until = "";
        if (request != null) {
            set = request.getSetIdentifier();
            resumptionToken = request.getResumptionToken();
            from = request.getFrom();
            until = request.getUntil();
        }
        BooleanQuery bq = this.getBaseQueryForResults();
        AbstractFilter rangeFilter = null;
        java.util.Date fromDate = null;
        java.util.Date untilDate = null;
        if (Utilities.checkString(set) && (this.setMappings == null || this.setMappings.size() == 0)) {
            super.sendNoSetHierarchyError();
            return null;
        }
        if (fromDate == null) {
            fromDate = Date.parseUtcISO8601Date(from);
        }
        if (fromDate == null && Utilities.checkString(from)) {
            new OAIError(8, "The value of the \"from\" argument, " + from + ", is invalid.").toSAX((ContentHandler)((Object)this));
            return null;
        }
        untilDate = Date.parseUtcISO8601Date(until);
        if (untilDate == null && Utilities.checkString(until)) {
            new OAIError(8, "The value of the \"until\" argument, " + until + ", is invalid.").toSAX((ContentHandler)((Object)this));
            return null;
        }
        if (fromDate != null || untilDate != null) {
            if (fromDate != null && untilDate != null && fromDate.getTime() > untilDate.getTime()) {
                new OAIError(0, "The value of the \"from\" argument, " + from + ", must be less than or equal to the value of the \"until\" argument," + until + " .").toSAX((ContentHandler)((Object)this));
                return null;
            }
            DateIntervalQuery dateQuery = new DateIntervalQuery();
            dateQuery.enableLogging(this.logger);
            dateQuery.setUpOai(this.getSearchLocation(), "sdxmoddate", fromDate, untilDate);
            rangeFilter = dateQuery.prepare();
        }
        bq.add((Query)this.addSetQuery(set), false, false);
        Hits hits = null;
        if (this.luceneSearchIndex != null) {
            hits = this.luceneSearchIndex.search((Query)bq, rangeFilter);
        }
        return hits;
    }

    public String getEarliestDatestamp() {
        if (!Utilities.checkString(this.earliestDatestamp)) {
            java.util.Date utcDate = Date.getUtcIso8601Date(this.documentBase.creationDate());
            this.earliestDatestamp = Date.formatUtcISO8601Date(utcDate);
        }
        return this.earliestDatestamp;
    }

    public void purgeDeletedRecords() {
        try {
            LuceneIndex luceneSearchIndex = this.luceneSearchIndex;
            luceneSearchIndex.delete(new Term("sdxOaiDeletedRecord", "*"));
            luceneSearchIndex.optimize();
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
        }
    }
}

