/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementCountTransformation
extends AbstractTransformation {
    int noKeys = -1;
    String boundsElem = null;
    boolean withinBoundsElem = false;
    Hashtable counter = new Hashtable();
    StringBuffer content = null;
    String collectKey = "";

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.noKeys = this.transParameters.getNames().length;
        if (this.noKeys > 0) {
            try {
                this.boundsElem = this.transParameters.getParameter("boundsElem");
            }
            catch (ParameterException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void count(String uri, String loc, String raw, Attributes atts) {
        for (int i = 0; i < this.noKeys; ++i) {
            String attCountKey;
            String intString = Integer.toString(i);
            String elemParamKey = "elemName" + intString;
            String elemName = this.transParameters.getParameter(elemParamKey, null);
            String attParamKey = "attName" + intString;
            String attName = this.transParameters.getParameter(attParamKey, null);
            String attValParamKey = "attValue" + intString;
            String attValue = this.transParameters.getParameter(attValParamKey, null);
            if (Utilities.checkString(elemName)) {
                String elemCountKey = null;
                if (elemName.equals(loc)) {
                    elemCountKey = loc;
                } else if (elemName.equals(raw)) {
                    elemCountKey = raw;
                }
                if (!Utilities.checkString(elemCountKey)) continue;
                this.collectKey = elemCountKey = "elem_" + elemCountKey;
                this.content = new StringBuffer();
                continue;
            }
            if (Utilities.checkString(attName)) {
                attCountKey = null;
                String attVal = atts.getValue(attName);
                if (Utilities.checkString(attValue)) {
                    attCountKey = "attName_" + attName + "%%" + attVal;
                }
                if (!Utilities.checkString(attCountKey)) continue;
                this.collectKey = attCountKey;
                this.content = new StringBuffer();
                continue;
            }
            if (!Utilities.checkString(attValue)) continue;
            attCountKey = null;
            for (int j = 0; j < atts.getLength(); ++j) {
                String attNameLoc = atts.getLocalName(j);
                String attVal = atts.getValue(j);
                if (!attValue.equals(attVal) || !Utilities.checkString(attCountKey = "attValue_" + attNameLoc + "%%" + attValue)) continue;
                this.collectKey = attCountKey;
                this.content = new StringBuffer();
            }
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        super.startElement(uri, loc, raw, a);
        if (!this.withinBoundsElem) {
            if (this.boundsElem.equals(loc) || this.boundsElem.equals(raw)) {
                this.resetFields();
                this.withinBoundsElem = true;
            }
        } else if (this.withinBoundsElem) {
            this.count(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.withinBoundsElem) {
            if (this.content != null) {
                String content = this.content.toString();
                String contentKey = this.collectKey + "%%%" + content;
                Integer occurence = (Integer)this.counter.get(contentKey);
                if (occurence != null) {
                    int occurInt = occurence;
                    occurence = new Integer(++occurInt);
                } else {
                    occurence = new Integer(1);
                }
                this.counter.put(contentKey, occurence);
                this.collectKey = "";
            }
            if (this.boundsElem.equals(loc) || this.boundsElem.equals(raw)) {
                this.withinBoundsElem = false;
                this.sendSummary();
                this.resetFields();
            }
            this.content = null;
        }
        super.endElement(uri, loc, raw);
    }

    protected void sendSummary() throws SAXException {
        Enumeration keys = this.counter.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Integer value = (Integer)this.counter.get(key);
            String countType = "";
            String countName = key.substring(key.indexOf("_") + 1, key.indexOf("%%"));
            String nodeValue = key.substring(key.indexOf("%%%") + 3, key.length());
            char[] chars = nodeValue.toCharArray();
            AttributesImpl atts = new AttributesImpl();
            if (key.startsWith("elem_")) {
                countType = "element";
            } else if (key.startsWith("attName_")) {
                countType = "attributeName";
                String attValue = key.substring(key.indexOf("%%") + 2, key.indexOf("%%%"));
                atts.addAttribute("", "att-value", "att-value", "CDATA", attValue);
            } else if (key.startsWith("attValue_")) {
                countType = "attributeValue";
                atts.addAttribute("", "count-value", "count-value", "CDATA", key.substring(key.indexOf("%%") + 2, key.indexOf("%%%")));
            }
            atts.addAttribute("", "count-type", "count-type", "CDATA", countType);
            atts.addAttribute("", "count-name", "count-name", "CDATA", countName);
            atts.addAttribute("", "occurs", "occurs", "CDATA", value.toString());
            super.startElement("", "count", "count", (Attributes)atts);
            super.characters(chars, 0, chars.length);
            super.endElement("", "count", "count");
        }
    }

    protected void resetFields() {
        this.withinBoundsElem = false;
        this.counter = new Hashtable();
        this.content = null;
        this.collectKey = "";
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        super.characters(c, start, len);
        if (this.withinBoundsElem && this.content != null) {
            this.content.append(c, start, len);
        }
    }
}

