/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractDataSourceComponentBackedRepository;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;

public class JDBCRepository
extends AbstractDataSourceComponentBackedRepository {
    public static final int NO_SPECIFIC_TYPE = -1;
    protected static final String FIELD_DATA = "data";
    protected final int PARAM_INDEX_FIELD_DATA_ORIGINAL = 2;

    public RepositoryConnection getConnection() throws SDXException {
        try {
            JDBCRepositoryConnection conn = new JDBCRepositoryConnection(this.getDataSourceComponent());
            conn.enableLogging(this.logger);
            return conn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3007, args, e);
        }
        catch (ComponentException e) {
            String[] args = new String[]{e.getMessage()};
            SDXException sdxE = new SDXException(null, 3201, args, e);
            String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
            throw new SDXException(this.logger, 3007, args2, sdxE);
        }
    }

    public void releaseConnection(RepositoryConnection c) throws SDXException {
        if (c != null) {
            if (((JDBCRepositoryConnection)c).getConnection() != null) {
                ((JDBCRepositoryConnection)c).releaseSqlConnection();
            }
            this.releaseDataSourceComponent(((JDBCRepositoryConnection)c).getDataSource());
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        if (this.manager != null) {
            this.dbSelector = (ComponentSelector)this.manager.lookup(DataSourceComponent.ROLE + "Selector");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        super.configure(configuration);
        this.loadBaseConfiguration(configuration);
        this.tableName = (String)this.props.get("appPathName") + "_" + this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        JDBCRepositoryConnection repoConn;
        block13: {
            Connection conn = null;
            ResultSet rs = null;
            repoConn = (JDBCRepositoryConnection)this.getConnection();
            try {
                try {
                    conn = repoConn.getConnection();
                    DatabaseMetaData dbmd = conn.getMetaData();
                    String tableName = this.getTableName();
                    StringTokenizer tnTokens = new StringTokenizer(tableName, "_", true);
                    String escapedTableName = "";
                    while (tnTokens.hasMoreTokens()) {
                        String nextToken = tnTokens.nextToken();
                        if (nextToken.equals("_") || nextToken.equals("%")) {
                            nextToken = dbmd.getSearchStringEscape() + nextToken;
                        }
                        escapedTableName = escapedTableName + nextToken;
                    }
                    if (Utilities.checkString(escapedTableName)) {
                        tableName = escapedTableName;
                    }
                    if (!((rs = dbmd.getTables(null, null, tableName, null)).next() || (rs = dbmd.getTables(null, null, tableName.toLowerCase(), null)).next() || (rs = dbmd.getTables(null, null, tableName.toUpperCase(), null)).next())) {
                        this.createTable(conn);
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3008, args, e);
                }
                Object var10_11 = null;
                if (rs == null) break block13;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3200, args, e);
                    }
                }
                repoConn.commit();
                this.releaseConnection(repoConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3200, args, e);
            }
            rs.close();
        }
        repoConn.commit();
        this.releaseConnection(repoConn);
    }

    public long size() throws SDXException {
        return this.size(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long size(int type) throws SDXException {
        long l;
        JDBCRepositoryConnection repoConn;
        block11: {
            repoConn = (JDBCRepositoryConnection)this.getConnection();
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                try {
                    conn = repoConn.getConnection();
                    String queryString = "SELECT count(*) FROM ?";
                    ps = conn.prepareStatement(queryString);
                    ps.setString(1, this.getTableName());
                    if (type != -1) {
                        queryString = queryString + " WHERE data=?";
                        ps.setInt(2, type);
                    }
                    ResultSet rs = ps.executeQuery();
                    int ret = 0;
                    if (rs.next()) {
                        ret = rs.getInt(1);
                    }
                    rs.close();
                    l = ret;
                    Object var11_11 = null;
                    if (ps == null) break block11;
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3009, args, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e2) {
                        String[] args = new String[]{this.getId(), e2.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e2);
                    }
                }
                this.releaseConnection(repoConn);
                throw throwable;
            }
            try {}
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                throw new SDXException(this.logger, 3203, args, e2);
            }
            ps.close();
        }
        this.releaseConnection(repoConn);
        return l;
    }

    public void lists(ContentHandler hdl) throws SDXException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        super.add(doc, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentAddQuery();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(queryString);
                ps.setString(1, doc.getId());
                ps.setBinaryStream(2, doc.openStream(), doc.getLength());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3000, args, e);
            }
            Object var9_6 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
        }
        try {}
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3203, args, e);
        }
        ps.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void empty() throws SDXException {
        JDBCRepositoryConnection repoConn;
        block9: {
            Connection conn = null;
            Statement ps = null;
            repoConn = (JDBCRepositoryConnection)this.getConnection();
            try {
                try {
                    conn = repoConn.getConnection();
                    String queryString = this.getDeleteAllQuery();
                    ps = conn.prepareStatement(queryString);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3003, args, e);
                }
                Object var7_6 = null;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e);
                    }
                }
                repoConn.commit();
                this.releaseConnection(repoConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
            ps.close();
        }
        repoConn.commit();
        this.releaseConnection(repoConn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(Document doc, RepositoryConnection c) throws SDXException {
        super.delete(doc, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentDeleteQuery();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(queryString);
                ps.setString(1, doc.getId());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3004, args, e);
            }
            Object var9_6 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
        }
        try {}
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3203, args, e);
        }
        ps.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        super.toSAX(doc, consumer, c);
        Parser parser = null;
        try {
            try {
                doc.setContent(this.openStream(doc, null, c));
                parser = (Parser)this.manager.lookup(Parser.ROLE);
                doc.parse(parser, consumer);
            }
            catch (ComponentException e) {
                String[] args = new String[]{e.getMessage()};
                SDXException sdxE = new SDXException(null, 2001, args, e);
                String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
                throw new SDXException(this.logger, 3001, args2, sdxE);
            }
            Object var10_5 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (parser == null) throw throwable;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        ResultSet rs;
        PreparedStatement ps;
        block18: {
            InputStream inputStream;
            block19: {
                InputStream is;
                super.openStream(doc, encoding, c);
                Connection conn = ((JDBCRepositoryConnection)c).getConnection();
                String queryString = this.getDocumentGetQuery();
                ps = null;
                rs = null;
                ps = conn.prepareStatement(queryString);
                ps.setString(1, doc.getId());
                rs = ps.executeQuery();
                if (!rs.next()) break block18;
                inputStream = is = rs.getBinaryStream(FIELD_DATA);
                Object var11_13 = null;
                if (ps == null) break block19;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3203, args, e);
                }
            }
            if (rs != null) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3200, args, e);
                }
            }
            return inputStream;
        }
        try {
            try {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(this.logger, 3001, args, null);
            }
            catch (SQLException e) {
                String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3001, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (ps != null) {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3203, args, e);
                }
            }
            if (rs != null) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3200, args, e);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        ResultSet rs;
        block13: {
            super.get(doc, os, c);
            Connection conn = ((JDBCRepositoryConnection)c).getConnection();
            String queryString = this.getDocumentGetQuery();
            PreparedStatement ps = null;
            rs = null;
            try {
                try {
                    ps = conn.prepareStatement(queryString);
                    ps.setString(1, doc.getId());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        IOUtil.copy((InputStream)rs.getBinaryStream(FIELD_DATA), (OutputStream)os);
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3001, args, e);
                }
                catch (IOException e) {
                    String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3001, args, e);
                }
                Object var11_8 = null;
                if (ps == null) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e);
                    }
                }
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3200, args, e);
                }
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
            ps.close();
        }
        if (rs == null) return;
        try {}
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3200, args, e);
        }
        rs.close();
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + FIELD_DATA + " BINARY, PRIMARY KEY (" + "id" + "))";
    }

    protected String getDocumentAddQuery() {
        return "INSERT INTO " + this.getTableName() + " (" + "id" + "," + FIELD_DATA + ") VALUES (?, ?)";
    }

    protected String getDocumentDeleteQuery() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getDeleteAllQuery() {
        return "DELETE FROM " + this.getTableName();
    }
}

