/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.document.IndexableFieldProperty;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.thesaurus.Concept;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractConcept
extends XMLDocument
implements Concept {
    public static final String TERM = "term";
    public static final String RELATION_SCOPE_NOTE = "sn";
    public static final String RELATION_NARROWER_TERM = "nt";
    public static final String RELATION_BROADER_TERM = "bt";
    public static final String RELATION_BROADER_TERMS = "bts";
    public static final String RELATION_USED_FOR = "uf";
    public static final String RELATION_EQUIVALENT_TERM = "et";
    public static final String RELATION_RELATED_TERM = "rt";
    public static final String RELATION_USE = "use";
    public static final String RELATION_PARTIAL_EQIUVALENCE = "pe";
    public static final String FIELD_NAME_FTERM = "fterm";
    public static final String FIELD_NAME_FUF = "fuf";
    protected String valueKey = "term";
    protected String xmlLangKey = "xmllang";
    protected String value = null;
    protected String xmlLang = null;

    public AbstractConcept() {
        this.DOC_ROOT_ELEMENT_NAME = "concept";
        this.DOC_NAMESPACE = "http://sdx.culture.fr/thesaurus/1.0";
    }

    public AbstractConcept(String id) throws SDXException {
        super(id);
        this.DOC_ROOT_ELEMENT_NAME = "concept";
        this.DOC_NAMESPACE = "http://sdx.culture.fr/thesaurus/1.0";
    }

    public String getDocType() {
        return "concept";
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (this.DOC_NAMESPACE.equals(uri)) {
            if (this.DOC_ROOT_ELEMENT_NAME.equals(loc)) {
                super.startElement(uri, loc, raw, a);
                String xmlLang = a.getValue("xml:lang");
                if (Utilities.checkString(xmlLang)) {
                    this.setXmlLang(xmlLang);
                }
            } else if (TERM.equals(loc)) {
                this.sendSdxFieldStartElement(loc);
            } else if ("relation".equals(loc)) {
                this.makeRelationTypeAttributeValueAsFieldNameForConcept("type", a);
                String refValue = a.getValue("ref");
                if (Utilities.checkString(refValue)) {
                    this.addRelationNameAsFieldValueOfConcept(refValue);
                }
            } else if ("p".equals(loc)) {
                this.sendSdxFieldStartElement(RELATION_SCOPE_NOTE);
            } else {
                super.startElement(uri, loc, raw, a);
            }
        } else {
            super.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.DOC_NAMESPACE.equals(uri)) {
            if (this.DOC_ROOT_ELEMENT_NAME.equals(loc)) {
                super.endElement(uri, loc, raw);
                if (this.openSdxDocElems == 0) {
                    this.buildRelations();
                }
            } else if (TERM.equals(loc) || "relation".equals(loc) || "p".equals(loc) || RELATION_USED_FOR.equals(loc)) {
                if (this.currentFieldName != null && this.currentFieldName.equalsIgnoreCase(TERM) && this.characterBuffer != null && this.characterBuffer.length() > 0) {
                    this.properties.add(new IndexableFieldProperty(FIELD_NAME_FTERM, this.characterBuffer.toString()));
                }
                if (this.currentFieldName != null && this.currentFieldName.equalsIgnoreCase(RELATION_USED_FOR) && this.characterBuffer != null && this.characterBuffer.length() > 0) {
                    this.properties.add(new IndexableFieldProperty(FIELD_NAME_FUF, this.characterBuffer.toString()));
                }
                this.sendSdxFieldEndElement();
            } else {
                super.endElement(uri, loc, raw);
            }
        } else {
            super.endElement(uri, loc, raw);
        }
    }

    private void buildRelations() throws SAXException {
        Enumeration children = this.getSubDocuments();
        if (children != null) {
            while (children.hasMoreElements()) {
                Concept child = (Concept)children.nextElement();
                this.addRelationReferenceToConcept(child, this, RELATION_NARROWER_TERM);
                this.addRelationReferenceToConcept(this, child, RELATION_BROADER_TERM);
                this.addRelationReferenceToConcept(this, child, RELATION_BROADER_TERMS);
                this.buildBroaderTermsRelations(child);
            }
        }
    }

    private void buildBroaderTermsRelations(Concept child) throws SAXException {
        Enumeration grandChildren;
        if (child != null && (grandChildren = child.getSubDocuments()) != null) {
            while (grandChildren.hasMoreElements()) {
                Concept grandChild = (Concept)grandChildren.nextElement();
                if (grandChild != null) {
                    this.addRelationReferenceToConcept(this, grandChild, RELATION_BROADER_TERMS);
                }
                this.buildBroaderTermsRelations(grandChild);
            }
        }
    }

    private void makeRelationTypeAttributeValueAsFieldNameForConcept(String attName, Attributes atts) throws SAXException {
        String value;
        if (Utilities.checkString(attName) && atts != null && Utilities.checkString(value = atts.getValue(attName))) {
            this.sendSdxFieldStartElement(value.toLowerCase());
        }
    }

    private void addRelationReferenceToConcept(Concept relationFrom, Concept relationTo, String relationType) {
        String relationFromId = relationFrom.getId();
        relationTo.addRelation(relationType, relationFromId);
    }

    private void addRelationNameAsFieldValueOfConcept(String fieldValue) throws SAXException {
        this.sendSdxFieldCharacters(fieldValue);
    }

    private void sendSdxFieldStartElement(String attValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "name", "CDATA", attValue);
        super.startElement(this.DOC_NAMESPACE, this.DOC_FIELD_ELEMENT_NAME, this.DOC_FIELD_ELEMENT_NAME, atts);
    }

    private void sendSdxFieldCharacters(String fieldValue) throws SAXException {
        if (Utilities.checkString(fieldValue)) {
            char[] c = fieldValue.toCharArray();
            super.characters(c, 0, c.length);
        }
    }

    private void sendSdxFieldEndElement() throws SAXException {
        super.endElement(this.DOC_NAMESPACE, this.DOC_FIELD_ELEMENT_NAME, this.DOC_FIELD_ELEMENT_NAME);
    }

    public void addRelation(String relationType, String relationValue) {
        this.properties.add(new IndexableFieldProperty(relationType, relationValue));
    }

    public static String getRelationTypeString(int type) {
        switch (type) {
            case 1: {
                return RELATION_BROADER_TERMS;
            }
            case 0: {
                return RELATION_BROADER_TERM;
            }
            case 2: {
                return RELATION_NARROWER_TERM;
            }
            case 5: {
                return RELATION_USED_FOR;
            }
            case 6: {
                return RELATION_SCOPE_NOTE;
            }
            case 7: {
                return RELATION_EQUIVALENT_TERM;
            }
            case 3: {
                return RELATION_RELATED_TERM;
            }
            case 4: {
                return RELATION_USE;
            }
            case 8: {
                return RELATION_PARTIAL_EQIUVALENCE;
            }
        }
        return null;
    }

    public static int getRelationTypeInt(String abbr) {
        if (abbr.equalsIgnoreCase(RELATION_BROADER_TERMS)) {
            return 1;
        }
        if (abbr.equalsIgnoreCase(RELATION_BROADER_TERM)) {
            return 0;
        }
        if (abbr.equalsIgnoreCase(RELATION_NARROWER_TERM)) {
            return 2;
        }
        if (abbr.equalsIgnoreCase(RELATION_USE)) {
            return 4;
        }
        if (abbr.equalsIgnoreCase(RELATION_USED_FOR)) {
            return 5;
        }
        if (abbr.equalsIgnoreCase(RELATION_SCOPE_NOTE)) {
            return 6;
        }
        if (abbr.equalsIgnoreCase(RELATION_EQUIVALENT_TERM)) {
            return 7;
        }
        if (abbr.equalsIgnoreCase(RELATION_RELATED_TERM)) {
            return 3;
        }
        if (abbr.equalsIgnoreCase(RELATION_PARTIAL_EQIUVALENCE)) {
            return 8;
        }
        return -1;
    }

    public void setValue(String value) {
        if (value != null) {
            if (this.properties != null) {
                this.properties.add(new IndexableFieldProperty(this.valueKey, value));
            }
            this.value = value;
        }
    }

    public void setXmlLang(String xmlLang) {
        if (xmlLang != null) {
            if (this.properties != null) {
                this.properties.add(new IndexableFieldProperty(this.xmlLangKey, xmlLang));
            }
            this.xmlLang = xmlLang;
        }
    }
}

