/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.IndexableFieldProperty;
import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.documentbase.LuceneIndexParameters;
import fr.gouv.culture.sdx.documentbase.SDXDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.LuceneDocumentBaseOAIHarvester;
import fr.gouv.culture.sdx.oai.LuceneDocumentBaseOAIRepository;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.search.lucene.analysis.MetaAnalyzer;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.ParallelMultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LuceneDocumentBase
extends SDXDocumentBase {
    protected Vector luceneSearchIndexList = new Vector();
    protected LuceneIndex luceneActiveIndex;
    protected LuceneIndex luceneCurrentIndex;
    protected FieldList _fieldList;
    protected HashMap _xmlFieldList;
    protected int subIndexCount;
    protected long lastDocCount;
    protected final String INDEX_DIR_CURRENT = "current";
    protected final String INDEX_DIR_MAIN = "main";
    protected final String SEARCH_INDEX_DIRECTORY_NAME = "sdx-search-index";
    public static final String DBELEM_ATTRIBUTE_REMOTE_ACCESS = "remote-access";
    public static final String ELEMENT_NAME_LUCENE_SDX_INTERNAL_FIELDS = "luceneSDXInternalFields";
    FilenameFilter indexDirFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return Utilities.isNameMatchIndexFiles(name);
        }
    };
    FilenameFilter indexContentFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !Utilities.isNameMatchIndexFiles(name) && !name.startsWith("current");
        }
    };

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    protected void configureDocumentBase(Configuration configuration) throws ConfigurationException {
        this.configureFieldList(configuration);
        this.configureSearchIndex();
        this.initializeVectorizedIndex();
        if (this.autoOptimize) {
            this.optimize();
        }
        this.lastDocCount = this.luceneCurrentIndex.size() % this.splitDoc;
    }

    protected void configureFieldList(Configuration configuration) throws ConfigurationException {
        try {
            Configuration l_fieldListConf = null;
            l_fieldListConf = configuration.getName().equals("fieldList") ? configuration : configuration.getChild("fieldList", true);
            String ref = l_fieldListConf.getAttribute("ref", null);
            if (Utilities.checkString(ref)) {
                Context appFieldLists = (Context)super.getContext().get((Object)"sdx.application.fieldLists");
                if (appFieldLists != null) {
                    this._fieldList = (FieldList)appFieldLists.get((Object)ref);
                }
                this._fieldList = (FieldList)this._fieldList.clone();
                this._fieldList = (FieldList)super.setUpSdxObject(this._fieldList);
                this._fieldList.configure(configuration);
                if (this._fieldList == null) {
                    String[] args = new String[]{ref};
                    throw new SDXException(super.getLog(), 42, args, null);
                }
            } else {
                this._fieldList = ConfigurationUtils.configureFieldList(super.getLog(), this.getServiceManager(), Utilities.createNewReadOnlyContext((Context)this.getContext()), new DefaultIDGenerator().generate(), configuration);
                this._fieldList = ConfigurationUtils.configureLuceneFieldList(super.getLog(), (Context)super.getContext(), this._fieldList);
            }
            super.getContext().put((Object)"sdx.documentbase.fieldList", (Object)this._fieldList);
        }
        catch (SDXException e) {
        }
        catch (ConfigurationException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
        catch (ContextException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
    }

    public void reloadFieldList(String appConfString) throws SDXException {
        if (appConfString != null && !appConfString.equals("")) {
            Configuration appConf = null;
            try {
                DefaultConfigurationBuilder appConfigBuild = new DefaultConfigurationBuilder(true);
                Source source = null;
                SourceResolver resolver = (SourceResolver)this._manager.lookup(org.apache.cocoon.environment.SourceResolver.ROLE);
                source = resolver.resolveURI(appConfString);
                appConf = appConfigBuild.build(SourceUtil.getInputSource((Source)source));
            }
            catch (Exception e) {
                String[] args = new String[]{this._id, appConfString};
                new SDXException(super.getLog(), 3, args, e);
            }
            Configuration m_conf = null;
            try {
                if (appConf.getName().equals("fieldList")) {
                    m_conf = appConf;
                } else if (appConf.getName().toLowerCase().equals("Application".toLowerCase()) && Utilities.checkString(this._id)) {
                    String documentBaseElementName = Utilities.getElementName("DocumentBase");
                    Configuration[] dbsConf = new Configuration[appConf.getChild(documentBaseElementName + "s").getChildren(documentBaseElementName).length];
                    dbsConf = appConf.getChild(documentBaseElementName + "s").getChildren(documentBaseElementName);
                    if (dbsConf != null && dbsConf.length > 0) {
                        for (int i = 0; i < dbsConf.length; ++i) {
                            if (!dbsConf[i].getAttribute("id").equals(this._id)) continue;
                            m_conf = dbsConf[i].getChild("fieldList", true);
                            break;
                        }
                    }
                }
                this.configureFieldList(m_conf);
                this.configureSearchIndex();
            }
            catch (ConfigurationException e) {
                String[] args = new String[]{this._id, appConf.getLocation()};
                throw new SDXException(super.getLog(), 3, args, e);
            }
        }
    }

    public void replaceFieldList(FieldList fieldList) throws ConfigurationException {
        this._fieldList = fieldList;
        try {
            this.configureSearchIndex();
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{this._id};
            new SDXException(super.getLog(), 3, args, e);
        }
    }

    protected void configureSearchIndex() throws ConfigurationException {
        try {
            String rmiHost = Utilities.getStringFromContext("sdx.framework.rmiHost", (Context)super.getContext());
            Integer rmiPort = (Integer)super.getContext().get((Object)"sdx.framework.rmiPort");
            String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
            this.baseIndexDir = Utilities.getStringFromContext("sdx.documentbase.dbDirPath", (Context)super.getContext()) + File.separator + "sdx-search-index" + File.separator;
            String sdxSearchIndexPath = this.baseIndexDir + "main" + File.separator;
            File sdxSearchIndexDir = Utilities.checkDirectory(sdxSearchIndexPath, super.getLog());
            this.luceneActiveIndex = new LuceneIndex(sdxSearchIndexDir, rmiHost, rmiPort, appId, this.getId(), this.useCompoundFiles);
            this.luceneActiveIndex = (LuceneIndex)super.setUpSdxObject(this.luceneActiveIndex, this._configuration);
            this.luceneActiveIndex.setId("main");
            MetaAnalyzer mAnalyzer = new MetaAnalyzer();
            mAnalyzer.enableLogging(super.getLog());
            mAnalyzer.setUp(this._fieldList);
            this.luceneActiveIndex.setMetaAnalyzer(mAnalyzer);
            this.luceneActiveIndex.init();
            String sdxTempIndexPath = this.baseIndexDir + "current" + File.separator;
            File sdxTempIndexDir = Utilities.checkDirectory(sdxTempIndexPath, super.getLog());
            this.luceneCurrentIndex = new LuceneIndex(this.luceneActiveIndex, sdxTempIndexDir);
            this.luceneCurrentIndex = (LuceneIndex)super.setUpSdxObject(this.luceneCurrentIndex, this._configuration);
            this.luceneCurrentIndex.setId("current");
            this.luceneCurrentIndex.setMetaAnalyzer(mAnalyzer);
            this.luceneCurrentIndex.init();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public OAIRepository createOAIRepository() {
        if (this._configuration != null) {
            try {
                this.configureOAIRepository(this._configuration);
            }
            catch (ConfigurationException _ce) {
                new ConfigurationException(_ce.getMessage(), (Throwable)_ce);
            }
        }
        return this.oaiRepo;
    }

    public OAIRepository createOAIRepository(Configuration configuration) {
        try {
            this.configureOAIRepository(configuration);
        }
        catch (ConfigurationException _ce) {
            new ConfigurationException(_ce.getMessage(), (Throwable)_ce);
        }
        return this.oaiRepo;
    }

    protected void configureOAIRepository(Configuration configuration) throws ConfigurationException {
        Configuration oaiRepoConf = configuration.getChild("oai-repository", false);
        if (oaiRepoConf != null) {
            LuceneDocumentBaseOAIRepository luceneOaiRepo = new LuceneDocumentBaseOAIRepository(this);
            try {
                luceneOaiRepo.enableLogging(super.getLog());
                luceneOaiRepo.contextualize((Context)super.getContext());
                luceneOaiRepo.service(super.getServiceManager());
                luceneOaiRepo.configure(oaiRepoConf);
                this.oaiRepo = luceneOaiRepo;
            }
            catch (ServiceException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void configureOAIHarvester(Configuration configuration) throws ConfigurationException {
        Configuration oaiHarvConf = configuration.getChild("oai-harvester", false);
        if (oaiHarvConf != null) {
            LuceneDocumentBaseOAIHarvester luceneOAIHarvester = new LuceneDocumentBaseOAIHarvester(this);
            try {
                luceneOAIHarvester.enableLogging(super.getLog());
                luceneOAIHarvester.contextualize((Context)super.getContext());
                luceneOAIHarvester.service(super.getServiceManager());
                luceneOAIHarvester.configure(oaiHarvConf);
                this._oaiHarv = luceneOAIHarvester;
            }
            catch (ServiceException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void index(IndexableDocument[] docs, Repository repository, IndexParameters params, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        super.index(docs, repository, params, handler);
        if (!this.autoOptimize || docs.length <= 1) {
            this.getLuceneIndex().recycleLuceneIndexSearcher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(Document[] docs, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        try {
            super.delete(docs, handler);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (docs.length <= 1 || !this.autoOptimize) {
                this.getLuceneIndex().recycleSearcher();
                this.luceneActiveIndex.indexModified(true);
            }
            throw throwable;
        }
        if (docs.length <= 1 || !this.autoOptimize) {
            this.getLuceneIndex().recycleSearcher();
            this.luceneActiveIndex.indexModified(true);
        }
    }

    protected IndexParameters setBaseParameters(IndexParameters params) {
        if (params != null && params instanceof LuceneIndexParameters) {
            this.setSearchIndexParameters((LuceneIndexParameters)params);
        }
        return super.setBaseParameters(params);
    }

    public HashMap getXMLFieldList() {
        if (this._xmlFieldList == null) {
            this._xmlFieldList = new HashMap();
            Enumeration elem = this._fieldList.getFields();
            while (elem.hasMoreElements()) {
                fr.gouv.culture.sdx.search.lucene.Field f = (fr.gouv.culture.sdx.search.lucene.Field)elem.nextElement();
                if (f.getFieldType() != 4) continue;
                this._xmlFieldList.put(f.getCode(), f);
            }
        }
        return this._xmlFieldList;
    }

    public Index getIndex() {
        return this.luceneActiveIndex;
    }

    public LuceneIndex getLuceneIndex() {
        return this.luceneActiveIndex;
    }

    protected void setSearchIndexParameters(LuceneIndexParameters params) {
        this.luceneActiveIndex.setParameters(params);
    }

    protected void addToSearchIndex(Object indexationDoc, boolean batchIndex) throws SDXException {
        this.luceneActiveIndex.writeDocument((org.apache.lucene.document.Document)indexationDoc, batchIndex, this.autoOptimize);
    }

    protected void deleteFromSearchIndex(String docId) throws SDXException {
        LuceneIndex currentIndex;
        for (int i = this.luceneSearchIndexList.size() - 1; i >= 0 && (currentIndex = (LuceneIndex)this.luceneSearchIndexList.get(i)) != null; --i) {
            currentIndex.deleteDocument(docId);
        }
    }

    protected void compactSearchIndex() throws SDXException {
        this.luceneActiveIndex.mergeCurrentBatch(this.autoOptimize);
    }

    protected Object getIndexationDocument(IndexableDocument doc, String storeDocId, String repoId, IndexParameters params) throws SDXException {
        Field fId2;
        org.apache.lucene.document.Document lDoc = new org.apache.lucene.document.Document();
        float docBoost = doc.getBoost();
        lDoc.setBoost(docBoost);
        Enumeration fieldVals = doc.getFieldValues();
        while (fieldVals != null && fieldVals.hasMoreElements()) {
            IndexableFieldProperty prop = (IndexableFieldProperty)fieldVals.nextElement();
            if (prop == null) continue;
            String fieldName = prop.getName();
            String[] fieldValues = prop.getValues();
            float fieldBoost = prop.getBoost();
            fr.gouv.culture.sdx.search.lucene.Field sdxF = this._fieldList.getField(fieldName);
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldValue = fieldValues[i];
                if (sdxF != null) {
                    Field f = sdxF.getLuceneField(fieldValue);
                    if (f == null) continue;
                    f.setBoost(fieldBoost);
                    lDoc.add(f);
                    continue;
                }
                if (!Utilities.checkString(fieldValue)) continue;
                lDoc.add(Field.UnIndexed((String)fieldName, (String)fieldValue));
                LoggingUtils.logInfo(this.getLog(), "The field \"" + fieldName + "\" with the value, \"" + fieldValue + "\" was not present in the FieldList, but was added as a non-indexed field");
            }
        }
        Utilities.checkDocument(super.getLog(), doc);
        Field fId = null;
        if (Utilities.checkString(storeDocId)) {
            fId = Field.Keyword((String)"sdxdocid", (String)storeDocId);
        }
        if (fId != null) {
            lDoc.add(fId);
        }
        if ((fId2 = Field.Keyword((String)"sdxall", (String)"1")) != null) {
            lDoc.add(fId2);
        }
        Field fId3 = null;
        String docbaseId = this.getId();
        if (Utilities.checkString(docbaseId)) {
            fId3 = Field.Keyword((String)"sdxdbid", (String)docbaseId);
        }
        if (fId3 != null) {
            lDoc.add(fId3);
        }
        Field fId4 = null;
        String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
        if (Utilities.checkString(appId)) {
            fId4 = Field.Keyword((String)"sdxappid", (String)appId);
        }
        if (fId4 != null) {
            lDoc.add(fId4);
        }
        Field fId5 = null;
        String doctype = doc.getDocType();
        if (Utilities.checkString(doctype)) {
            fId5 = Field.Keyword((String)"sdxdoctype", (String)doctype);
        }
        if (fId5 != null) {
            lDoc.add(fId5);
        }
        Field fId6 = null;
        long modDate = Date.getUtcIso8601Date().getTime();
        modDate = Long.parseLong(params.getPipelineParams().getParameter("sdxDateMilliseconds", String.valueOf(modDate)));
        fId6 = Field.Keyword((String)"sdxmoddate", (String)DateField.timeToString(modDate));
        if (fId6 != null) {
            lDoc.add(fId6);
        }
        Field fId7 = null;
        String length = Integer.toString(doc.getLength());
        if (Utilities.checkString(length)) {
            fId7 = Field.Keyword((String)"sdxcontentlength", (String)length);
        }
        if (fId7 != null) {
            lDoc.add(fId7);
        }
        Field fId8 = null;
        if (Utilities.checkString(repoId)) {
            fId8 = Field.Keyword((String)"sdxrepoid", (String)repoId);
        }
        if (fId8 != null) {
            lDoc.add(fId8);
        }
        doc.addAdditionalSystemFields(lDoc);
        return lDoc;
    }

    public java.util.Date lastModificationDate() {
        return this.luceneActiveIndex.getLastModificationDate();
    }

    public java.util.Date creationDate() {
        return this.luceneActiveIndex.getCreationDate();
    }

    public void init() throws SDXException {
        super.init();
        this.luceneActiveIndex.init();
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        try {
            if (this.luceneActiveIndex != null && this.luceneActiveIndex.getQueryParser() != null) {
                this._xmlizable_objects.put("Query_Parser", this.luceneActiveIndex.getQueryParser().getClass().getName());
            } else {
                this._xmlizable_objects.put("Query_Parser", "none");
            }
        }
        catch (SDXException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        this._xmlizable_objects.put(Utilities.getElementName("FieldList"), this._fieldList);
        String prefix = Utilities.getElementName("Index") + "_";
        if (this.luceneActiveIndex != null) {
            String iPath;
            File iDir;
            this._xmlizable_objects.put(prefix + "encoding", this.luceneActiveIndex.getEncoding());
            this._xmlizable_objects.put(prefix + "xml-lang", this.luceneActiveIndex.getXmlLang());
            this._xmlizable_objects.put(prefix + "document_count", String.valueOf(this.luceneActiveIndex.size()));
            this._xmlizable_objects.put(prefix + "path", this.luceneActiveIndex.getIndexPath());
            this._xmlizable_objects.put(prefix + "engine", "lucene");
            this._xmlizable_objects.put(prefix + "use_compound_files", String.valueOf(this.luceneActiveIndex.isUsingCompoundFiles()));
            this._xmlizable_objects.put(prefix + "is_optimized", String.valueOf(this.isIndexOptimized()));
            this._xmlizable_objects.put(prefix + "useMetadata", String.valueOf(this.isUseMetadata()));
            if (this.creationDate() != null) {
                this._xmlizable_objects.put(prefix + "creation_date", this.creationDate().toString());
            }
            if (this.lastModificationDate() != null) {
                this._xmlizable_objects.put(prefix + "last_modification_date", this.lastModificationDate().toString());
            }
            if ((iDir = new File(iPath = this.luceneActiveIndex.getIndexPath())) != null) {
                int iFileNumber;
                File[] iFiles = iDir.listFiles(this.indexContentFilter);
                long iFullSize = 0L;
                for (iFileNumber = 0; iFiles != null && iFileNumber < iFiles.length; ++iFileNumber) {
                    iFullSize += iFiles[iFileNumber].length();
                }
                this._xmlizable_objects.put(prefix + "full_size", String.valueOf(iFullSize / 1024L) + " Ko");
                this._xmlizable_objects.put(prefix + "count_files", String.valueOf(iFileNumber));
            }
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        String prefix = Utilities.getElementName("Index") + "_";
        if (this.luceneActiveIndex != null) {
            this._xmlizable_objects.put(prefix + "document_count", String.valueOf(this.luceneActiveIndex.size()));
            this._xmlizable_objects.put(prefix + "use_compound_files", String.valueOf(this.luceneActiveIndex.isUsingCompoundFiles()));
            this._xmlizable_objects.put(prefix + "is_optimized", String.valueOf(this.isIndexOptimized()));
            this._xmlizable_objects.put(prefix + "useMetadata", String.valueOf(this.isUseMetadata()));
            if (this.creationDate() != null) {
                this._xmlizable_objects.put(prefix + "creation_date", this.creationDate().toString());
            }
            if (this.lastModificationDate() != null) {
                this._xmlizable_objects.put(prefix + "last_modification_date", this.lastModificationDate().toString());
            }
            this._xmlizable_objects.put(prefix + "split_size", String.valueOf(this.splitSize / 1024L) + " Ko");
            this._xmlizable_objects.put(prefix + "split_doc", String.valueOf(this.splitDoc));
            File iDir = new File(this.baseIndexDir);
            File[] iSubDirs = iDir.listFiles(this.indexDirFilter);
            this._xmlizable_objects.put(prefix + "full_size", String.valueOf(iDir.length()) + " Ko");
            this._xmlizable_objects.put(prefix + "count_files", String.valueOf(iSubDirs.length));
        }
    }

    public synchronized void optimize() {
        try {
            LuceneIndex currentIndex;
            int i;
            for (i = this.luceneSearchIndexList.size() - 1; i > 0 && (currentIndex = (LuceneIndex)this.luceneSearchIndexList.get(i)) != null; --i) {
                currentIndex.optimize();
            }
            try {
                this.luceneCurrentIndex.freeResources();
                ((LuceneIndex)this.luceneSearchIndexList.get(1)).freeResources();
                ((LuceneIndex)this.luceneSearchIndexList.get(i)).optimize();
            }
            catch (IOException e) {
                LoggingUtils.logException(this.getLog(), e);
            }
            this.renewKeyIndex();
            this.optimizeRepositories();
            this.releasePooledRepositoryConnections();
            this.optimizeDatabase();
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
    }

    public void mergeBatch() throws SDXException {
        this.luceneCurrentIndex.mergeCurrentBatch(this.autoOptimize);
    }

    public synchronized void mergeCurrentBatch() {
        try {
            for (int i = 0; i < this.luceneSearchIndexList.size(); ++i) {
                LuceneIndex currentIndex = (LuceneIndex)this.luceneSearchIndexList.get(i);
                if (currentIndex == null) continue;
                currentIndex.mergeCurrentBatch(this.autoOptimize);
            }
            this.renewKeyIndex();
            this.optimizeRepositories();
            this.releasePooledRepositoryConnections();
            this.optimizeDatabase();
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
    }

    public void indexModified() {
        try {
            this.luceneActiveIndex.indexModified(true);
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
    }

    public void splitIndex(boolean currentIndex) throws IOException, SDXException {
        LuceneIndex index = currentIndex ? this.luceneCurrentIndex : this.luceneActiveIndex;
        if (index == null) {
            return;
        }
        index.freeResources();
        this.addSubIndex(index);
        this.renewKeyIndex();
    }

    protected void initializeVectorizedIndex() throws ConfigurationException {
        this.luceneSearchIndexList.clear();
        this.luceneSearchIndexList.add(this.luceneActiveIndex);
        this.luceneSearchIndexList.add(this.luceneCurrentIndex);
        File indexDirectory = new File(this.baseIndexDir);
        this.subIndexCount = 0;
        int maxCount = 0;
        File[] iSubDir = indexDirectory.listFiles(this.indexDirFilter);
        for (int counter = 0; iSubDir != null && counter < iSubDir.length; ++counter) {
            File tempDir = iSubDir[counter];
            this.subIndexCount = Integer.parseInt(tempDir.getName());
            this.addSubIndex();
            if (Integer.parseInt(tempDir.getName()) <= maxCount) continue;
            maxCount = Integer.parseInt(tempDir.getName());
        }
        this.subIndexCount = maxCount;
    }

    protected void addSubIndex() {
        File subDir = new File(this.baseIndexDir + File.separatorChar + this.getFormatedSubIndexId(this.subIndexCount));
        if (subDir != null) {
            try {
                LuceneIndex subIndex = new LuceneIndex(this.luceneActiveIndex, subDir);
                subIndex = (LuceneIndex)super.setUpSdxObject(subIndex, this._configuration);
                MetaAnalyzer mAnalyzer = new MetaAnalyzer();
                mAnalyzer.enableLogging(super.getLog());
                mAnalyzer.setUp(this._fieldList);
                subIndex.setMetaAnalyzer(mAnalyzer);
                subIndex.init();
                this.luceneSearchIndexList.add(subIndex);
                subDir = null;
            }
            catch (SDXException e) {
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        ++this.subIndexCount;
    }

    protected void removeSubIndex() {
    }

    public boolean splitCheck(boolean currentIndex) throws SDXException {
        if (!this.splitActive) {
            return false;
        }
        LuceneIndex index = currentIndex ? this.luceneCurrentIndex : this.luceneActiveIndex;
        if (index == null) {
            return false;
        }
        if (this.splitSize > 0L && this.getIndexSize(index) > this.splitSize) {
            return true;
        }
        if (this.splitDoc > 0L) {
            index.init();
            if (index.size() > this.splitDoc) {
                return true;
            }
        }
        return false;
    }

    protected long getIndexSize(LuceneIndex index) {
        if (index == null) {
            return -1L;
        }
        long iFullSize = 0L;
        String iPath = index.getIndexPath();
        File iDir = new File(iPath);
        if (iDir != null) {
            File[] iFiles = iDir.listFiles(this.indexContentFilter);
            for (int iFileNumber = 0; iFiles != null && iFileNumber < iFiles.length; ++iFileNumber) {
                iFullSize += iFiles[iFileNumber].length();
            }
            iFiles = null;
        }
        iDir = null;
        return iFullSize;
    }

    public Searcher getSearcher() throws SDXException {
        try {
            Searcher[] searchers = new Searcher[this.luceneSearchIndexList.size()];
            for (int i = 0; i < this.luceneSearchIndexList.size(); ++i) {
                LuceneIndex index = (LuceneIndex)this.luceneSearchIndexList.elementAt(i);
                searchers[i] = index.getSearcher();
            }
            return new ParallelMultiSearcher((Searchable[])searchers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4500, args, e);
        }
    }

    public IndexReader getIndexReader() throws SDXException {
        try {
            IndexReader[] readers = new IndexReader[this.luceneSearchIndexList.size()];
            for (int i = 0; i < this.luceneSearchIndexList.size(); ++i) {
                readers[i] = ((LuceneIndex)this.luceneSearchIndexList.get(i)).getReader();
            }
            return new MultiReader(readers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4503, args, e);
        }
    }

    protected String getFormatedSubIndexId(int subIndexNumber) {
        DecimalFormat df = new DecimalFormat("0000");
        return df.format(subIndexNumber);
    }

    protected void addSubIndex(LuceneIndex index) {
        File subDir = new File(this.baseIndexDir + File.separatorChar + this.getFormatedSubIndexId(this.subIndexCount));
        if (!subDir.exists()) {
            try {
                Utilities.safeCopy(new File(index.getIndexPath()), subDir);
                LuceneIndex subIndex = new LuceneIndex(index, subDir);
                subIndex = (LuceneIndex)super.setUpSdxObject(subIndex, this._configuration);
                MetaAnalyzer mAnalyzer = new MetaAnalyzer();
                mAnalyzer.enableLogging(super.getLog());
                mAnalyzer.setUp(this._fieldList);
                subIndex.setMetaAnalyzer(mAnalyzer);
                subIndex.init();
                this.luceneSearchIndexList.add(subIndex);
            }
            catch (SDXException e) {
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        ++this.subIndexCount;
    }

    protected void renewKeyIndex() {
        try {
            this.luceneActiveIndex.freeResources();
            this.luceneActiveIndex.init();
            ((LuceneIndex)this.luceneSearchIndexList.get(0)).freeResources();
            ((LuceneIndex)this.luceneSearchIndexList.get(0)).init();
            this.luceneCurrentIndex.freeResources();
            this.luceneCurrentIndex.init();
            ((LuceneIndex)this.luceneSearchIndexList.get(1)).freeResources();
            ((LuceneIndex)this.luceneSearchIndexList.get(1)).init();
        }
        catch (IOException e) {
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.isAllElementSelected()) {
            save_config.setAttribute("type", "LUCENE");
        }
    }

    protected void backupIndexes(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected() && this.luceneSearchIndexList != null && this.luceneSearchIndexList.size() > 0) {
            String indexes_path = Utilities.getElementName("Index") + "es";
            File indexes_dir = new File(save_config.getStoreCompletePath() + File.separator + indexes_path);
            if (!indexes_dir.exists()) {
                indexes_dir.mkdir();
            }
            Enumeration _enum = this.luceneSearchIndexList.elements();
            while (_enum.hasMoreElements()) {
                Index index = (Index)_enum.nextElement();
                if (index == null) continue;
                SaveParameters indexsave = new SaveParameters(Utilities.getElementName("Index"), save_config, indexes_path);
                if (!(index instanceof LuceneIndex)) continue;
                ((LuceneIndex)index).backup(indexsave);
            }
        }
    }

    protected void backupTimeStamp(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            File copy;
            SaveParameters timestampsave;
            save_config.savePathInConfig(Utilities.getElementName("Index") + "es");
            String save_dir = save_config.getStoreBasePath() + save_config.getAttribute("path", "");
            File file = new File(this.baseIndexDir + File.separator + "creation-timestamp");
            if (file.exists()) {
                timestampsave = new SaveParameters("timestamp", save_config);
                timestampsave.savePathInConfig(null);
                timestampsave.setAttribute("id", "creation");
                copy = new File(save_dir + File.separator + "creation-timestamp");
                try {
                    copy.createNewFile();
                    copy.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.getLog(), 8201, args, e);
                }
            }
            if ((file = new File(this.baseIndexDir + File.separator + "last-modification-timestamp")).exists()) {
                timestampsave = new SaveParameters("timestamp", save_config);
                timestampsave.setAttribute("id", "last-modification");
                timestampsave.savePathInConfig(null);
                copy = new File(save_dir + File.separator + "last-modification-timestamp");
                try {
                    copy.createNewFile();
                    copy.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.getLog(), 8201, args, e);
                }
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }

    protected void restoreIndexes(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected() && this.luceneSearchIndexList != null && this.luceneSearchIndexList.size() > 0) {
            Enumeration _enum = this.luceneSearchIndexList.elements();
            while (_enum.hasMoreElements()) {
                Index index = (Index)_enum.nextElement();
                if (index == null || !(index instanceof LuceneIndex)) continue;
                SaveParameters indexsave = save_config.getSaveParametersById(((LuceneIndex)index).getId());
                ((LuceneIndex)index).restore(indexsave);
            }
        }
    }

    protected void restoreTimeStamp(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            File copy;
            File file;
            String save_dir = save_config.getStoreCompletePath();
            SaveParameters timestampsave = save_config.getSaveParametersById("creation");
            if (timestampsave != null) {
                file = new File(save_dir + File.separator + "creation-timestamp");
                if (!file.exists()) {
                    String[] args = new String[]{this.getId(), file.getAbsolutePath() + " not found."};
                    throw new SDXException(this.getLog(), 8201, args, null);
                }
                copy = new File(this.baseIndexDir + File.separator + "creation-timestamp");
                try {
                    if (!copy.exists()) {
                        copy.createNewFile();
                    }
                    copy.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.getLog(), 8201, args, e);
                }
            }
            if ((timestampsave = save_config.getSaveParametersById("last-modification")) != null) {
                file = new File(save_dir + File.separator + "last-modification-timestamp");
                if (!file.exists()) {
                    String[] args = new String[]{this.getId(), file.getAbsolutePath() + " not found."};
                    throw new SDXException(this.getLog(), 8201, args, null);
                }
                copy = new File(this.baseIndexDir + File.separator + "last-modification-timestamp");
                try {
                    if (!copy.exists()) {
                        copy.createNewFile();
                    }
                    copy.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.getLog(), 8201, args, e);
                }
            }
        }
    }

    public int docCount() {
        int docCount = 0;
        for (int i = 0; i < this.luceneSearchIndexList.size(); ++i) {
            LuceneIndex li = (LuceneIndex)this.luceneSearchIndexList.get(i);
            docCount += li.docCount();
        }
        return docCount;
    }

    public void close() {
        super.close();
    }
}

