/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepository;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class ORACLERepository
extends JDBCRepository {
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        ConfigurationUtils.checkConfAttributeValue("dsi", this.dsi, configuration.getLocation());
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "data" + " BLOB, PRIMARY KEY (" + "id" + "))";
    }

    protected String getDocumentAddQuery() {
        return "INSERT INTO " + this.getTableName() + " (" + "id" + "," + "data" + ") VALUES (?, EMPTY_BLOB())";
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName();
        query = query + " LIMIT " + String.valueOf(offset) + "," + String.valueOf(number) + ";";
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentAddQuery();
        final InputStream is = doc.openStream();
        try {
            try {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                final String docId = doc.getId();
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException {
                        ps.setString(1, docId);
                    }
                };
                template.execute(qe, 1);
                conn.commit();
                JDBC.Template template2 = new JDBC.Template(conn, "SELECT data FROM " + this.getTableName() + " WHERE " + "id" + " = ? FOR UPDATE");
                JDBC.QueryExecutor qe2 = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException {
                        ps.clearParameters();
                        ps.setString(1, docId);
                    }

                    public void collect(ResultSet rs) throws SQLException, IOException {
                        if (rs.next()) {
                            BLOB oraBlob = ((OracleResultSet)rs).getBLOB("data");
                            OutputStream os = oraBlob.getBinaryOutputStream();
                            int chunk = oraBlob.getChunkSize();
                            byte[] buffer = new byte[chunk];
                            int length = -1;
                            while ((length = is.read(buffer)) != -1) {
                                os.write(buffer, 0, length);
                            }
                            os.flush();
                            os.close();
                        }
                    }
                };
                conn.setAutoCommit(false);
                template2.execute(qe2, 0);
                conn.commit();
            }
            catch (SQLException e) {
                String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3000, args, e);
            }
            Object var12_13 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SDXException(super.getLog(), 219, null, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new SDXException(super.getLog(), 219, null, e);
        }
        is.close();
    }

    public void get(Document doc, final OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkOutputStream(super.getLog(), os);
        this.checkConnection(c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentGetQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                }

                public void collect(ResultSet rs) throws SQLException, IOException {
                    if (rs.next()) {
                        BLOB oraBlob = ((OracleResultSet)rs).getBLOB("data");
                        IOUtil.copy((InputStream)oraBlob.getBinaryStream(), (OutputStream)os);
                    }
                }
            };
            template.execute(qe, 0);
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, (Throwable)((Object)e));
        }
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
        encoding = this.checkEncoding(encoding);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentGetQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                InputStream l_is = null;

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                }

                public void collect(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        BLOB oraBlob = ((OracleResultSet)rs).getBLOB("data");
                        this.l_is = oraBlob.getBinaryStream();
                    }
                }

                public InputStream getInputStream() {
                    return this.l_is;
                }
            };
            template.execute(qe, 0);
            InputStream is = qe.getInputStream();
            if (is == null) {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(super.getLog(), 3001, args, null);
            }
            return is;
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createTable(Connection conn) throws SDXException {
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(this.getTableCreationQuery());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getTableName(), e.getMessage()};
                if (e.getErrorCode() != 955) {
                    throw new SDXException(super.getLog(), 3202, args, e);
                }
                Object var6_4 = null;
                if (ps == null) return;
                try {
                    ps.close();
                    return;
                }
                catch (SQLException e1) {
                    String[] args1 = new String[]{this.getId(), e1.getMessage()};
                    throw new SDXException(super.getLog(), 3203, args1, e1);
                }
            }
            Object var6_3 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (ps == null) throw throwable;
            try {}
            catch (SQLException e1) {
                String[] args1 = new String[]{this.getId(), e1.getMessage()};
                throw new SDXException(super.getLog(), 3203, args1, e1);
            }
            ps.close();
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            String[] args1 = new String[]{this.getId(), e1.getMessage()};
            throw new SDXException(super.getLog(), 3203, args1, e1);
        }
        ps.close();
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "ORACLE");
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

