/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.documentbase.LuceneIndexParameters;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.search.lucene.analysis.MetaAnalyzer;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.RemoteIndex;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.SdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.lucene.LuceneDataStore;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndex
extends LuceneDataStore
implements SdxObject,
Index {
    private boolean _isSub = false;
    private String appId = "";
    private String dbId = "";
    private FieldList fields = null;
    private RAMDirectory tempBatch = null;
    public String CURRENT_INDEX_DIR = "current";
    private MetaAnalyzer metaAnalyzer = null;
    private Class queryParserClass = null;
    private static final String DEFAULT_QUERYPARSER = "fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser";
    private String remoteIndexName = "";
    private String rmiHost = "";
    private int rmiPort;
    protected java.util.Date creationTimestamp = null;
    protected java.util.Date lastModificationTimestamp = null;
    public static final int ACTION_ADD_DOCUMENT = 1;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    private int maxFieldLength = 10000;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private static final String ELEMENT_NAME_QUERYPARSER = "queryParser";
    private static final String ATTRIBUTE_CLASS = "class";
    private final String ATTRIBUTE_MAX_FIELD_LENGTH = "maxFieldLength";
    private int _docCount = -1;
    FilenameFilter indexContentFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !Utilities.isNameMatchIndexFiles(name) && !name.startsWith("current");
        }
    };

    public LuceneIndex(File dir, String host, Integer port, String appId, String dbId) throws SDXException {
        super(dir);
        this.appId = appId;
        this.dbId = dbId;
        if (Utilities.checkString(host)) {
            this.rmiHost = host;
        }
        this.rmiPort = port != null ? port : 9000;
        if (Utilities.checkString(appId) && Utilities.checkString(dbId)) {
            this.remoteIndexName = Utilities.buildRmiName(this.rmiHost, this.rmiPort, appId, dbId);
        }
    }

    public LuceneIndex(File dir, String host, Integer port, String appId, String dbId, boolean useCompoundFiles) throws SDXException {
        super(dir);
        this.appId = appId;
        this.dbId = dbId;
        this.useCompoundFiles = useCompoundFiles;
        if (Utilities.checkString(host)) {
            this.rmiHost = host;
        }
        this.rmiPort = port != null ? port : 9000;
        if (Utilities.checkString(appId) && Utilities.checkString(dbId)) {
            this.remoteIndexName = Utilities.buildRmiName(this.rmiHost, this.rmiPort, appId, dbId);
        }
    }

    public LuceneIndex(LuceneIndex parentIndex, File dir) {
        super(dir);
        this._isSub = true;
        this.appId = parentIndex.appId;
        this.dbId = parentIndex.dbId;
        this.rmiHost = parentIndex.rmiHost;
        this.rmiPort = parentIndex.rmiPort;
        this.useCompoundFiles = parentIndex.useCompoundFiles;
        this.remoteIndexName = Utilities.buildRmiName(this.rmiHost, this.rmiPort, this.appId, this.dbId);
    }

    public LuceneIndex(LuceneIndex parentIndex) {
        super(new File(parentIndex.fsdFile.getAbsolutePath() + File.separator + "current"));
        this._isSub = true;
        this.appId = parentIndex.appId;
        this.dbId = parentIndex.dbId;
        this.rmiHost = parentIndex.rmiHost;
        this.rmiPort = parentIndex.rmiPort;
        this.useCompoundFiles = parentIndex.useCompoundFiles;
        this.remoteIndexName = Utilities.buildRmiName(this.rmiHost, this.rmiPort, this.appId, this.dbId);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configureQueryParser(configuration);
        boolean remoteConf = configuration.getAttributeAsBoolean("remote-access", false);
        if (!remoteConf) {
            this.remoteIndexName = null;
        }
        if (remoteConf) {
            try {
                this.bindRemoteObjectToRegistry(this.remoteIndexName, new RemoteIndex(this));
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            catch (RemoteException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        this.maxFieldLength = configuration.getAttributeAsInteger("maxFieldLength", 10000);
    }

    private void configureQueryParser(Configuration configuration) throws ConfigurationException {
        Configuration qpConf = configuration.getChild(ELEMENT_NAME_QUERYPARSER, false);
        String qpClassName = DEFAULT_QUERYPARSER;
        if (qpConf != null) {
            qpClassName = qpConf.getAttribute(ATTRIBUTE_CLASS, DEFAULT_QUERYPARSER);
        }
        try {
            this.queryParserClass = Class.forName(qpClassName);
        }
        catch (ClassNotFoundException e) {
            SDXException sdxE = new SDXException(super.getLog(), 37, null, e);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
    }

    private void bindRemoteObjectToRegistry(String name, Remote obj) throws SDXException {
        try {
            Naming.rebind(name, obj);
        }
        catch (IOException e) {
            String[] args = new String[]{name};
            throw new SDXException(super.getLog(), 38, args, e);
        }
    }

    public void init() throws SDXException {
        if (!this.isSubIndex()) {
            super.init(false);
        } else {
            super.init(false);
        }
        if (!this._isSub) {
            this.writeCreationTimestampFile();
            this.indexModified(false);
        }
        if (this.metaAnalyzer == null) {
            throw new SDXException(super.getLog(), 4102, null, null);
        }
    }

    protected void writeCreationTimestampFile() {
        try {
            File createFile = new File(this.fsdFile.getParentFile(), "creation-timestamp");
            if (!createFile.exists()) {
                createFile.createNewFile();
            }
            this.creationTimestamp = new java.util.Date(createFile.lastModified());
        }
        catch (IOException e) {
            LoggingUtils.logError(super.getLog(), e.getMessage(), e);
        }
    }

    public void indexModified(boolean createLastModficationTimestampFile) throws SDXException {
        this.writeLastModificationTimestampFile(createLastModficationTimestampFile);
    }

    protected void setDocCount(int i) {
        this._docCount = i;
    }

    public int docCount() {
        return this._docCount;
    }

    public void writeLastModificationTimestampFile(boolean create) {
        try {
            java.util.Date now = new java.util.Date();
            File lastModFile = new File(this.fsdFile.getParentFile(), "last-modification-timestamp");
            if (!lastModFile.exists()) {
                lastModFile.createNewFile();
            }
            lastModFile.setLastModified(now.getTime());
            this.lastModificationTimestamp = now;
        }
        catch (IOException e) {
            LoggingUtils.logError(super.getLog(), e.getMessage(), e);
        }
    }

    public int getFieldType(String name) {
        return this.fields.getFieldType(name);
    }

    public Locale getLocale(String name) {
        return this.fields.getLocale(name);
    }

    public Field getDefaultField() {
        return this.fields.getDefaultField();
    }

    public Field getField(String name) {
        return this.fields.getField(name);
    }

    public MetaAnalyzer getMetaAnalyzer() {
        return this.metaAnalyzer;
    }

    public void setMetaAnalyzer(MetaAnalyzer mAnalyzer) throws SDXException {
        this.metaAnalyzer = mAnalyzer;
        this.fields = this.metaAnalyzer.getFieldList();
        this.analyzer = this.metaAnalyzer;
    }

    public synchronized void writeDocument(Document ldoc, boolean batchIndex) throws SDXException {
        this.writeDocument(ldoc, batchIndex, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void writeDocument(Document ldoc, boolean batchIndex, boolean autoOptimize) throws SDXException {
        IndexWriter w = null;
        try {
            block10: {
                try {
                    if (!autoOptimize || !batchIndex) {
                        this.write(ldoc);
                        break block10;
                    }
                    if (batchIndex && this.tempBatch == null) {
                        this.tempBatch = new RAMDirectory();
                        IndexWriter initTempBatch = new IndexWriter((Directory)this.tempBatch, (Analyzer)this.getMetaAnalyzer(), true);
                        initTempBatch.setUseCompoundFile(this.useCompoundFiles);
                        initTempBatch.close();
                    }
                    if (this.tempBatch != null && (w = this.getWriter((Directory)this.tempBatch)) != null) {
                        w.addDocument(ldoc);
                        w.close();
                        w = null;
                    }
                }
                catch (IOException e) {
                    String[] args = new String[]{super.getIndexPath(), e.getMessage()};
                    throw new SDXException(super.getLog(), 204, args, e);
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (w == null) throw throwable;
                w.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{super.getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 204, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{super.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
        if (w == null) return;
        w.close();
    }

    public synchronized void recycleLuceneIndexSearcher() throws SDXException {
        this.recycleSearcher();
    }

    public synchronized void recycleIndexReader() throws SDXException {
        try {
            IndexWriter w = this.getWriter((Directory)this.fsd);
            if (w == null) {
                w = this.getWriter();
            }
            if (w == null) {
                w = new IndexWriter((Directory)this.fsd, this.analyzer, false);
            }
            w.close();
        }
        catch (IOException e) {
            String[] args = new String[]{super.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
    }

    public synchronized void deleteDocument(String docId) throws SDXException {
        super.delete(docId);
    }

    public QueryParser getQueryParser() throws IOException, SDXException {
        try {
            if (this.queryParserClass == null) {
                return null;
            }
            return (QueryParser)this.queryParserClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SDXException(super.getLog(), 4110, null, e);
        }
        catch (IllegalAccessException e) {
            throw new SDXException(super.getLog(), 4110, null, e);
        }
    }

    public String getRemoteIndexName() {
        return this.remoteIndexName;
    }

    public void freeResources() throws IOException {
        if (this.tempBatch != null) {
            this.tempBatch.close();
            this.tempBatch = null;
        }
        super.freeResources();
    }

    public void setParameters(LuceneIndexParameters params) {
        this.maxMergeDocs = params.getMaxMergeDocs();
        this.mergeFactor = params.getMergeFactor();
    }

    public synchronized IndexReader getReader() throws SDXException {
        return super.getReader();
    }

    protected synchronized IndexWriter getWriter(Directory directory) throws IOException {
        IndexWriter w = super.getWriter(directory);
        if (this.maxFieldLength != 10000) {
            w.maxFieldLength = this.maxFieldLength;
        }
        if (this.maxMergeDocs != Integer.MAX_VALUE) {
            w.maxMergeDocs = this.maxMergeDocs;
        }
        if (this.mergeFactor != 10) {
            w.mergeFactor = this.mergeFactor;
        }
        return w;
    }

    public Searchable getSearcher() {
        return super.getSearcher();
    }

    public String getFieldValue(IndexableDocument doc, String fieldName) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        if (!Utilities.checkString(fieldName)) {
            return null;
        }
        Hits h = this.search((Query)new TermQuery(new Term("sdxdocid", doc.getId())));
        if (h.length() == 1) {
            try {
                org.apache.lucene.document.Field field = h.doc(0).getField(fieldName);
                if (field != null) {
                    return field.stringValue();
                }
                return null;
            }
            catch (IOException e) {
                String[] args = new String[]{this.fsd.toString(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
        }
        return null;
    }

    public java.util.Date getCreationDate() {
        return this.creationTimestamp;
    }

    public java.util.Date getLastModificationDate() {
        return this.lastModificationTimestamp;
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "searchLocation";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "engine", "engine", "CDATA", "lucene");
        if (Utilities.checkString(this.appId)) {
            atts.addAttribute("", "app", "app", "CDATA", this.appId);
        }
        if (Utilities.checkString(this.dbId)) {
            atts.addAttribute("", "base", "base", "CDATA", this.dbId);
        }
        atts.addAttribute("", "creationDate", "creationDate", "CDATA", Date.formatUtcISO8601Date(this.getCreationDate()));
        atts.addAttribute("", "lastModificationDate", "lastModificationDate", "CDATA", Date.formatUtcISO8601Date(this.getLastModificationDate()));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        hdl.endElement(sdxNsUri, localName, qName);
    }

    protected String getClassNameSuffix() {
        return "Index";
    }

    public synchronized void optimize() throws SDXException {
        try {
            IndexWriter w = new IndexWriter(this.fsdFile, (Analyzer)this.getMetaAnalyzer(), false);
            w.optimize();
            w.close();
            w = null;
        }
        catch (IOException e) {
            String[] args = new String[]{super.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
    }

    public synchronized void mergeCurrentBatch(boolean optimize) throws SDXException {
        if (!this.fsdFile.exists() || this.fsd == null) {
            return;
        }
        if (this.tempBatch == null) {
            return;
        }
        try {
            File tmpDir = new File(this.fsdFile.getParent(), "sdx_tmp");
            File tmpNewDir = Utilities.createTempDirectory(super.getLog(), "new", "Index", tmpDir);
            tmpNewDir.delete();
            Directory[] dirs = new Directory[]{this.fsd, this.tempBatch};
            Utilities.checkDirectory(tmpNewDir.getAbsolutePath(), super.getLog());
            FSDirectory tempNewLuceneDir = super.getFSDirectory(tmpNewDir, true);
            IndexWriter w = new IndexWriter((Directory)tempNewLuceneDir, (Analyzer)this.getMetaAnalyzer(), true);
            w.setUseCompoundFile(this.useCompoundFiles);
            w.addIndexes(dirs);
            w.close();
            w = null;
            tempNewLuceneDir.close();
            tempNewLuceneDir = null;
            this.freeResources();
            FileUtil.deleteDirectory((File)this.fsdFile);
            Utilities.safeCopy(tmpNewDir, this.fsdFile);
            this.init();
            FileUtil.deleteDirectory((File)tmpDir);
        }
        catch (IOException e) {
            String[] args = new String[]{super.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
    }

    public boolean isSubIndex() {
        return this._isSub;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

