/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRuleBuilder;
import org.apache.cocoon.forms.datatype.validationruleimpl.ValueCountValidationRule;
import org.apache.cocoon.forms.util.DomHelper;
import org.outerj.expression.Expression;
import org.w3c.dom.Element;

public class ValueCountValidationRuleBuilder
extends AbstractValidationRuleBuilder {
    public ValidationRule build(Element validationRuleElement) throws Exception {
        ValueCountValidationRule rule = new ValueCountValidationRule();
        String exactExprString = validationRuleElement.getAttribute("exact");
        String minExprString = validationRuleElement.getAttribute("min");
        String maxExprString = validationRuleElement.getAttribute("max");
        if (exactExprString.length() > 0) {
            Expression expression = this.parseExpression(exactExprString, validationRuleElement, "exact");
            rule.setExactExpr(expression);
        } else if (minExprString.length() > 0 && maxExprString.length() > 0) {
            Expression expression = this.parseExpression(minExprString, validationRuleElement, "min");
            rule.setMinExpr(expression);
            expression = this.parseExpression(maxExprString, validationRuleElement, "max");
            rule.setMaxExpr(expression);
        } else if (minExprString.length() > 0) {
            Expression expression = this.parseExpression(minExprString, validationRuleElement, "min");
            rule.setMinExpr(expression);
        } else if (maxExprString.length() > 0) {
            Expression expression = this.parseExpression(maxExprString, validationRuleElement, "max");
            rule.setMaxExpr(expression);
        } else {
            throw new Exception("value-count validation rule requires a min and/or max, or exact attribute at " + DomHelper.getLocation(validationRuleElement));
        }
        this.buildFailMessage(validationRuleElement, rule);
        return rule;
    }
}

