/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.bean.BeanListener;
import org.apache.cocoon.bean.CocoonWrapper;
import org.apache.cocoon.bean.Target;
import org.apache.cocoon.bean.helpers.Crawler;
import org.apache.cocoon.bean.helpers.DelayedOutputStream;
import org.apache.cocoon.components.notification.DefaultNotifyingBuilder;
import org.apache.cocoon.components.notification.Notifier;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.SimpleNotifyingBean;
import org.apache.cocoon.matching.helpers.WildcardHelper;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;

public class CocoonBean
extends CocoonWrapper {
    private boolean followLinks = true;
    private boolean precompileOnly = false;
    private boolean confirmExtension = true;
    private String defaultFilename = "index";
    private boolean brokenLinkGenerate = false;
    private String brokenLinkExtension = "";
    private List excludePatterns = new ArrayList();
    private List includePatterns = new ArrayList();
    private List includeLinkExtensions = null;
    private boolean initialized;
    private List listeners = new ArrayList();
    private boolean verbose;
    SourceResolver sourceResolver;
    private Crawler crawler = new Crawler();
    private String checksumsURI = null;
    private Map checksums;

    public void initialize() throws Exception {
        if (!this.initialized) {
            super.initialize();
            this.sourceResolver = (SourceResolver)this.getComponentManager().lookup(SourceResolver.ROLE);
            this.initialized = true;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void setFollowLinks(boolean follow) {
        this.followLinks = follow;
    }

    public void setConfirmExtensions(boolean confirmExtension) {
        this.confirmExtension = confirmExtension;
    }

    public void setPrecompileOnly(boolean precompileOnly) {
        this.precompileOnly = precompileOnly;
    }

    public boolean isPrecompileOnly() {
        return this.precompileOnly;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDefaultFilename(String filename) {
        this.defaultFilename = filename;
    }

    public void setBrokenLinkGenerate(boolean brokenLinkGenerate) {
        this.brokenLinkGenerate = brokenLinkGenerate;
    }

    public void setBrokenLinkExtension(String brokenLinkExtension) {
        this.brokenLinkExtension = brokenLinkExtension;
    }

    public void setChecksumURI(String uri) {
        this.checksumsURI = uri;
    }

    public boolean followLinks() {
        return this.followLinks;
    }

    public boolean confirmExtensions() {
        return this.confirmExtension;
    }

    public void addTarget(String type, String root, String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(type, root, sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.crawler.addTarget(target);
    }

    public void addTarget(String type, String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(type, sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.crawler.addTarget(target);
    }

    public void addTarget(String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.crawler.addTarget(target);
    }

    public void addTargets(List uris, String destURI) throws IllegalArgumentException {
        Iterator i = uris.iterator();
        while (i.hasNext()) {
            Target target = new Target((String)i.next(), destURI);
            target.setDefaultFilename(this.defaultFilename);
            target.setFollowLinks(this.followLinks);
            target.setConfirmExtension(this.confirmExtension);
            target.setLogger(this.logger);
            this.crawler.addTarget(target);
        }
    }

    public void addTarget(String type, String root, String sourceURI, String destURI, boolean followLinks, boolean confirmExtension, String logger) throws IllegalArgumentException {
        Target target = root == null && type == null ? new Target(sourceURI, destURI) : (root == null ? new Target(type, sourceURI, destURI) : new Target(type, root, sourceURI, destURI));
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(followLinks);
        target.setConfirmExtension(confirmExtension);
        target.setLogger(logger);
        this.crawler.addTarget(target);
    }

    public int getTargetCount() {
        return this.crawler.getRemainingCount();
    }

    public void addExcludePattern(String pattern) {
        int[] preparedPattern = WildcardHelper.compilePattern(pattern);
        this.excludePatterns.add(preparedPattern);
    }

    public void addIncludePattern(String pattern) {
        int[] preparedPattern = WildcardHelper.compilePattern(pattern);
        this.includePatterns.add(preparedPattern);
    }

    public void addIncludeLinkExtension(String extension) {
        if (this.includeLinkExtensions == null) {
            this.includeLinkExtensions = new ArrayList();
        }
        this.includeLinkExtensions.add(extension);
    }

    public void addListener(BeanListener listener) {
        this.listeners.add(listener);
    }

    public void pageGenerated(String sourceURI, String destURI, int pageSize, int linksInPage, int newLinksInPage, int pagesRemaining, int pagesComplete, long timeTaken) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.pageGenerated(sourceURI, destURI, pageSize, linksInPage, newLinksInPage, pagesRemaining, pagesComplete, timeTaken);
        }
    }

    public void sendMessage(String msg) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.messageGenerated(msg);
        }
    }

    public void sendWarning(String uri, String warning) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.warningGenerated(uri, warning);
        }
    }

    public void sendBrokenLinkWarning(String uri, String warning) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.brokenLinkFound(uri, "", warning, null);
        }
    }

    public void pageSkipped(String uri, String message) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.pageSkipped(uri, message);
        }
    }

    public void dispose() {
        if (this.initialized) {
            if (this.sourceResolver != null) {
                this.getComponentManager().release((Component)this.sourceResolver);
                this.sourceResolver = null;
            }
            super.dispose();
        }
    }

    public void process() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.crawler.getRemainingCount() == 0 && !this.precompileOnly) {
            CocoonWrapper.log.info("No targets for to be processed.");
            return;
        }
        if (this.checksumsURI != null) {
            this.readChecksumFile();
        }
        if (this.crawler.getRemainingCount() >= 0) {
            Crawler.CrawlingIterator iterator = this.crawler.iterator();
            while (iterator.hasNext()) {
                Target target = (Target)iterator.next();
                if (this.precompileOnly) continue;
                this.processTarget(this.crawler, target);
            }
        }
        if (this.checksumsURI != null) {
            this.writeChecksumFile();
        }
        if (CocoonWrapper.log.isInfoEnabled()) {
            CocoonWrapper.log.info("  Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            CocoonWrapper.log.info("  Processed, Translated & Left: " + this.crawler.getProcessedCount() + ", " + this.crawler.getTranslatedCount() + ", " + this.crawler.getRemainingCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTarget(Crawler crawler, Target target) throws Exception {
        block36: {
            int status = 0;
            int linkCount = 0;
            int newLinkCount = 0;
            int pageSize = 0;
            long startTimeMillis = System.currentTimeMillis();
            if (target.confirmExtensions() && !crawler.hasTranslatedLink(target)) {
                String mimeType = this.getType(target.getDeparameterizedSourceURI(), target.getParameters());
                target.setMimeType(mimeType);
                crawler.addTranslatedLink(target);
            }
            HashMap<String, String> translatedLinks = new HashMap<String, String>();
            if (target.followLinks() && target.confirmExtensions() && this.isCrawlablePage(target)) {
                Iterator i = this.getLinks(target.getDeparameterizedSourceURI(), target.getParameters()).iterator();
                while (i.hasNext()) {
                    Target linkTarget;
                    block35: {
                        String linkURI = (String)i.next();
                        linkTarget = target.getDerivedTarget(linkURI);
                        if (linkTarget == null) {
                            this.pageSkipped(linkURI, "link does not share same root as parent");
                            continue;
                        }
                        if (!this.isIncluded(linkTarget.getSourceURI())) {
                            this.pageSkipped(linkTarget.getSourceURI(), "matched include/exclude rules");
                            continue;
                        }
                        if (!crawler.hasTranslatedLink(linkTarget)) {
                            try {
                                String mimeType = this.getType(linkTarget.getDeparameterizedSourceURI(), linkTarget.getParameters());
                                linkTarget.setMimeType(mimeType);
                                crawler.addTranslatedLink(linkTarget);
                                CocoonWrapper.log.info("  Link translated: " + linkTarget.getSourceURI());
                                if (crawler.addTarget(linkTarget)) {
                                    ++newLinkCount;
                                }
                                break block35;
                            }
                            catch (ProcessingException pe) {
                                this.sendBrokenLinkWarning(linkTarget.getSourceURI(), pe.getMessage());
                                if (this.brokenLinkGenerate && crawler.addTarget(linkTarget)) {
                                    ++newLinkCount;
                                }
                                break block35;
                            }
                        }
                        String originalURI = linkTarget.getOriginalSourceURI();
                        linkTarget = crawler.getTranslatedLink(linkTarget);
                        linkTarget.setOriginalURI(originalURI);
                    }
                    translatedLinks.put(linkTarget.getOriginalSourceURI(), linkTarget.getTranslatedURI(target.getPath()));
                }
                linkCount = translatedLinks.size();
            }
            try {
                DelayedOutputStream output = new DelayedOutputStream();
                try {
                    ArrayList gatheredLinks = !target.confirmExtensions() && target.followLinks() && this.isCrawlablePage(target) ? new ArrayList() : null;
                    status = this.getPage(target.getDeparameterizedSourceURI(), this.getLastModified(target), target.getParameters(), target.confirmExtensions() ? translatedLinks : null, gatheredLinks, output);
                    if (status >= 400) {
                        throw new ProcessingException("Resource not found: " + status);
                    }
                    if (gatheredLinks == null) break block36;
                    Iterator it = gatheredLinks.iterator();
                    while (it.hasNext()) {
                        String linkURI = (String)it.next();
                        Target linkTarget = target.getDerivedTarget(linkURI);
                        if (linkTarget == null) {
                            this.pageSkipped(linkURI, "link does not share same root as parent");
                            continue;
                        }
                        if (!this.isIncluded(linkTarget.getSourceURI())) {
                            this.pageSkipped(linkTarget.getSourceURI(), "matched include/exclude rules");
                            continue;
                        }
                        if (!crawler.addTarget(linkTarget)) continue;
                        ++newLinkCount;
                    }
                    linkCount = gatheredLinks.size();
                }
                catch (ProcessingException pe) {
                    output.close();
                    output = null;
                    this.resourceUnavailable(target);
                    this.sendBrokenLinkWarning(target.getSourceURI(), DefaultNotifyingBuilder.getRootCause((Throwable)((Object)pe)).getMessage());
                }
                finally {
                    if (output != null && status != -1) {
                        ModifiableSource source = this.getSource(target);
                        try {
                            block37: {
                                try {
                                    pageSize = output.size();
                                    if (this.checksumsURI == null || !this.isSameContent(output, target)) {
                                        OutputStream stream = source.getOutputStream();
                                        output.setFileOutputStream(stream);
                                        output.flush();
                                        output.close();
                                        this.pageGenerated(target.getSourceURI(), target.getAuthlessDestURI(), pageSize, linkCount, newLinkCount, crawler.getRemainingCount(), crawler.getProcessedCount(), System.currentTimeMillis() - startTimeMillis);
                                        break block37;
                                    }
                                    output.close();
                                    this.pageSkipped(target.getSourceURI(), "Page not changed");
                                }
                                catch (IOException ioex) {
                                    CocoonWrapper.log.warn(ioex.toString());
                                    Object var18_24 = null;
                                    this.releaseSource((Source)source);
                                }
                            }
                            Object var18_23 = null;
                            this.releaseSource((Source)source);
                        }
                        catch (Throwable throwable) {
                            Object var18_25 = null;
                            this.releaseSource((Source)source);
                            throw throwable;
                        }
                    }
                }
            }
            catch (Exception rnfe) {
                CocoonWrapper.log.warn("Could not process URI: " + target.getSourceURI());
                rnfe.printStackTrace();
                this.sendBrokenLinkWarning(target.getSourceURI(), "URI not found: " + rnfe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceUnavailable(Target target) throws IOException, ProcessingException {
        if (this.brokenLinkGenerate) {
            if (this.brokenLinkExtension != null) {
                target.setExtraExtension(this.brokenLinkExtension);
            }
            SimpleNotifyingBean n = new SimpleNotifyingBean(this);
            n.setType("resource-not-found");
            n.setTitle("Resource not Found");
            n.setSource("Cocoon commandline (Main.java)");
            n.setMessage("Page Not Available.");
            n.setDescription("The requested resource couldn't be found.");
            n.addExtraDescription("request-uri", target.getSourceURI());
            n.addExtraDescription("missing-file", target.getSourceURI());
            ModifiableSource source = this.getSource(target);
            try {
                OutputStream stream = source.getOutputStream();
                PrintStream out = new PrintStream(stream);
                Notifier.notify((Notifying)n, out, "text/html");
                out.flush();
                out.close();
                Object var7_6 = null;
                this.releaseSource((Source)source);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseSource((Source)source);
                throw throwable;
            }
        }
    }

    public ModifiableSource getSource(Target target) throws IOException, ProcessingException {
        String finalDestinationURI = target.getDestinationURI();
        Source src = this.sourceResolver.resolveURI(finalDestinationURI);
        if (!(src instanceof ModifiableSource)) {
            this.sourceResolver.release(src);
            throw new ProcessingException("Source is not Modifiable: " + finalDestinationURI);
        }
        return (ModifiableSource)src;
    }

    public long getLastModified(Target target) throws IOException, ProcessingException {
        ModifiableSource src = this.getSource(target);
        long lastModified = src.getLastModified();
        this.releaseSource((Source)src);
        return lastModified;
    }

    public void releaseSource(Source source) {
        this.sourceResolver.release(source);
    }

    private boolean isIncluded(String uri) {
        int[] pattern;
        Iterator i;
        boolean included;
        HashMap map = new HashMap();
        if (this.includePatterns.size() == 0) {
            included = true;
        } else {
            included = false;
            i = this.includePatterns.iterator();
            while (i.hasNext()) {
                pattern = (int[])i.next();
                if (!WildcardHelper.match(map, uri, pattern)) continue;
                included = true;
                break;
            }
        }
        if (this.excludePatterns.size() != 0) {
            i = this.excludePatterns.iterator();
            while (i.hasNext()) {
                pattern = (int[])i.next();
                if (!WildcardHelper.match(map, uri, pattern)) continue;
                included = false;
                break;
            }
        }
        return included;
    }

    private boolean isCrawlablePage(Target target) {
        if (this.includeLinkExtensions == null) {
            return true;
        }
        return this.includeLinkExtensions.contains(target.getExtension());
    }

    /*
     * WARNING - void declaration
     */
    private void readChecksumFile() throws Exception {
        this.checksums = new HashMap();
        try {
            String line;
            Source checksumSource = this.sourceResolver.resolveURI(this.checksumsURI);
            BufferedReader reader = new BufferedReader(new InputStreamReader(checksumSource.getInputStream()));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                void var3_5;
                ++lineNo;
                if (var3_5.trim().startsWith("#") || var3_5.trim().length() == 0) continue;
                if (var3_5.indexOf("\t") == -1) {
                    throw new ProcessingException("Missing tab at line " + lineNo + " of " + this.checksumsURI);
                }
                String filename = var3_5.substring(0, var3_5.indexOf("\t"));
                String checksum = var3_5.substring(var3_5.indexOf("\t") + 1);
                this.checksums.put(filename, checksum);
            }
            reader.close();
        }
        catch (SourceNotFoundException e) {}
    }

    private void writeChecksumFile() throws Exception {
        Source checksumSource = this.sourceResolver.resolveURI(this.checksumsURI);
        if (!(checksumSource instanceof ModifiableSource)) {
            throw new ProcessingException("Checksum file is not Modifiable:" + checksumSource);
        }
        ModifiableSource source = (ModifiableSource)checksumSource;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(source.getOutputStream()));
        Iterator i = this.checksums.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String checksum = (String)this.checksums.get(key);
            writer.println(key + "\t" + checksum);
        }
        writer.close();
    }

    private boolean isSameContent(DelayedOutputStream stream, Target target) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(stream.getContent());
            String streamDigest = SourceUtil.encodeBASE64((String)new String(md5.digest()));
            String targetDigest = (String)this.checksums.get(target.getSourceURI());
            if (streamDigest.equals(targetDigest)) {
                return true;
            }
            this.checksums.put(target.getSourceURI(), streamDigest);
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static String getProlog() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("------------------------------------------------------------------------ ").append(lSep);
        msg.append(Constants.NAME).append(" ").append(Constants.VERSION).append(lSep);
        msg.append("Copyright (c) ").append(Constants.YEAR).append(" Apache Software Foundation. All rights reserved.").append(lSep);
        msg.append("------------------------------------------------------------------------ ").append(lSep).append(lSep);
        return msg.toString();
    }
}

