/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.CronJob;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.background.BackgroundEnvironment;
import org.apache.cocoon.util.NullOutputStream;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzJobExecutor
implements Job {
    static final String DATA_MAP_KEY_ISRUNNING = "QuartzJobExecutor.isRunning";
    static final OutputStream NULL_OUTPUT = new NullOutputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        BackgroundEnvironment env;
        Boolean isRunning;
        boolean canRunConcurrently;
        JobDataMap data = context.getJobDetail().getJobDataMap();
        data.put((Object)"QuartzJobScheduler.JobExecutionContext", (Object)context);
        Logger logger = (Logger)data.get((Object)"QuartzJobScheduler.Logger");
        String name = (String)data.get((Object)"QuartzJobScheduler.JobName");
        Boolean canRunConcurrentlyB = (Boolean)data.get((Object)"QuartzJobScheduler.RunConcurrently");
        boolean bl = canRunConcurrently = canRunConcurrentlyB == null ? true : canRunConcurrentlyB;
        if (!canRunConcurrently && null != (isRunning = (Boolean)data.get((Object)DATA_MAP_KEY_ISRUNNING)) && isRunning.booleanValue()) {
            logger.warn("Cron job name '" + name + " already running but configured to not allow concurrent runs. Will discard this scheduled run");
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Scheduling cron job named '" + name + "'");
        }
        Object job = null;
        String jobrole = null;
        ServiceManager manager = (ServiceManager)data.get((Object)"QuartzJobScheduler.ServiceManager");
        Context envContext = (Context)data.get((Object)"QuartzJobScheduler.EnvironmentContext");
        try {
            env = new BackgroundEnvironment(logger, envContext, manager);
        }
        catch (MalformedURLException mue) {
            throw new JobExecutionException((Exception)mue);
        }
        CocoonComponentManager.enterEnvironment((Environment)env, (ComponentManager)env.getManager(), (Processor)env.getProcessor());
        boolean release = false;
        try {
            jobrole = (String)data.get((Object)"QuartzJobScheduler.ROLE");
            if (null == jobrole) {
                job = data.get((Object)"QuartzJobScheduler.Object");
            } else {
                job = manager.lookup(jobrole);
                release = true;
            }
            if (job instanceof ConfigurableCronJob) {
                Parameters params = (Parameters)data.get((Object)"QuartzJobScheduler.Parameters");
                Map objects = (Map)data.get((Object)"QuartzJobScheduler.Map");
                ((ConfigurableCronJob)job).setup(params, objects);
            }
            data.put((Object)DATA_MAP_KEY_ISRUNNING, (Object)Boolean.TRUE);
            if (job instanceof Job) {
                ((Job)job).execute(context);
            } else if (job instanceof CronJob) {
                ((CronJob)job).execute(name);
            } else if (job instanceof Runnable) {
                ((Runnable)job).run();
            } else {
                logger.error("job named '" + name + "' is of invalid class: " + job.getClass().getName());
            }
        }
        catch (Throwable t) {
            logger.error("Cron job name '" + name + " died.", t);
            if (t instanceof JobExecutionException) {
                throw (JobExecutionException)t;
            }
        }
        finally {
            data.put((Object)DATA_MAP_KEY_ISRUNNING, (Object)Boolean.FALSE);
            CocoonComponentManager.leaveEnvironment();
            if (release && null != manager) {
                manager.release(job);
            }
        }
    }
}

