/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

import net.sourceforge.chaperon.common.Decoder;

public class SortedCharSet {
    private char elementCount = '\u0000';
    private char[] list = new char[10];

    public void addChar(char value) {
        if (this.list.length < this.elementCount + '\u0001') {
            char[] newList = new char[this.elementCount + 10];
            System.arraycopy(this.list, 0, newList, 0, this.list.length);
            this.list = newList;
        }
        char c = this.elementCount;
        this.elementCount = (char)(c + '\u0001');
        this.list[c] = value;
        this.sort();
    }

    public void addChar(char[] array) {
        if (this.list.length < this.elementCount + array.length) {
            char[] newList = new char[this.elementCount + array.length];
            System.arraycopy(this.list, 0, newList, 0, this.list.length);
            this.list = newList;
        }
        System.arraycopy(array, 0, this.list, this.elementCount, array.length);
        this.elementCount = (char)(this.elementCount + array.length);
        this.sort();
    }

    public void removeChar(char index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.elementCount = (char)(this.elementCount - '\u0001');
        if (index < this.elementCount) {
            System.arraycopy(this.list, index + '\u0001', this.list, index, this.elementCount - index);
        }
        this.list[this.elementCount] = '\u0000';
    }

    public char getChar(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.list[index];
    }

    public char[] getChar() {
        char[] newList = new char[this.elementCount];
        System.arraycopy(this.list, 0, newList, 0, this.elementCount);
        return newList;
    }

    public char getCharCount() {
        return this.elementCount;
    }

    public int indexOf(char value) {
        char i = '\u0000';
        while (i < this.elementCount) {
            if (this.list[i] == value) {
                return i;
            }
            i = (char)(i + '\u0001');
        }
        return -1;
    }

    public boolean contains(char value) {
        char i = '\u0000';
        while (i < this.elementCount) {
            if (this.list[i] == value) {
                return true;
            }
            i = (char)(i + '\u0001');
        }
        return false;
    }

    public boolean isEmpty() {
        return this.elementCount <= '\u0000';
    }

    public void clear() {
        this.elementCount = '\u0000';
    }

    private void sort() {
        boolean modified = false;
        do {
            modified = false;
            int i = 1;
            while (i < this.elementCount) {
                if (this.list[i - '\u0001'] > this.list[i]) {
                    char c = this.list[i - '\u0001'];
                    this.list[i - '\u0001'] = this.list[i];
                    this.list[i] = c;
                    modified = true;
                } else if (this.list[i - '\u0001'] == this.list[i]) {
                    if (i < this.elementCount - '\u0001') {
                        this.elementCount = (char)(this.elementCount - '\u0001');
                        this.list[i] = this.list[this.elementCount];
                    } else {
                        this.elementCount = (char)(this.elementCount - '\u0001');
                    }
                    modified = true;
                }
                ++i;
            }
        } while (modified);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        char i = '\u0000';
        while (i < this.elementCount) {
            buffer.append(Decoder.toChar(this.list[i]));
            if (i < this.elementCount - '\u0001') {
                buffer.append(",");
            }
            i = (char)(i + '\u0001');
        }
        buffer.append("]");
        return buffer.toString();
    }
}

