/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Gen;
import net.sf.pizzacompiler.compiler.Item;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.VarSymbol;

class MemberItem
extends Item {
    int pos;
    Symbol member;
    boolean nonvirtual;
    boolean selfref;

    MemberItem(int n, Symbol symbol, boolean bl, boolean bl2) {
        super(Gen.typecode(symbol.type));
        this.pos = n;
        this.member = symbol;
        this.nonvirtual = bl;
        this.selfref = bl2;
    }

    static Item make(int n, Symbol symbol, boolean bl, boolean bl2) {
        return new MemberItem(n, symbol, bl, bl2);
    }

    Item load() {
        if (this.selfref && (this.member.modifiers & 0x10) != 0) {
            Gen.checkInit(this.pos, (VarSymbol)this.member);
        }
        Gen.emitop(180, Gen.width(this.typecode) - 1);
        Gen.emit2(Gen.mkref(this.member));
        return Item.stackItem[this.typecode];
    }

    Item store() {
        if (this.selfref && (this.member.modifiers & 0x10) != 0) {
            Gen.checkFirstInit(this.pos, (VarSymbol)this.member);
        }
        Gen.emitop(181, -Gen.width(this.typecode) - 1);
        Gen.emit2(Gen.mkref(this.member));
        return Item.voidItem;
    }

    Item invoke() {
        Type.FunType funType = (Type.FunType)this.member.type;
        int n = Gen.width(funType.argtypes);
        int n2 = Gen.typecode(funType.restype);
        int n3 = Gen.width(n2) - n;
        if ((this.member.owner.modifiers & 0x200) != 0) {
            Gen.emitop(185, n3 - 1);
            Gen.emit2(Gen.mkref(this.member));
            Gen.emit1(n + 1);
            Gen.emit1(0);
        } else if (this.nonvirtual) {
            Gen.emitop(183, n3 - 1);
            Gen.emit2(Gen.mkref(this.member));
        } else {
            Gen.emitop(182, n3 - 1);
            Gen.emit2(Gen.mkref(this.member));
        }
        return Item.stackItem[n2];
    }

    void duplicate() {
        Item.stackItem[4].duplicate();
    }

    void drop() {
        Item.stackItem[4].drop();
    }

    void stash(int n) {
        Item.stackItem[4].stash(n);
    }
}

